/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import javax.jbi.management.ComponentLifeCycleMBean;
import javax.jbi.management.InstallerMBean;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.jmx.JMXService;
import org.ow2.petals.container.lifecycle.Installer;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.container.lifecycle.SharedLibraryLifeCycle;
import org.ow2.petals.jbi.management.MBeanNamesImpl;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.server.MBeanHelper;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.ParameterCheckHelper;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=AdminService.class)})
public class AdminServiceImpl
implements BindingController,
LifeCycleController,
AdminService {
    private LoggerFactory loggerFactory;
    protected LoggingUtil log;
    private Logger logger;
    @Requires(name="jmx", signature=JMXService.class)
    private JMXService jmxService;
    private Map<String, Installer> installersByName;
    private Map<ObjectName, ComponentLifeCycleMBean> bindingLifeCyclesByMBeanName;
    private Map<ObjectName, ComponentLifeCycleMBean> engineLifeCyclesByMBeanName;
    private Map<String, ComponentLifeCycleMBean> bindingLifeCyclesByName;
    private Map<String, ComponentLifeCycleMBean> engineLifeCyclesByName;
    private Map<String, SharedLibraryLifeCycle> sharedLibraryLifeCycles;
    private Map<String, ServiceAssemblyLifeCycle> serviceAssemblyLifeCycles;
    private MBeanNamesImpl mBeanNamesImpl;
    private MBeanServer mbeanServer;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public ObjectName[] getBindingComponents() {
        this.log.call();
        ObjectName[] objectNameArray = new ObjectName[]{};
        objectNameArray = this.bindingLifeCyclesByMBeanName.keySet().toArray(objectNameArray);
        return objectNameArray;
    }

    public ObjectName[] getEngineComponents() {
        this.log.call();
        ObjectName[] objectNameArray = new ObjectName[]{};
        objectNameArray = this.engineLifeCyclesByMBeanName.keySet().toArray(objectNameArray);
        return objectNameArray;
    }

    public ObjectName getComponentByName(String string) {
        this.log.call();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "name must not be null", this.log);
        ObjectName objectName = null;
        for (ObjectName objectName2 : this.bindingLifeCyclesByMBeanName.keySet()) {
            if (!string.equals(this.mBeanNamesImpl.getNameFromMBeanName(objectName2))) continue;
            objectName = objectName2;
            break;
        }
        if (objectName == null) {
            for (ObjectName objectName2 : this.engineLifeCyclesByMBeanName.keySet()) {
                if (!string.equals(this.mBeanNamesImpl.getNameFromMBeanName(objectName2))) continue;
                objectName = objectName2;
                break;
            }
        }
        return objectName;
    }

    public String getSystemInfo() {
        return "Petals JBI Container - version: " + Package.getPackage("org.ow2.petals").getImplementationVersion();
    }

    public ObjectName getSystemService(String string) {
        ObjectName[] objectNameArray;
        this.log.call();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "serviceName must not be null", this.log);
        ObjectName objectName = null;
        ObjectName[] objectNameArray2 = objectNameArray = this.getSystemServices();
        int n = objectNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectName objectName2 = objectNameArray2[n2];
            if (objectName2.getCanonicalName().equals(string)) {
                objectName = objectName2;
                break;
            }
            ++n2;
        }
        return objectName;
    }

    public ObjectName[] getSystemServices() {
        this.log.call();
        ObjectName[] objectNameArray = new ObjectName[3];
        try {
            objectNameArray[0] = MBeanHelper.retrieveServiceMBean("Admin", this.mbeanServer);
            objectNameArray[1] = MBeanHelper.retrieveServiceMBean("Deployment", this.mbeanServer);
            objectNameArray[2] = MBeanHelper.retrieveServiceMBean("Installation", this.mbeanServer);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            this.log.warning("A system service name can't be retrieved !", malformedObjectNameException);
        }
        return objectNameArray;
    }

    public boolean isBinding(String string) {
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName must not be null", this.log);
        return this.bindingLifeCyclesByName.containsKey(string);
    }

    public boolean isEngine(String string) {
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName must not be null", this.log);
        return this.engineLifeCyclesByName.containsKey(string);
    }

    @Override
    public boolean isExchangeWithConsumerOkayForComponent(String string, ServiceEndpoint serviceEndpoint, MessageExchange messageExchange) throws JBIException {
        this.log.start();
        Installer installer = this.installersByName.get(string);
        if (installer == null) {
            throw new JBIException("Cannot find a component '" + string + "' in the container");
        }
        boolean bl = installer.getComponent().isExchangeWithConsumerOkay(serviceEndpoint, messageExchange);
        this.log.end();
        return bl;
    }

    @Override
    public boolean isExchangeWithProviderOkayForComponent(String string, ServiceEndpoint serviceEndpoint, MessageExchange messageExchange) throws JBIException {
        this.log.start();
        Installer installer = this.installersByName.get(string);
        if (installer == null) {
            throw new JBIException("Cannot find a component '" + string + "' in the container");
        }
        boolean bl = installer.getComponent().isExchangeWithProviderOkay(serviceEndpoint, messageExchange);
        this.log.end();
        return bl;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("jmx")) {
            if (!JMXService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + JMXService.class.getName());
            }
            this.jmxService = (JMXService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public MBeanNamesImpl getMBeanNames() {
        return this.mBeanNamesImpl;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("jmx");
        return arrayList.toArray(new String[0]);
    }

    @Override
    public Document getServiceDescription(String string, ServiceEndpoint serviceEndpoint) throws PetalsException {
        this.log.start();
        Installer installer = this.installersByName.get(string);
        if (installer == null) {
            throw new PetalsException("Cannot find a component '" + string + "' in the container");
        }
        Document document = installer.getComponent().getServiceDescription(serviceEndpoint);
        this.log.end();
        return document;
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("jmx")) {
            return this.jmxService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("jmx")) {
            this.jmxService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public ComponentLifeCycleMBean getBindingComponentLifeCycleByName(String string) {
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "name must not be null or empty", this.log);
        this.log.call();
        return this.bindingLifeCyclesByName.get(string);
    }

    @Override
    public ComponentLifeCycleMBean getEngineComponentLifeCycleByName(String string) {
        this.log.call();
        return this.engineLifeCyclesByName.get(string);
    }

    @Override
    public Installer getInstallerByName(String string) {
        return this.installersByName.get(string);
    }

    @Override
    public ObjectName getInstallerMBeanNameByName(String string) {
        return this.mBeanNamesImpl.createInstallerMBeanName(string);
    }

    @Override
    public Installer[] getInstallers() {
        return this.installersByName.values().toArray(new Installer[this.installersByName.size()]);
    }

    @Override
    public ServiceAssemblyLifeCycle getServiceAssemblyByName(String string) {
        return this.serviceAssemblyLifeCycles.get(string);
    }

    @Override
    public Map<String, ServiceAssemblyLifeCycle> getServiceAssemblies() {
        return this.serviceAssemblyLifeCycles;
    }

    @Override
    public SharedLibraryLifeCycle getSharedLibraryByName(String string) {
        return this.sharedLibraryLifeCycles.get(string);
    }

    @Override
    public Map<String, SharedLibraryLifeCycle> getSharedLibraries() {
        return this.sharedLibraryLifeCycles;
    }

    @Override
    public Map<String, ComponentLifeCycleMBean> getBindingComponentsLifeCycles() {
        return this.bindingLifeCyclesByName;
    }

    @Override
    public Map<String, ComponentLifeCycleMBean> getServiceEnginesLifeCycles() {
        return this.engineLifeCyclesByName;
    }

    @Override
    public List<ServiceUnitLifeCycle> getServiceUnitsLifeCyclesForComponent(String string) {
        this.log.call();
        ArrayList<ServiceUnitLifeCycle> arrayList = new ArrayList<ServiceUnitLifeCycle>();
        for (ServiceAssemblyLifeCycle serviceAssemblyLifeCycle : this.serviceAssemblyLifeCycles.values()) {
            for (ServiceUnitLifeCycle serviceUnitLifeCycle : serviceAssemblyLifeCycle.getServiceUnitLifeCycles()) {
                if (!serviceUnitLifeCycle.getTargetComponentName().equals(string)) continue;
                arrayList.add(serviceUnitLifeCycle);
            }
        }
        return arrayList;
    }

    @Override
    public ObjectName registerBindingComponent(ComponentLifeCycleMBean componentLifeCycleMBean, String string) throws ManagementException {
        this.log.call();
        ObjectName objectName = this.mBeanNamesImpl.createBindingComponentMBeanName(string);
        try {
            this.mbeanServer.registerMBean(MBeanHelper.createCustomMBean(componentLifeCycleMBean, ComponentLifeCycleMBean.class), objectName);
            this.bindingLifeCyclesByMBeanName.put(objectName, componentLifeCycleMBean);
            this.bindingLifeCyclesByName.put(string, componentLifeCycleMBean);
        }
        catch (Exception exception) {
            throw new ManagementException(exception);
        }
        return objectName;
    }

    @Override
    public ObjectName registerEngineComponent(ComponentLifeCycleMBean componentLifeCycleMBean, String string) throws ManagementException {
        this.log.call();
        ObjectName objectName = this.mBeanNamesImpl.createEngineComponentMBeanName(string);
        try {
            this.mbeanServer.registerMBean(MBeanHelper.createCustomMBean(componentLifeCycleMBean, ComponentLifeCycleMBean.class), objectName);
            this.engineLifeCyclesByMBeanName.put(objectName, componentLifeCycleMBean);
            this.engineLifeCyclesByName.put(string, componentLifeCycleMBean);
        }
        catch (Exception exception) {
            throw new ManagementException(exception);
        }
        return objectName;
    }

    @Override
    public ObjectName registerInstaller(Installer installer, String string) throws ManagementException {
        this.log.call();
        ObjectName objectName = this.mBeanNamesImpl.createInstallerMBeanName(string);
        try {
            this.mbeanServer.registerMBean(MBeanHelper.createCustomMBean(installer, InstallerMBean.class), objectName);
            this.installersByName.put(string, installer);
        }
        catch (Exception exception) {
            throw new ManagementException(exception);
        }
        return objectName;
    }

    @Override
    public void registerServiceAssembly(ServiceAssemblyLifeCycle serviceAssemblyLifeCycle, String string) {
        this.log.call();
        this.serviceAssemblyLifeCycles.put(string, serviceAssemblyLifeCycle);
    }

    @Override
    public void registerSharedLibrary(SharedLibraryLifeCycle sharedLibraryLifeCycle, String string) {
        this.sharedLibraryLifeCycles.put(string, sharedLibraryLifeCycle);
    }

    @Override
    public void unregisterBindingComponent(String string) throws ManagementException {
        this.log.call();
        ObjectName objectName = this.mBeanNamesImpl.createBindingComponentMBeanName(string);
        try {
            this.mbeanServer.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new ManagementException("Failed to unregistered the binding Component '" + string + "'", instanceNotFoundException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new ManagementException("Failed to unregistered the binding Component '" + string + "'", mBeanRegistrationException);
        }
        this.bindingLifeCyclesByMBeanName.remove(objectName);
        this.bindingLifeCyclesByName.remove(string);
    }

    @Override
    public void unregisterEngineComponent(String string) throws ManagementException {
        this.log.call();
        ObjectName objectName = this.mBeanNamesImpl.createEngineComponentMBeanName(string);
        try {
            this.mbeanServer.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new ManagementException("Failed to unregistered the binding Component '" + string + "'", instanceNotFoundException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new ManagementException("Failed to unregistered the binding Component '" + string + "'", mBeanRegistrationException);
        }
        this.engineLifeCyclesByMBeanName.remove(objectName);
        this.engineLifeCyclesByName.remove(string);
    }

    @Override
    public void unregisterInstaller(String string) throws ManagementException {
        ObjectName objectName = this.mBeanNamesImpl.createInstallerMBeanName(string);
        try {
            this.mbeanServer.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new ManagementException("Failed to unregistered the binding Component '" + string + "'", instanceNotFoundException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new ManagementException("Failed to unregistered the binding Component '" + string + "'", mBeanRegistrationException);
        }
        this.installersByName.remove(string);
    }

    @Override
    public void unregisterServiceAssembly(String string) throws ManagementException {
        if (this.serviceAssemblyLifeCycles.remove(string) == null) {
            throw new ManagementException("Failed to unregistered the Service Assembly '" + string + "'");
        }
    }

    @Override
    public void unregisterSharedLibrary(String string) throws ManagementException {
        if (this.sharedLibraryLifeCycles.remove(string) == null) {
            throw new ManagementException("Failed to unregistered the Shared Library '" + string + "'");
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IllegalLifeCycleException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.mbeanServer = this.jmxService.getLocalJMXServer();
        this.mBeanNamesImpl = new MBeanNamesImpl("org.ow2.petals");
        this.bindingLifeCyclesByMBeanName = new ConcurrentHashMap<ObjectName, ComponentLifeCycleMBean>();
        this.engineLifeCyclesByMBeanName = new ConcurrentHashMap<ObjectName, ComponentLifeCycleMBean>();
        this.bindingLifeCyclesByName = new ConcurrentHashMap<String, ComponentLifeCycleMBean>();
        this.engineLifeCyclesByName = new ConcurrentHashMap<String, ComponentLifeCycleMBean>();
        this.serviceAssemblyLifeCycles = new ConcurrentHashMap<String, ServiceAssemblyLifeCycle>();
        this.installersByName = new ConcurrentHashMap<String, Installer>();
        this.sharedLibraryLifeCycles = Collections.synchronizedMap(new HashMap());
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws IllegalLifeCycleException {
        this.log.call();
    }
}

