/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.autoload;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.jmx.JMXService;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.autoload.AutoLoaderService;
import org.ow2.petals.jbi.management.autoload.InstallDirectoryScanner;
import org.ow2.petals.jbi.management.autoload.InstalledDirectoryScanner;
import org.ow2.petals.jbi.management.deployment.DeploymentServiceMBean;
import org.ow2.petals.jbi.management.installation.InstallationServiceMBean;
import org.ow2.petals.jbi.management.util.PackageHelper;
import org.ow2.petals.jbi.management.util.XMLResult;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.system.repository.RepositoryServiceImpl;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.systemstate.generated.Component;
import org.ow2.petals.systemstate.generated.ServiceAssembly;
import org.ow2.petals.systemstate.generated.SharedLibrary;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=AutoLoaderService.class)})
public class AutoLoaderServiceImpl
implements BindingController,
LifeCycleController,
AutoLoaderService {
    private LoggerFactory loggerFactory;
    private static File installDirectory;
    private static File installedDirectory;
    private static final long TIMER_PERIOD = 4000L;
    @Requires(name="deployment", signature=DeploymentServiceMBean.class)
    protected DeploymentServiceMBean deploymentService;
    @Requires(name="installation", signature=InstallationServiceMBean.class)
    protected InstallationServiceMBean installationService;
    @Requires(name="jmx", signature=JMXService.class)
    protected JMXService jmxService;
    protected LoggingUtil log;
    protected Logger logger;
    @Requires(name="systemstate", signature=SystemStateService.class)
    protected SystemStateService systemStateService;
    @Requires(name="admin", signature=AdminService.class)
    private AdminService adminService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private ContainerConfiguration containerConfiguration;
    private Timer installDirectoryScanTimer;
    private Timer installedDirectoryScanTimer;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void install(List<File> list) {
        SecurityException securityException2;
        Iterator<File> iterator;
        Object object;
        this.log.start();
        List<File> list2 = this.getJBIArchives(RepositoryServiceImpl.EntityType.SL_TYPE, list);
        List<File> list3 = list2.iterator();
        while (true) {
            if (!list3.hasNext()) break;
            object = list3.next();
            try {
                try {
                    this.performInstallSL((File)object);
                }
                catch (Throwable throwable) {
                    this.log.error("Failed to auto-install of a shared library", throwable);
                }
            }
            catch (Throwable throwable) {
                iterator = null;
                try {
                    ((File)object).delete();
                    throw throwable;
                }
                catch (SecurityException securityException2) {
                    this.log.error(securityException2.getMessage(), securityException2);
                }
                throw throwable;
            }
            {
                iterator = null;
            }
            try {}
            catch (SecurityException securityException2) {
                this.log.error(securityException2.getMessage(), securityException2);
                continue;
            }
            ((File)object).delete();
            continue;
            break;
        }
        list.removeAll(list2);
        object = this.getJBIArchives(RepositoryServiceImpl.EntityType.COMPONENT_TYPE, list);
        Object object2 = object.iterator();
        while (true) {
            SecurityException securityException32;
            Object var7_12;
            if (!object2.hasNext()) break;
            list3 = (File)object2.next();
            try {
                try {
                    this.performInstallComponent((File)((Object)list3));
                }
                catch (Throwable throwable) {
                    this.log.error("Error during the auto- installation of a component", throwable);
                }
            }
            catch (Throwable throwable) {
                var7_12 = null;
                try {
                    ((File)((Object)list3)).delete();
                    throw throwable;
                }
                catch (SecurityException securityException32) {
                    this.log.error(securityException32.getMessage(), securityException32);
                }
                throw throwable;
            }
            {
                var7_12 = null;
            }
            try {}
            catch (SecurityException securityException32) {
                this.log.error(securityException32.getMessage(), securityException32);
                continue;
            }
            ((File)((Object)list3)).delete();
            continue;
            break;
        }
        list.removeAll((Collection<?>)object);
        list3 = this.getJBIArchives(RepositoryServiceImpl.EntityType.SA_TYPE, list);
        iterator = list3.iterator();
        while (true) {
            SecurityException securityException42;
            if (!iterator.hasNext()) break;
            object2 = iterator.next();
            try {
                try {
                    this.performDeploySA((File)object2);
                }
                catch (Throwable throwable) {
                    this.log.error("Error during the deployment of a service assembly: ", throwable);
                }
            }
            catch (Throwable throwable) {
                securityException2 = null;
                try {
                    ((File)object2).delete();
                    throw throwable;
                }
                catch (SecurityException securityException42) {
                    this.log.error(securityException42.getMessage(), securityException42);
                }
                throw throwable;
            }
            {
                securityException2 = null;
            }
            try {}
            catch (SecurityException securityException42) {
                this.log.error(securityException42.getMessage(), securityException42);
                continue;
            }
            ((File)object2).delete();
            continue;
            break;
        }
        list.removeAll(list3);
        iterator = list.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.log.end();
                return;
            }
            object2 = iterator.next();
            try {
                this.log.warning("The archive '" + ((File)object2).getName() + "' remains in the install list. PEtALS deletes it");
                ((File)object2).delete();
                continue;
            }
            catch (SecurityException securityException5) {
                this.log.error(securityException5.getMessage(), securityException5);
                continue;
            }
            break;
        }
    }

    @Override
    public void uninstall(List<File> list) {
        this.log.call();
        try {
            List<String> list2 = this.getServiceAssemblyNames(list);
            List<String> list3 = this.getComponentNames(list);
            List<String> list4 = this.getSharedLibraryNames(list);
            for (String string : list2) {
                this.performUndeploySA(string);
            }
            for (String string : list3) {
                this.performUninstallComponent(string);
            }
            for (String string : list4) {
                this.performUninstallSL(string);
            }
        }
        catch (Throwable throwable) {
            this.log.error("Error during uninstallation of JBI artifact(s)", throwable);
        }
    }

    protected void resolveJBIArtefactDependencies(List<File> list) {
        File file;
        String string;
        Object object;
        Collection<Object> collection;
        List<String> list2 = this.getComponentNames(list);
        if (!list2.isEmpty()) {
            collection = this.adminService.getServiceAssemblies().values();
            for (String string2 : list2) {
                block3: for (Object object2 : collection) {
                    for (ServiceUnitLifeCycle serviceUnitLifeCycle : ((ServiceAssemblyLifeCycle)object2).getServiceUnitLifeCycles()) {
                        if (!string2.equals(serviceUnitLifeCycle.getTargetComponentName())) continue;
                        object = ((ServiceAssemblyLifeCycle)object2).getServiceAssembly().getIdentification().getName();
                        string = this.systemStateService.getServiceAssemblyStateHolder((String)object).getArchiveName();
                        file = new File(installedDirectory, string);
                        if (list.contains(file)) continue block3;
                        list.add(file);
                        continue block3;
                    }
                }
            }
        }
        collection = this.getSharedLibraryNames(list);
        for (String string2 : collection) {
            try {
                Object object2;
                object2 = this.installationService.getInstalledComponentsForSharedLibrary(string2);
                object = object2;
                int n = ((String[])object2).length;
                int n2 = 0;
                while (n2 < n) {
                    String string3 = object[n2];
                    string = this.systemStateService.getServiceAssemblyStateHolder(string3).getArchiveName();
                    file = new File(installedDirectory, string);
                    if (!list.contains(file)) {
                        list.add(file);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IOException {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
        this.containerConfiguration = this.configurationService.getContainerConfiguration();
        installDirectory = new File(this.containerConfiguration.getRootDirectoryPath(), "install");
        installedDirectory = new File(this.containerConfiguration.getRootDirectoryPath(), "installed");
        this.installDirectoryScanTimer = new Timer();
        this.installedDirectoryScanTimer = new Timer();
        InstallDirectoryScanner installDirectoryScanner = new InstallDirectoryScanner(this, installDirectory);
        InstalledDirectoryScanner installedDirectoryScanner = new InstalledDirectoryScanner(this, installedDirectory);
        this.installDirectoryScanTimer.schedule((TimerTask)installDirectoryScanner, 4000L, 4000L);
        this.installedDirectoryScanTimer.schedule((TimerTask)installedDirectoryScanner, 4000L, 4000L);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("deployment")) {
            if (!DeploymentServiceMBean.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DeploymentServiceMBean.class.getName());
            }
            this.deploymentService = (DeploymentServiceMBean)object;
            return;
        }
        if (string.equals("installation")) {
            if (!InstallationServiceMBean.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + InstallationServiceMBean.class.getName());
            }
            this.installationService = (InstallationServiceMBean)object;
            return;
        }
        if (string.equals("jmx")) {
            if (!JMXService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + JMXService.class.getName());
            }
            this.jmxService = (JMXService)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("systemstate")) {
            if (!SystemStateService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SystemStateService.class.getName());
            }
            this.systemStateService = (SystemStateService)object;
            return;
        }
        if (string.equals("admin")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("deployment");
        arrayList.add("installation");
        arrayList.add("jmx");
        arrayList.add("systemstate");
        arrayList.add("admin");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
        this.installDirectoryScanTimer.cancel();
        this.installedDirectoryScanTimer.cancel();
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("deployment")) {
            return this.deploymentService;
        }
        if (string.equals("installation")) {
            return this.installationService;
        }
        if (string.equals("jmx")) {
            return this.jmxService;
        }
        if (string.equals("systemstate")) {
            return this.systemStateService;
        }
        if (string.equals("admin")) {
            return this.adminService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private List<String> getComponentNames(List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Component> list2 = this.systemStateService.getComponentStateHolders();
        for (File file : list) {
            for (Component component : list2) {
                if (!file.getName().equals(component.getArchiveName())) continue;
                arrayList.add(component.getName());
            }
        }
        return arrayList;
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("deployment")) {
            this.deploymentService = null;
            return;
        }
        if (string.equals("installation")) {
            this.installationService = null;
            return;
        }
        if (string.equals("jmx")) {
            this.jmxService = null;
            return;
        }
        if (string.equals("systemstate")) {
            this.systemStateService = null;
            return;
        }
        if (string.equals("admin")) {
            this.adminService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private List<File> getJBIArchives(RepositoryServiceImpl.EntityType entityType, List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            try {
                Jbi jbi = PackageHelper.loadDescriptor(file.toURI().toURL());
                if (RepositoryServiceImpl.EntityType.SL_TYPE.equals((Object)entityType) && jbi.getSharedLibrary() != null) {
                    arrayList.add(file);
                    continue;
                }
                if (RepositoryServiceImpl.EntityType.COMPONENT_TYPE.equals((Object)entityType) && jbi.getComponent() != null) {
                    arrayList.add(file);
                    continue;
                }
                if (!RepositoryServiceImpl.EntityType.SA_TYPE.equals((Object)entityType) || jbi.getServiceAssembly() == null) continue;
                arrayList.add(file);
            }
            catch (PetalsException petalsException) {
                this.log.warning("Unable to read a JBI descriptor", petalsException);
            }
            catch (IOException iOException) {
                this.log.warning("Unable to read a JBI descriptor", iOException);
            }
            catch (JBIDescriptorException jBIDescriptorException) {
                this.log.warning("Unable to read a JBI descriptor", jBIDescriptorException);
            }
        }
        return arrayList;
    }

    private List<String> getServiceAssemblyNames(List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ServiceAssembly> list2 = this.systemStateService.getServiceAssemblyStateHolders();
        block0: for (File file : list) {
            for (ServiceAssembly serviceAssembly : list2) {
                if (!file.getName().equals(serviceAssembly.getArchiveName())) continue;
                arrayList.add(serviceAssembly.getName());
                continue block0;
            }
        }
        return arrayList;
    }

    private List<String> getSharedLibraryNames(List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<SharedLibrary> list2 = this.systemStateService.getSharedLibraryStateHolders();
        for (File file : list) {
            for (SharedLibrary sharedLibrary : list2) {
                if (!file.getName().equals(sharedLibrary.getArchiveName())) continue;
                arrayList.add(sharedLibrary.getName());
            }
        }
        return arrayList;
    }

    private void performDeploySA(File file) throws Exception {
        this.log.call();
        String string = this.deploymentService.deploy(file.toURI().toString());
        if (string.indexOf(XMLResult.TaskResult.FAILED.toString()) > -1) {
            throw new RuntimeException("Failed to auto-deploy a service assembly");
        }
        String string2 = string.substring(string.indexOf("<loc-param>") + 11, string.indexOf("</loc-param>"));
        this.deploymentService.start(string2);
    }

    private void performInstallComponent(File file) throws MalformedURLException, InstanceNotFoundException, MBeanException, ReflectionException {
        this.log.call();
        ObjectName objectName = this.installationService.loadNewInstaller(file.toURI().toURL().toExternalForm());
        Object[] objectArray = new Object[]{};
        String[] stringArray = new String[]{};
        MBeanServer mBeanServer = this.jmxService.getLocalJMXServer();
        Object object = mBeanServer.invoke(objectName, "install", objectArray, stringArray);
        if (!(object instanceof ObjectName)) {
            throw new RuntimeException("The install() invocation on the component installer has returned an unexpected object : " + object);
        }
        ObjectName objectName2 = (ObjectName)object;
        mBeanServer.invoke(objectName2, "start", objectArray, stringArray);
    }

    private void performInstallSL(File file) {
        this.log.call();
        try {
            this.installationService.installSharedLibrary(file.toURI().toString());
        }
        catch (Throwable throwable) {
            this.log.error("Failed to auto-install a shared library");
        }
    }

    private void performUndeploySA(String string) {
        this.deploymentService.forceUndeploy(string);
    }

    private void performUninstallComponent(String string) {
        this.installationService.forceUnloadInstaller(string);
    }

    private void performUninstallSL(String string) {
        this.installationService.uninstallSharedLibrary(string);
    }
}

