/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.deployment;

import java.net.URL;
import java.util.ArrayList;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.management.deployment.AtomicDeploymentService;
import org.ow2.petals.jbi.management.deployment.DeploymentServiceMBean;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=AtomicDeploymentService.class)})
public class AtomicDeploymentServiceImpl
implements BindingController,
LifeCycleController,
AtomicDeploymentService {
    @Requires(name="deployment", signature=DeploymentServiceMBean.class)
    private DeploymentServiceMBean deploymentService;
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean deploy(URL uRL) throws PetalsException {
        boolean bl = true;
        if (uRL == null) {
            throw new PetalsException("Service assembly URL is null");
        }
        try {
            String string = this.deploymentService.deploy(uRL.toString());
            bl = string.indexOf("Successfully") > -1;
        }
        catch (Exception exception) {
            this.log.warning(exception.getMessage());
            throw new PetalsException(exception.getMessage());
        }
        return bl;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean shutdown(String string) throws PetalsException {
        boolean bl = true;
        try {
            String string2 = this.deploymentService.shutDown(string);
            bl = string2.indexOf("Successfully") > -1;
        }
        catch (Exception exception) {
            this.log.warning(exception.getMessage());
            throw new PetalsException(exception.getMessage());
        }
        return bl;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean start(String string) throws PetalsException {
        boolean bl = true;
        try {
            String string2 = this.deploymentService.start(string);
            bl = string2.indexOf("Successfully") > -1;
        }
        catch (Exception exception) {
            this.log.warning(exception.getMessage());
            throw new PetalsException(exception.getMessage());
        }
        return bl;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean stop(String string) throws PetalsException {
        boolean bl = true;
        try {
            String string2 = this.deploymentService.stop(string);
            bl = string2.indexOf("Successfully") > -1;
        }
        catch (Exception exception) {
            this.log.warning(exception.getMessage());
            throw new PetalsException(exception.getMessage());
        }
        return bl;
    }

    public boolean undeploy(String string) throws PetalsException {
        boolean bl = true;
        try {
            String string2 = this.deploymentService.undeploy(string);
            bl = string2.indexOf("Successfully") > -1;
        }
        catch (Exception exception) {
            this.log.warning(exception.getMessage());
            throw new PetalsException(exception.getMessage());
        }
        return bl;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("deployment")) {
            if (!DeploymentServiceMBean.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DeploymentServiceMBean.class.getName());
            }
            this.deploymentService = (DeploymentServiceMBean)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("deployment");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("deployment")) {
            return this.deploymentService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("deployment")) {
            this.deploymentService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

