/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jbi.management.DeploymentException;
import org.apache.commons.io.IOUtils;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.ContainerService;
import org.ow2.petals.container.lifecycle.Installer;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.TaskProcessor;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.deployment.DeploymentServiceMBean;
import org.ow2.petals.jbi.management.task.deployment.DeploymentTaskFactory;
import org.ow2.petals.jbi.management.util.XMLResult;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.systemstate.generated.ServiceAssembly;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.ParameterCheckHelper;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=DeploymentServiceMBean.class)})
public class DeploymentServiceImpl
implements BindingController,
LifeCycleController,
DeploymentServiceMBean {
    private LoggerFactory loggerFactory;
    @Requires(name="container", signature=ContainerService.class)
    protected ContainerService container;
    @Requires(name="admin", signature=AdminService.class)
    private AdminService adminService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private DeploymentTaskFactory deploymentTaskFactory;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    private EndpointRegistry endpointRegistry;
    private LoggingUtil log;
    private Logger logger;
    @Requires(name="repository", signature=RepositoryService.class)
    private RepositoryService repositoryService;
    @Requires(name="systemstate", signature=SystemStateService.class)
    private SystemStateService systemStateService;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean canDeployToComponent(String string) {
        this.log.call();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        boolean bl = false;
        Installer installer = this.adminService.getInstallerByName(string);
        if (installer.isInstalled() && installer.getComponent().getServiceUnitManager() != null) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public String deploy(String var1_1) throws Exception {
        block6: {
            this.log.start();
            ParameterCheckHelper.isNullParameterWithLog(var1_1, "serviceAssemblyZipUrl", this.log);
            var2_2 = null;
            try {
                try {
                    var3_3 = new URL(var1_1);
                }
                catch (MalformedURLException v0) {
                    var3_3 = new File(var1_1).toURI().toURL();
                }
                var4_6 = this.createDeploymentContext(var3_3);
                var5_8 = this.createDeploymentProcessor(var4_6, var3_3);
                var6_9 = var5_8.process();
                if (var6_9 != null) {
                    throw new DeploymentException("The deployment of the Service Assembly '" + var1_1 + "' failed.", var6_9);
                }
                var2_2 = var4_6.getXmlResult().getString();
                this.log.info("Service Assembly '" + var4_6.getEntityName() + "' deployed");
                break block6;
            }
            catch (Throwable var3_4) {
                this.log.error("Unable to deploy the service assembly at '" + var1_1 + "'", var3_4);
                var4_7 = new StringBuilder(var3_4.getMessage());
                ** while (var3_5.getCause() != null)
            }
lbl-1000:
            // 1 sources

            {
                if ((var3_5 = var3_5.getCause()).getMessage() == null) continue;
                var4_7.append("\nCaused by:").append(var3_5.getMessage());
                continue;
            }
lbl26:
            // 1 sources

            throw new RuntimeException(var4_7.toString());
        }
        this.log.end();
        return var2_2;
    }

    public boolean forceUndeploy(String string) {
        this.log.start();
        boolean bl = false;
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblies().get(string);
        if (serviceAssemblyLifeCycle != null) {
            serviceAssemblyLifeCycle.setForcedState(true);
        } else {
            this.log.warning("Cannot retrieve Service Assembly with the specified name : " + string);
        }
        try {
            if ("Started".equals(serviceAssemblyLifeCycle.getCurrentState()) || "Unknown".equals(serviceAssemblyLifeCycle.getCurrentState())) {
                this.stop(string, true);
            }
        }
        catch (Exception exception) {}
        try {
            if ("Stopped".equals(serviceAssemblyLifeCycle.getCurrentState())) {
                this.shutDown(string, true);
            }
        }
        catch (Exception exception) {}
        try {
            this.undeploy(string);
            bl = true;
        }
        catch (Exception exception) {}
        this.log.end();
        return bl;
    }

    public String[] getComponentsForDeployedServiceAssembly(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "serviceAssemblyName", this.log);
        ArrayList<String> arrayList = new ArrayList<String>();
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
        if (serviceAssemblyLifeCycle != null) {
            List list = serviceAssemblyLifeCycle.getServiceAssembly().getServiceUnit();
            for (ServiceUnit serviceUnit : list) {
                arrayList.add(serviceUnit.getTarget().getComponentName());
            }
        } else {
            throw new Exception("Cannot retrieve service assembly with the specified name: " + string);
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getDeployedServiceAssemblies() throws Exception {
        this.log.call();
        Set<String> set = this.adminService.getServiceAssemblies().keySet();
        return set.toArray(new String[set.size()]);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("container")) {
            if (!ContainerService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ContainerService.class.getName());
            }
            this.container = (ContainerService)object;
            return;
        }
        if (string.equals("admin")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("repository")) {
            if (!RepositoryService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RepositoryService.class.getName());
            }
            this.repositoryService = (RepositoryService)object;
            return;
        }
        if (string.equals("systemstate")) {
            if (!SystemStateService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SystemStateService.class.getName());
            }
            this.systemStateService = (SystemStateService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] getDeployedServiceAssembliesForComponent(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, ServiceAssemblyLifeCycle> map = this.adminService.getServiceAssemblies();
        for (ServiceAssemblyLifeCycle serviceAssemblyLifeCycle : map.values()) {
            List list = serviceAssemblyLifeCycle.getServiceAssembly().getServiceUnit();
            for (ServiceUnit serviceUnit : list) {
                if (!string.equals(serviceUnit.getTarget().getComponentName())) continue;
                hashSet.add(serviceAssemblyLifeCycle.getServiceAssembly().getIdentification().getName());
            }
        }
        this.log.end();
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("container");
        arrayList.add("admin");
        arrayList.add("configuration");
        arrayList.add("endpoint");
        arrayList.add("repository");
        arrayList.add("systemstate");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("container")) {
            return this.container;
        }
        if (string.equals("admin")) {
            return this.adminService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        if (string.equals("repository")) {
            return this.repositoryService;
        }
        if (string.equals("systemstate")) {
            return this.systemStateService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] getDeployedServiceUnitList(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, ServiceAssemblyLifeCycle> map = this.adminService.getServiceAssemblies();
        for (ServiceAssemblyLifeCycle serviceAssemblyLifeCycle : map.values()) {
            List list = serviceAssemblyLifeCycle.getServiceAssembly().getServiceUnit();
            for (ServiceUnit serviceUnit : list) {
                if (!string.equals(serviceUnit.getTarget().getComponentName())) continue;
                hashSet.add(serviceUnit.getIdentification().getName());
            }
        }
        this.log.end();
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("container")) {
            this.container = null;
            return;
        }
        if (string.equals("admin")) {
            this.adminService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("repository")) {
            this.repositoryService = null;
            return;
        }
        if (string.equals("systemstate")) {
            this.systemStateService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String getServiceAssemblyDescriptor(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "serviceAssemblyName", this.log);
        String string2 = "Service Assembly doesn't exist :" + string;
        File file = this.repositoryService.getServiceAssemblyInstallDirectory(string);
        if (file != null) {
            File file2 = new File(file, JBIDescriptorBuilder.JBI_DESCRIPTOR_RESOURCE);
            string2 = IOUtils.toString((InputStream)new FileInputStream(file2));
        }
        this.log.end();
        return string2;
    }

    public String[] getServiceUnitForServiceAssembly(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "saName", this.log);
        ArrayList<String> arrayList = new ArrayList<String>();
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
        if (serviceAssemblyLifeCycle != null) {
            List list = serviceAssemblyLifeCycle.getServiceAssembly().getServiceUnit();
            for (ServiceUnit serviceUnit : list) {
                arrayList.add(serviceUnit.getIdentification().getName());
            }
        } else {
            String string2 = "Cannot retrieve service assembly with the name '" + string + '\"';
            this.log.error(string2);
            throw new Exception(string2);
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getState(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "serviceAssemblyName", this.log);
        String string2 = null;
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
        if (serviceAssemblyLifeCycle == null) {
            String string3 = "Cannot retrieve service assembly with the specified name : " + string;
            this.log.error(string3);
            throw new Exception(string3);
        }
        string2 = serviceAssemblyLifeCycle.getCurrentState();
        if (!("Shutdown".equals(string2) || "Started".equals(string2) || "Stopped".equals(string2) || "Unknown".equals(string2))) {
            String string4 = "Service Assembly state isn't correctly defined";
            this.log.error(string4);
            throw new Exception(string4);
        }
        this.log.end();
        return string2;
    }

    public boolean isDeployedServiceUnit(String string, String string2) {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string2, "serviceUnitName", this.log);
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        boolean bl = false;
        List<ServiceUnitLifeCycle> list = this.adminService.getServiceUnitsLifeCyclesForComponent(string);
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : list) {
            if (!serviceUnitLifeCycle.getSuName().equals(string2)) continue;
            bl = true;
            break;
        }
        this.log.end();
        return bl;
    }

    public void shutdown() throws Exception {
        this.log.call();
        this.undeployAllServiceAssemblies(true);
    }

    public String shutDown(String string) throws Exception {
        return this.shutDown(string, false);
    }

    public String[] shutdownAllServiceAssemblies() {
        this.log.start();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ServiceAssembly> list = this.systemStateService.getServiceAssemblyStateHolders();
        Collections.reverse(list);
        for (ServiceAssembly serviceAssembly : list) {
            try {
                this.shutDown(serviceAssembly.getName());
                arrayList.add(serviceAssembly.getName());
            }
            catch (Throwable throwable) {}
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public String start(String var1_1) throws Exception {
        block4: {
            this.log.start();
            ParameterCheckHelper.isNullOrEmptyParameterWithLog(var1_1, "serviceAssemblyName", this.log);
            var2_2 = null;
            try {
                var3_3 = new XMLResult("start");
                var4_6 = this.adminService.getServiceAssemblyByName(var1_1);
                if (var4_6 == null) {
                    throw new DeploymentException("The service assembly '" + var1_1 + "' is not deployed");
                }
                var4_6.start();
                var3_3.addFrameworkTaskResult(XMLResult.TaskResult.SUCCESS, XMLResult.MessageType.INFO, "Successfully started service assembly : {1}", new String[]{var1_1}, XMLResult.CauseFramework.YES);
                var2_2 = var3_3.getString();
                break block4;
            }
            catch (Throwable var3_4) {
                this.log.error("Unable to start the service assembly '" + var1_1 + "'", var3_4);
                var4_7 = new StringBuilder(var3_4.getMessage());
                ** while (var3_5.getCause() != null)
            }
lbl-1000:
            // 1 sources

            {
                if ((var3_5 = var3_5.getCause()).getMessage() == null) continue;
                var4_7.append("\nCaused by: ").append(var3_5.getMessage());
                continue;
            }
lbl21:
            // 1 sources

            throw new Exception(var4_7.toString());
        }
        this.log.info("Service Assembly '" + var1_1 + "' started");
        this.log.end();
        return var2_2;
    }

    public String[] startAllServiceAssemblies() {
        this.log.start();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ServiceAssembly serviceAssembly : this.systemStateService.getServiceAssemblyStateHolders()) {
            try {
                this.start(serviceAssembly.getName());
                arrayList.add(serviceAssembly.getName());
            }
            catch (Throwable throwable) {}
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String stop(String string) throws Exception {
        return this.stop(string, false);
    }

    public String[] stopAllServiceAssemblies() {
        this.log.start();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ServiceAssembly> list = this.systemStateService.getServiceAssemblyStateHolders();
        Collections.reverse(list);
        for (ServiceAssembly serviceAssembly : list) {
            try {
                this.stop(serviceAssembly.getName());
                arrayList.add(serviceAssembly.getName());
            }
            catch (Throwable throwable) {}
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public String undeploy(String var1_1) throws Exception {
        block6: {
            this.log.start();
            ParameterCheckHelper.isNullParameterWithLog(var1_1, "serviceAssemblyZipUrl", this.log);
            var2_2 = null;
            try {
                var3_3 = this.systemStateService.getServiceAssemblyStateHolder(var1_1);
                if (var3_3 == null) {
                    throw new DeploymentException("The service assembly '" + var1_1 + "' is not deployed");
                }
                if (!"Shutdown".equals(var3_3.getLifecycleState())) {
                    throw new DeploymentException("The service assembly '" + var1_1 + "' is not at the state SHUTDOWN");
                }
                var4_6 = this.createUndeploymentContext(var1_1);
                var5_8 = this.createUndeploymentProcessor(var4_6);
                var6_9 = var5_8.process();
                if (var6_9 != null) {
                    throw new DeploymentException("The undeployment of the Service Assembly '" + var1_1 + "' failed.", var6_9);
                }
                var2_2 = var4_6.getXmlResult().getString();
                break block6;
            }
            catch (Throwable var3_4) {
                this.log.error("Unable to undeploy the service assembly '" + var1_1 + "'", var3_4);
                var4_7 = new StringBuilder(var3_4.getMessage());
                ** while (var3_5.getCause() != null)
            }
lbl-1000:
            // 1 sources

            {
                if ((var3_5 = var3_5.getCause()).getMessage() == null) continue;
                var4_7.append("\nCaused by:").append(var3_5.getMessage());
                continue;
            }
lbl25:
            // 1 sources

            throw new Exception(var4_7.toString());
        }
        this.log.info("Service Assembly '" + var1_1 + "' undeployed");
        this.log.end();
        return var2_2;
    }

    public String[] undeployAllServiceAssemblies(boolean bl) {
        this.log.start();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ServiceAssembly> list = this.systemStateService.getServiceAssemblyStateHolders();
        Collections.reverse(list);
        for (ServiceAssembly serviceAssembly : list) {
            if (bl) {
                if (!this.forceUndeploy(serviceAssembly.getName())) continue;
                arrayList.add(serviceAssembly.getName());
                continue;
            }
            if (!"Shutdown".equals(serviceAssembly.getLifecycleState())) continue;
            try {
                this.undeploy(serviceAssembly.getName());
                arrayList.add(serviceAssembly.getName());
            }
            catch (Throwable throwable) {}
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.deploymentTaskFactory = new DeploymentTaskFactory(this.endpointRegistry, this, this.systemStateService, this.repositoryService, this.log, this.adminService, this.container, this.configurationService.getContainerConfiguration().getRootDirectoryPath());
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
    }

    private Context createDeploymentContext(URL uRL) {
        this.log.call();
        Context context = new Context();
        context.setArchiveUrl(uRL);
        return context;
    }

    private TaskProcessor createDeploymentProcessor(Context context, URL uRL) {
        this.log.call();
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        String string = uRL.getProtocol();
        if (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("ftp")) {
            taskProcessor.addTask(this.deploymentTaskFactory.getDownloadTask());
        } else if (string.equalsIgnoreCase("file")) {
            taskProcessor.addTask(this.deploymentTaskFactory.getCopyArchiveToWorkDirTask());
        } else {
            throw new IllegalArgumentException("URL protocol not supported:" + string);
        }
        taskProcessor.addTask(this.deploymentTaskFactory.getExtractTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getSaCheckPackageTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getCopySAPackageToRepositoryTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getCreateSAStateHolderTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getCreateXMLDeploymentResultTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getExtractSUsTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRegisterSALifeCycleTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getDeployAllSUTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRegisterAllConnectionTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getCopyArchiveToInstalledDirTask());
        return taskProcessor;
    }

    private Context createUndeploymentContext(String string) {
        this.log.call();
        Context context = new Context();
        ServiceAssembly serviceAssembly = this.systemStateService.getServiceAssemblyStateHolder(string);
        context.setEntityName(string);
        try {
            context.setArchiveUrl(new URL(serviceAssembly.getInstallURL()));
        }
        catch (MalformedURLException malformedURLException) {}
        return context;
    }

    private TaskProcessor createUndeploymentProcessor(Context context) {
        this.log.call();
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        taskProcessor.addTask(this.deploymentTaskFactory.getCreateXMLUndeploymentResultTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRetrieveSALifeCycleTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getUndeployAllSUTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRemoveAllConnectionsTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getUnregisterSALifeCycleTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRemoveSAStateHolderTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRemoveSAFolderTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRemoveSAArchiveTask());
        return taskProcessor;
    }

    /*
     * Unable to fully structure code
     */
    private String shutDown(String var1_1, boolean var2_2) throws Exception {
        block4: {
            this.log.start();
            ParameterCheckHelper.isNullOrEmptyParameterWithLog(var1_1, "serviceAssemblyName", this.log);
            var3_3 = null;
            try {
                var4_4 = new XMLResult("shutdown");
                var5_7 = this.adminService.getServiceAssemblyByName(var1_1);
                if (var5_7 == null) {
                    throw new DeploymentException("The service assembly '" + var1_1 + "' is not deployed");
                }
                var5_7.setForcedState(var2_2);
                var5_7.shutDown();
                var4_4.addFrameworkTaskResult(XMLResult.TaskResult.SUCCESS, XMLResult.MessageType.INFO, "Successfully shutdown service assembly : {1}", new String[]{var1_1}, XMLResult.CauseFramework.YES);
                var3_3 = var4_4.getString();
                break block4;
            }
            catch (Throwable var4_5) {
                this.log.error("Unable to shutdown the service assembly '" + var1_1 + "'", var4_5);
                var5_8 = new StringBuilder(var4_5.getMessage());
                ** while (var4_6.getCause() != null)
            }
lbl-1000:
            // 1 sources

            {
                if ((var4_6 = var4_6.getCause()).getMessage() == null) continue;
                var5_8.append("\nCaused by: ").append(var4_6.getMessage());
                continue;
            }
lbl22:
            // 1 sources

            throw new Exception(var5_8.toString());
        }
        this.log.info("Service Assembly '" + var1_1 + "' shut down");
        this.log.end();
        return var3_3;
    }

    /*
     * Unable to fully structure code
     */
    private String stop(String var1_1, boolean var2_2) throws Exception {
        block4: {
            this.log.start();
            ParameterCheckHelper.isNullOrEmptyParameterWithLog(var1_1, "serviceAssemblyName", this.log);
            var3_3 = null;
            try {
                var4_4 = this.adminService.getServiceAssemblyByName(var1_1);
                if (var4_4 == null) {
                    throw new DeploymentException("The service assembly '" + var1_1 + "' is not deployed");
                }
                var4_4.setForcedState(var2_2);
                var4_4.stop();
                var5_7 = new XMLResult("stop");
                var5_7.addFrameworkTaskResult(XMLResult.TaskResult.SUCCESS, XMLResult.MessageType.INFO, "Successfully stopped service assembly : {1}", new String[]{var1_1}, XMLResult.CauseFramework.YES);
                var3_3 = var5_7.getString();
                break block4;
            }
            catch (Throwable var4_5) {
                this.log.error("Unable to stop the service assembly '" + var1_1 + "'", var4_5);
                var5_8 = new StringBuilder(var4_5.getMessage());
                ** while (var4_6.getCause() != null)
            }
lbl-1000:
            // 1 sources

            {
                if ((var4_6 = var4_6.getCause()).getMessage() == null) continue;
                var5_8.append("\nCaused by: ").append(var4_6.getMessage());
                continue;
            }
lbl22:
            // 1 sources

            throw new Exception(var5_8.toString());
        }
        this.log.info("Service Assembly '" + var1_1 + "' stopped");
        this.log.end();
        return var3_3;
    }
}

