/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task;

import java.io.File;
import java.io.IOException;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.util.LoggingUtil;

public abstract class AbstractCopyPackageToRepositoryTask
extends AbstractLoggableTask {
    protected RepositoryService repositoryService = null;

    public AbstractCopyPackageToRepositoryTask(LoggingUtil loggingUtil, RepositoryService repositoryService) {
        super(loggingUtil);
        this.repositoryService = repositoryService;
    }

    public void execute(Context context) throws Exception {
        String string = context.getEntityName();
        String string2 = context.getEntityVersion();
        File file = context.getUnzipRoot();
        File file2 = this.copyPackage(string, string2, file);
        context.setInstallUrl(file2.toURI().toURL());
    }

    public void undo(Context context) throws Exception {
        String string = context.getEntityName();
        String string2 = context.getEntityVersion();
        if (string != null) {
            try {
                this.removeEntityPackage(string, string2);
            }
            catch (IOException iOException) {
                this.log.error("Unable to remove the entity package", iOException);
            }
        }
    }

    protected File copyPackage(String string, String string2, File file) throws ManagementException {
        File file2 = null;
        try {
            file2 = this.copyEntityPackage(string, string2, file);
        }
        catch (IOException iOException) {
            throw new ManagementException(iOException);
        }
        return file2;
    }

    protected abstract File copyEntityPackage(String var1, String var2, File var3) throws IOException;

    protected abstract void removeEntityPackage(String var1, String var2) throws IOException;
}

