/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.AbstractFileManipulationTask;
import org.ow2.petals.util.LoggingUtil;

public class CopyArchiveToInstalledDirTask
extends AbstractFileManipulationTask {
    public CopyArchiveToInstalledDirTask(LoggingUtil loggingUtil, String string) {
        super(loggingUtil, string);
    }

    public void execute(Context context) throws Exception {
        URL uRL = context.getArchiveUrl();
        File file = new File(uRL.getPath());
        File file2 = this.getInstalledArchive(file.getName());
        FileUtils.copyFile((File)file, (File)file2);
        FileUtils.forceDelete((File)file);
    }

    public void undo(Context context) throws Exception {
        File file;
        File file2;
        URL uRL = context.getArchiveUrl();
        if (uRL != null && (file2 = this.getInstalledArchive((file = new File(uRL.getPath())).getName())).exists()) {
            try {
                FileUtils.forceDelete((File)file2);
            }
            catch (IOException iOException) {
                this.log.error("Component archive can not be deleted", iOException);
            }
        }
    }
}

