/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.AbstractFileManipulationTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;

public class CopyArchiveToWorkDirTask
extends AbstractFileManipulationTask {
    public CopyArchiveToWorkDirTask(LoggingUtil loggingUtil, String string) {
        super(loggingUtil, string);
    }

    public void execute(Context context) throws Exception {
        URL uRL = context.getArchiveUrl();
        File file = this.copyEntityPackage(uRL);
        context.setArchiveUrl(file.toURI().toURL());
    }

    private File copyEntityPackage(URL uRL) throws PetalsException {
        File file = new File(uRL.getPath());
        File file2 = new File(this.getWorkDirectory(), file.getName());
        try {
            FileUtils.copyFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new PetalsException("Can't copy entity package to work directory", iOException);
        }
        return file2;
    }

    public void undo(Context context) throws Exception {
        URL uRL = context.getArchiveUrl();
        if (uRL != null) {
            try {
                FileUtils.forceDelete((File)new File(uRL.getPath()));
            }
            catch (IOException iOException) {
                this.log.warning("Failed to clean the copied archive '" + uRL.getPath() + "'");
            }
        }
    }
}

