/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.AbstractFileManipulationTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.ZipUtil;

public class ExtractTask
extends AbstractFileManipulationTask {
    private static AtomicLong uniqueIdSuffix = new AtomicLong();

    public ExtractTask(LoggingUtil loggingUtil, String string) {
        super(loggingUtil, string);
    }

    public void execute(Context context) throws Exception {
        URL uRL = context.getArchiveUrl();
        File file = this.explodeEntityPackage(uRL);
        context.setUnzipRoot(file);
    }

    private File explodeEntityPackage(URL uRL) throws PetalsException {
        File file = new File(uRL.getPath());
        File file2 = new File(this.getWorkDirectory(), String.valueOf(file.getName()) + "-" + uniqueIdSuffix.incrementAndGet());
        try {
            file2.mkdir();
            ZipUtil.unzipArchive(file, file2);
        }
        catch (IOException iOException) {
            try {
                FileUtils.forceDelete((File)file2);
            }
            catch (IOException iOException2) {
                this.log.warning("Failed to delete the temporary directory '" + file2.getAbsolutePath() + "'", iOException);
            }
            throw new PetalsException(iOException);
        }
        return file2;
    }

    public void undo(Context context) throws Exception {
        File file = context.getUnzipRoot();
        if (file != null) {
            try {
                if (file.exists()) {
                    FileUtils.forceDelete((File)file);
                }
            }
            catch (IOException iOException) {
                this.log.error("Failed to delete the temporary directory '" + file.getAbsolutePath() + "'", iOException);
            }
        }
    }
}

