/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.deploy;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jbi.management.DeploymentException;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.TaskProcessor;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.jbi.management.task.deployment.DeploymentTaskFactory;
import org.ow2.petals.jbi.management.util.XMLResult;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployAllSUTask
extends AbstractLoggableTask {
    protected DeploymentTaskFactory deploymentTaskFactory;

    public DeployAllSUTask(LoggingUtil loggingUtil, DeploymentTaskFactory deploymentTaskFactory) {
        super(loggingUtil);
        this.deploymentTaskFactory = deploymentTaskFactory;
    }

    @Override
    public void execute(Context context) throws Exception {
        URL uRL = context.getInstallUrl();
        Jbi jbi = context.getDescriptor();
        XMLResult xMLResult = context.getXmlResult();
        Map<String, URL> map = context.getSuInstallUrls();
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = context.getSaLifeCycle();
        List<TaskProcessor> list = this.deploySUS(uRL, serviceAssemblyLifeCycle, jbi, map, xMLResult);
        if (list.size() == 0) {
            throw new DeploymentException("All the Service Unit deployment has failed");
        }
        context.setSuTaskProcessors(list);
    }

    protected List<TaskProcessor> deploySUS(URL uRL, ServiceAssemblyLifeCycle serviceAssemblyLifeCycle, Jbi jbi, Map<String, URL> map, XMLResult xMLResult) throws Exception {
        List list = jbi.getServiceAssembly().getServiceUnit();
        ArrayList<Context> arrayList = new ArrayList<Context>(list.size());
        ArrayList<TaskProcessor> arrayList2 = new ArrayList<TaskProcessor>();
        if (list != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (ServiceUnit serviceUnit : list) {
                Context context = this.createSUDeploymentContext(serviceAssemblyLifeCycle, map, serviceUnit);
                arrayList.add(context);
                this.registerAndDeploySU(context, arrayList2);
                stringBuffer.append(context.getComponentResult());
            }
            serviceAssemblyLifeCycle.init(jbi.getServiceAssembly());
            xMLResult.addComponentTaskResult(stringBuffer);
        }
        return arrayList2;
    }

    private Context createSUDeploymentContext(ServiceAssemblyLifeCycle serviceAssemblyLifeCycle, Map<String, URL> map, ServiceUnit serviceUnit) throws FileNotFoundException, JBIDescriptorException, PetalsException {
        Context context = new Context();
        context.setSaLifeCycle(serviceAssemblyLifeCycle);
        context.setSuDescriptorInSa(serviceUnit);
        URL uRL = map.get(serviceUnit.getIdentification().getName());
        context.setSuInstallUrl(uRL);
        return context;
    }

    private void registerAndDeploySU(Context context, List<TaskProcessor> list) throws Exception {
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        taskProcessor.addTask(this.deploymentTaskFactory.getCreateAndRegisterSULifeCycleTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getDeploySUToComponentTask());
        Throwable throwable = taskProcessor.process();
        if (throwable != null) {
            this.log.warning("Error occured during the the registration or the deployment of a Service Unit", throwable);
        } else {
            list.add(taskProcessor);
        }
    }

    @Override
    public void undo(Context context) throws Exception {
        List<TaskProcessor> list = context.getSuTaskProcessors();
        if (list != null) {
            for (TaskProcessor taskProcessor : list) {
                taskProcessor.unprocess();
            }
        }
    }
}

