/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.deploy;

import java.net.URL;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import org.ow2.petals.container.lifecycle.Installer;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.jbi.management.util.ManagementMessageUtil;
import org.ow2.petals.util.LoggingUtil;

public class DeploySUToComponentTask
extends AbstractLoggableTask {
    protected AdminService adminService;

    public DeploySUToComponentTask(LoggingUtil loggingUtil, AdminService adminService) {
        super(loggingUtil);
        this.adminService = adminService;
    }

    public void execute(Context context) throws Exception {
        URL uRL = context.getSuInstallUrl();
        ServiceUnit serviceUnit = context.getSuDescriptorInSa();
        String string = this.deploySUtoComponent(uRL, serviceUnit);
        context.setComponentResult(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String deploySUtoComponent(URL uRL, ServiceUnit serviceUnit) throws Exception {
        String string = null;
        String string2 = serviceUnit.getTarget().getComponentName();
        Installer installer = this.adminService.getInstallerByName(string2);
        if (installer == null) {
            throw new ManagementException("The Service Unit can not be deployed, as the component '" + string2 + "' is not installed");
        }
        ServiceUnitManager serviceUnitManager = installer.getComponent().getServiceUnitManager();
        if (serviceUnitManager == null) {
            throw new ManagementException("Component '" + string2 + "' doesn't support deployment : service unit manager is null");
        }
        try {
            Thread.currentThread().setContextClassLoader(serviceUnitManager.getClass().getClassLoader());
            String string3 = serviceUnit.getIdentification().getName();
            string = serviceUnitManager.deploy(string3, uRL.getPath());
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            throw throwable;
        }
        {
            Object var8_10 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (string != null) return string;
        }
        return ManagementMessageUtil.getComponentTaskResult(string2, "deploy", "FAILED");
    }

    public void undo(Context context) throws Exception {
        this.log.debug("Revert DeploySUToComponent");
        if (context.getSuInstallUrl() != null && context.getSuDescriptorInSa() != null) {
            try {
                this.undeploySUFromComponent(context.getSuInstallUrl(), context.getSuDescriptorInSa());
            }
            catch (ManagementException managementException) {
                this.log.error("Failed to revert a DeploySUToComponentask", (Throwable)((Object)managementException));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void undeploySUFromComponent(URL uRL, ServiceUnit serviceUnit) throws ManagementException {
        String string = serviceUnit.getTarget().getComponentName();
        if (string == null) return;
        Installer installer = this.adminService.getInstallerByName(string);
        if (installer == null) {
            throw new ManagementException("The component lifecycle element for service unit deployment must be non null.");
        }
        ServiceUnitManager serviceUnitManager = installer.getComponent().getServiceUnitManager();
        if (serviceUnitManager == null) {
            throw new ManagementException("The service unit manager is null for the component '" + string + "'. The service units can not be deployed.");
        }
        String string2 = serviceUnit.getIdentification().getName();
        try {
            try {
                Thread.currentThread().setContextClassLoader(serviceUnitManager.getClass().getClassLoader());
                serviceUnitManager.undeploy(string2, uRL.getPath());
            }
            catch (DeploymentException deploymentException) {
                throw new ManagementException("Undeployement of the service unit '" + string2 + "' has failed (caused by a target component '" + string2 + "' SU manager exception)", deploymentException);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            throw throwable;
        }
        {
            Object var8_10 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            return;
        }
    }
}

