/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.deploy;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jbi.management.ComponentLifeCycleMBean;
import javax.xml.namespace.QName;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.Connection;
import org.ow2.petals.jbi.descriptor.original.generated.Connections;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceAssembly;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractCheckPackageTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SACheckPackageTask
extends AbstractCheckPackageTask {
    protected SystemStateService systemStateService;
    protected AdminService adminService;

    public SACheckPackageTask(LoggingUtil loggingUtil, SystemStateService systemStateService, AdminService adminService) {
        super(loggingUtil);
        this.systemStateService = systemStateService;
        this.adminService = adminService;
    }

    @Override
    protected void checkPackage(Jbi jbi, File file) throws PetalsException {
        List list;
        ServiceAssembly serviceAssembly = jbi.getServiceAssembly();
        if (serviceAssembly == null) {
            throw new PetalsException("Given archive isn't a service assembly archive : missing service assembly production element into jbi descriptor");
        }
        String string = serviceAssembly.getIdentification().getName();
        if (StringHelper.isNullOrEmpty(string)) {
            throw new PetalsException("Name of a service assembly must not be null or empty for package '" + file.getAbsolutePath() + "'");
        }
        if (this.isSADeployed(string)) {
            throw new PetalsException("You are trying to deploy a sa with an identifier that is used by a previously successfuly deployed SA '" + string + "'");
        }
        Connections connections = serviceAssembly.getConnections();
        if (connections != null) {
            this.checkConnections(connections.getConnection());
        }
        if ((list = serviceAssembly.getServiceUnit()) != null) {
            this.checkServiceUnits(list, string, file);
        }
    }

    @Override
    protected String extractEntityName(Jbi jbi) {
        return jbi.getServiceAssembly().getIdentification().getName();
    }

    private boolean isSADeployed(String string) {
        return this.adminService.getServiceAssemblyByName(string) != null;
    }

    private void checkConnections(List<Connection> list) throws PetalsException {
        for (Connection connection : list) {
            QName qName = connection.getConsumer().getInterfaceName();
            QName qName2 = connection.getConsumer().getServiceName();
            String string = connection.getConsumer().getEndpointName();
            QName qName3 = connection.getProvider().getServiceName();
            String string2 = connection.getProvider().getEndpointName();
            if ((qName == null || StringHelper.isNullOrEmpty(qName.getLocalPart())) && (StringHelper.isNullOrEmpty(string) || qName2 == null || StringHelper.isNullOrEmpty(qName2.getLocalPart()))) {
                throw new PetalsException("Either Consumer interface or (consumer service and consumer endpoint) must be filled in a Consumes connection");
            }
            if (!StringHelper.isNullOrEmpty(string2) && qName3 != null && !StringHelper.isNullOrEmpty(qName3.getLocalPart())) continue;
            throw new PetalsException("Provider service and provider endpoint must be filled in a Provides connection");
        }
    }

    private void checkServiceUnits(List<ServiceUnit> list, String string, File file) throws PetalsException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ServiceUnit serviceUnit : list) {
            String string2 = serviceUnit.getIdentification().getName();
            this.checkSUIdentifier(arrayList, string2, string);
            arrayList.add(string2);
            String string3 = serviceUnit.getTarget().getArtifactsZip().trim();
            String string4 = serviceUnit.getTarget().getComponentName();
            this.checkTargetComponentAndZip(string3, string2, string4);
            this.checkSUPackageInSAPackage(string3, file);
            if (this.isSUAlreadyDeployedOnTargetedComponent(serviceUnit)) {
                throw new PetalsException("You are trying to deploy a SU '" + serviceUnit.getIdentification().getName() + "' which have already been deployed on the target component '" + serviceUnit.getTarget().getComponentName() + "'");
            }
            if (this.isTargetedComponentStartedOrStopped(string4)) continue;
            throw new PetalsException("You are trying to deploy a SU '" + serviceUnit.getIdentification().getName() + "' which need that the target component '" + serviceUnit.getTarget().getComponentName() + "' is started or stopped");
        }
    }

    private boolean isTargetedComponentStartedOrStopped(String string) throws PetalsException {
        String string2;
        boolean bl = false;
        ComponentLifeCycleMBean componentLifeCycleMBean = this.adminService.isBinding(string) ? this.adminService.getBindingComponentLifeCycleByName(string) : this.adminService.getEngineComponentLifeCycleByName(string);
        if (componentLifeCycleMBean != null && ("Started".equals(string2 = componentLifeCycleMBean.getCurrentState()) || "Stopped".equals(string2))) {
            bl = true;
        }
        return bl;
    }

    private void checkSUIdentifier(List<String> list, String string, String string2) throws PetalsException {
        if (StringHelper.isNullOrEmpty(string)) {
            throw new PetalsException("Name of service unit must be filled in the SA '" + string2 + "'");
        }
        if (list.contains(string)) {
            throw new PetalsException("Name of service unit must be unique within the SA '" + string2 + "'");
        }
    }

    private void checkTargetComponentAndZip(String string, String string2, String string3) throws PetalsException {
        String string4 = "";
        if (StringHelper.isNullOrEmpty(string)) {
            string4 = "Target artifact zip of a service unit must be non null and non empty (SU name : " + string2 + ").";
            this.log.error(string4);
            throw new PetalsException(string4);
        }
        if (StringHelper.isNullOrEmpty(string3)) {
            string4 = "Target component name of a service unit must be non null and non empty (SU name : " + string2 + ").";
            this.log.error(string4);
            throw new PetalsException(string4);
        }
    }

    private void checkSUPackageInSAPackage(String string, File file) throws PetalsException {
        File file2 = new File(file, string);
        if (!file2.exists()) {
            throw new PetalsException("Can't find artifact '" + string + "' in SA package  '" + file.getAbsolutePath() + "'");
        }
    }

    private boolean isSUAlreadyDeployedOnTargetedComponent(ServiceUnit serviceUnit) throws PetalsException {
        return this.isDeployedServiceUnit(serviceUnit.getTarget().getComponentName(), serviceUnit.getIdentification().getName());
    }

    private boolean isDeployedServiceUnit(String string, String string2) {
        boolean bl = false;
        for (ServiceAssemblyLifeCycle serviceAssemblyLifeCycle : this.adminService.getServiceAssemblies().values()) {
            while (serviceAssemblyLifeCycle.getServiceAssembly() == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            List list = serviceAssemblyLifeCycle.getServiceAssembly().getServiceUnit();
            for (ServiceUnit serviceUnit : list) {
                if (!string.equals(serviceUnit.getTarget().getComponentName()) || !string2.equals(serviceUnit.getIdentification().getName())) continue;
                bl = true;
            }
        }
        return bl;
    }
}

