/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.component;

import java.io.IOException;
import javax.jbi.JBIException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.ow2.petals.container.ContainerService;
import org.ow2.petals.container.lifecycle.Installer;
import org.ow2.petals.container.lifecycle.InstallerInterface;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.server.FractalHelper;
import org.ow2.petals.util.LoggingUtil;

public class CreateAndRegisterInstallerMBeanTask
extends AbstractLoggableTask {
    private final AdminService adminService;
    protected ContainerService containerService;

    public CreateAndRegisterInstallerMBeanTask(LoggingUtil loggingUtil, AdminService adminService, ContainerService containerService) {
        super(loggingUtil);
        this.adminService = adminService;
        this.containerService = containerService;
    }

    public void execute(Context context) throws Exception {
        ObjectName objectName = this.createAndRegisterInstallerMBean(context);
        context.setInstallerObjectName(objectName);
    }

    private ObjectName createAndRegisterInstallerMBean(Context context) throws PetalsException {
        ObjectName objectName = null;
        try {
            Jbi jbi = context.getDescriptor();
            Component component = jbi.getComponent();
            org.objectweb.fractal.api.Component component2 = this.containerService.createInstaller(component);
            FractalHelper.startComponent(component2);
            ((InstallerInterface)component2.getFcInterface("service")).init(context);
            objectName = this.adminService.registerInstaller((Installer)component2.getFcInterface("/content"), component.getIdentification().getName());
        }
        catch (ManagementException managementException) {
            throw new PetalsException("Error creating or registring installer MBean", (Throwable)((Object)managementException));
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException("Error creating or registring installer MBean", noSuchInterfaceException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new PetalsException("Error creating or registring installer MBean", illegalLifeCycleException);
        }
        catch (JBIException jBIException) {
            throw new PetalsException("Error creating or registring installer MBean", jBIException);
        }
        catch (IOException iOException) {
            throw new PetalsException("Error creating or registring installer MBean", iOException);
        }
        catch (NamingException namingException) {
            throw new PetalsException("Error creating or registring installer MBean", namingException);
        }
        return objectName;
    }

    public void undo(Context context) throws Exception {
        Jbi jbi = context.getDescriptor();
        String string = jbi.getComponent().getIdentification().getName();
        try {
            this.adminService.unregisterInstaller(string);
        }
        catch (ManagementException managementException) {
            this.log.error("Component installer can't be unregistered or doesn't exist", (Throwable)((Object)managementException));
        }
        try {
            this.containerService.removeInstaller(string);
        }
        catch (PetalsException petalsException) {
            this.log.error("Fractal installer can't be removed or doesn't exist", petalsException);
        }
    }
}

