/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.sl;

import java.net.URL;
import org.objectweb.fractal.api.Component;
import org.ow2.petals.container.ContainerService;
import org.ow2.petals.container.lifecycle.SharedLibraryLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.ClassLoaderDelegationType;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.server.FractalHelper;
import org.ow2.petals.util.LoggingUtil;

public class CreateSLClassloaderTask
extends AbstractLoggableTask {
    private final AdminService adminService;
    protected ContainerService containerService;

    public CreateSLClassloaderTask(LoggingUtil loggingUtil, AdminService adminService, ContainerService containerService) {
        super(loggingUtil);
        this.containerService = containerService;
        this.adminService = adminService;
    }

    public void execute(Context context) throws Exception {
        this.log.start();
        Jbi jbi = context.getDescriptor();
        URL uRL = context.getInstallUrl();
        Jbi.SharedLibrary sharedLibrary = jbi.getSharedLibrary();
        Component component = this.containerService.createSharedLibraryLifeCycle(sharedLibrary);
        FractalHelper.startComponent(component);
        SharedLibraryLifeCycle sharedLibraryLifeCycle = (SharedLibraryLifeCycle)component.getFcInterface("service");
        boolean bl = ClassLoaderDelegationType.PARENT_FIRST.equals((Object)sharedLibrary.getClassLoaderDelegation());
        sharedLibraryLifeCycle.init(sharedLibrary, new URL[]{uRL}, bl);
        sharedLibraryLifeCycle.loadSharedLibrary();
        this.adminService.registerSharedLibrary(sharedLibraryLifeCycle, String.valueOf(sharedLibrary.getIdentification().getName()) + "-" + sharedLibrary.getVersion());
        this.log.end();
    }

    public void undo(Context context) throws Exception {
        this.log.call();
        String string = context.getEntityName();
        if (string != null) {
            try {
                this.adminService.unregisterSharedLibrary(string);
            }
            catch (ManagementException managementException) {
                this.log.error("The shared library can't be unregistered or doesn't exist", (Throwable)((Object)managementException));
            }
            try {
                this.containerService.removeSharedLibraryLifeCycle(string);
            }
            catch (PetalsException petalsException) {
                this.log.error("The fractal shared library can't be removed or doesn't exist", petalsException);
            }
        }
    }
}

