/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.uninstall.component;

import org.ow2.petals.container.ContainerService;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;

public class UnregisterInstallerTask
extends AbstractLoggableTask {
    private final AdminService adminService;
    private final ContainerService containerService;

    public UnregisterInstallerTask(LoggingUtil loggingUtil, AdminService adminService, ContainerService containerService) {
        super(loggingUtil);
        this.adminService = adminService;
        this.containerService = containerService;
    }

    public void execute(Context context) throws Exception {
        String string;
        if (context.getEntityName() != null && (string = context.getEntityName()) != null) {
            try {
                this.adminService.unregisterInstaller(string);
            }
            catch (ManagementException managementException) {
                this.log.error("Installer MBean can not be unregistered", (Throwable)((Object)managementException));
            }
            try {
                this.containerService.removeInstaller(string);
            }
            catch (PetalsException petalsException) {
                this.log.error("Fractal installer can not be removed", petalsException);
            }
        }
    }

    public void undo(Context context) throws Exception {
    }
}

