/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.uninstall.sl;

import org.ow2.petals.container.ContainerService;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;

public class RemoveSLClassloaderTask
extends AbstractLoggableTask {
    private final AdminService adminService;
    protected ContainerService containerService;

    public RemoveSLClassloaderTask(LoggingUtil loggingUtil, AdminService adminService, ContainerService containerService) {
        super(loggingUtil);
        this.containerService = containerService;
        this.adminService = adminService;
    }

    public void execute(Context context) {
        if (context.getEntityName() != null) {
            String string = context.getEntityName();
            String string2 = context.getEntityVersion();
            try {
                this.adminService.unregisterSharedLibrary(String.valueOf(string) + "-" + string2);
            }
            catch (ManagementException managementException) {
                this.log.error("The shared library can not be unregistered", (Throwable)((Object)managementException));
            }
            try {
                this.containerService.removeSharedLibraryLifeCycle(String.valueOf(string) + "-" + string2);
            }
            catch (PetalsException petalsException) {
                this.log.error("The fractal shared library can not be removed", petalsException);
            }
        }
    }

    public void undo(Context context) throws Exception {
    }
}

