/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.uninstall.sl;

import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.systemstate.SystemStateException;
import org.ow2.petals.systemstate.generated.SharedLibrary;
import org.ow2.petals.util.LoggingUtil;

public class RemoveSLStateHolderTask
extends AbstractLoggableTask {
    private final SystemStateService recoveryService;

    public RemoveSLStateHolderTask(LoggingUtil loggingUtil, SystemStateService systemStateService) {
        super(loggingUtil);
        this.recoveryService = systemStateService;
    }

    public void execute(Context context) {
        String string = context.getEntityName();
        String string2 = context.getEntityVersion();
        SharedLibrary sharedLibrary = null;
        if (string != null) {
            try {
                sharedLibrary = this.recoveryService.deleteSharedLibraryStateHolder(string, string2);
                context.setSharedLibraryStateHolder(sharedLibrary);
            }
            catch (SystemStateException systemStateException) {
                this.log.error("The shared library '" + string + "' with version '" + string2 + "' state holder can not be removed", systemStateException);
            }
        }
    }

    public void undo(Context context) throws Exception {
    }
}

