/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.control;

import java.util.ArrayList;
import javax.jbi.messaging.MessageExchange;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.jmx.JMXService;
import org.ow2.petals.communication.jmx.RemoteJMXServer;
import org.ow2.petals.jbi.messaging.control.ExchangeCheckerClient;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.ParameterCheckHelper;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ExchangeCheckerClient.class)})
public class JMXExchangeCheckerClientImpl
implements BindingController,
LifeCycleController,
ExchangeCheckerClient {
    private LoggingUtil log;
    protected Logger logger;
    @Requires(name="jmx", signature=JMXService.class)
    protected JMXService jmxService;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isExchangeWithConsumerOkayForComponent(ServiceEndpoint serviceEndpoint, MessageExchange messageExchange) {
        this.log.start();
        ParameterCheckHelper.isNullParameterWithLog(serviceEndpoint, "Endpoint", this.log);
        boolean bl = true;
        try {
            RemoteJMXServer remoteJMXServer = this.jmxService.getRemoteJMXServer(serviceEndpoint.getLocation().getContainerName());
            Boolean bl2 = (Boolean)remoteJMXServer.invoke(remoteJMXServer.getAdminServiceMBeanName(), "isExchangeWithConsumerOkayForComponent", new Object[]{serviceEndpoint.getLocation().getComponentName(), serviceEndpoint, messageExchange}, new String[]{String.class.getName(), ServiceEndpoint.class.getName(), MessageExchange.class.getName()});
            bl = bl2;
        }
        catch (Exception exception) {
            this.log.error("Problem in isExchangeWithConsumerOkayForComponent", exception);
        }
        this.log.end();
        return bl;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean isExchangeWithProviderOkayForComponent(ServiceEndpoint serviceEndpoint, MessageExchange messageExchange) {
        this.log.start();
        if (serviceEndpoint == null) {
            throw new IllegalArgumentException("Endpoint must be non null");
        }
        boolean bl = true;
        try {
            RemoteJMXServer remoteJMXServer = this.jmxService.getRemoteJMXServer(serviceEndpoint.getLocation().getContainerName());
            Boolean bl2 = (Boolean)remoteJMXServer.invoke(remoteJMXServer.getAdminServiceMBeanName(), "isExchangeWithProviderOkayForComponent", new Object[]{serviceEndpoint.getLocation().getComponentName(), serviceEndpoint, messageExchange}, new String[]{String.class.getName(), ServiceEndpoint.class.getName(), MessageExchange.class.getName()});
            bl = bl2;
        }
        catch (Exception exception) {
            this.log.error("Problem in isExchangeWithProviderOkayForComponent", exception);
        }
        this.log.end();
        return bl;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("jmx")) {
            if (!JMXService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + JMXService.class.getName());
            }
            this.jmxService = (JMXService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("jmx");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("jmx")) {
            return this.jmxService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("jmx")) {
            this.jmxService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

