/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.SystemException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.petals.commons.stream.InputStreamForker;
import org.ow2.petals.commons.stream.ReaderInputStream;
import org.ow2.petals.commons.threadlocal.Transformers;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.management.transaction.TransactionManagerImpl;
import org.ow2.petals.jbi.messaging.exchange.DeliveryChannel;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeFactoryImpl;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.util.LoggingUtil;

public class DeliveryChannelImpl
implements DeliveryChannel {
    protected ComponentContext context;
    protected LoggingUtil log;
    protected Logger logger;
    protected MessageExchangeFactoryImpl messageExchangeFactory;
    protected boolean opened = true;

    public DeliveryChannelImpl(ComponentContext componentContext) {
        this.logger = componentContext.getLogger();
        this.log = new LoggingUtil(this.logger);
        this.messageExchangeFactory = new MessageExchangeFactoryImpl(this, componentContext.getAddress(), this.logger);
        this.context = componentContext;
    }

    private static final void checkMessageExchange(javax.jbi.messaging.MessageExchange messageExchange) throws MessagingException {
        if (messageExchange == null) {
            throw new MessagingException("MessageExchange is null");
        }
        MessageExchangeDecorator messageExchangeDecorator = (MessageExchangeDecorator)messageExchange;
        if (messageExchangeDecorator.getMessageExchange().isTerminated()) {
            throw new MessagingException("MessageExchange is terminated");
        }
    }

    public javax.jbi.messaging.MessageExchange accept() throws MessagingException {
        this.log.call();
        javax.jbi.messaging.MessageExchange messageExchange = this.poll(-1L);
        return messageExchange;
    }

    public javax.jbi.messaging.MessageExchange accept(long l) throws MessagingException {
        this.log.call(l);
        if (l < 0L) {
            throw new MessagingException("Timeout must be positive or null");
        }
        javax.jbi.messaging.MessageExchange messageExchange = this.poll(l);
        return messageExchange;
    }

    public void checkDeliveryChannelIsOpened() throws MessagingException {
        if (!this.opened) {
            throw new MessagingException("DeliveryChannel is closed.");
        }
    }

    public synchronized void close() throws MessagingException {
        this.log.start();
        this.checkDeliveryChannelIsOpened();
        this.opened = false;
        try {
            this.context.deregisterAllEndpoints();
        }
        catch (JBIException jBIException) {
            throw new MessagingException((Throwable)jBIException);
        }
        this.log.end();
    }

    public MessageExchangeFactory createExchangeFactory() {
        this.log.call();
        MessageExchangeFactoryImpl messageExchangeFactoryImpl = new MessageExchangeFactoryImpl(this, this.context.getAddress(), this.logger);
        return messageExchangeFactoryImpl;
    }

    public MessageExchangeFactory createExchangeFactory(QName qName) {
        this.log.call(qName);
        MessageExchangeFactoryImpl messageExchangeFactoryImpl = new MessageExchangeFactoryImpl(this, this.context.getAddress(), this.logger);
        messageExchangeFactoryImpl.setDefaultInterfaceName(qName);
        return messageExchangeFactoryImpl;
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint serviceEndpoint) {
        this.log.call(serviceEndpoint);
        MessageExchangeFactoryImpl messageExchangeFactoryImpl = new MessageExchangeFactoryImpl(this, this.context.getAddress(), this.logger);
        messageExchangeFactoryImpl.setDefaultServiceEndpoint(serviceEndpoint);
        return messageExchangeFactoryImpl;
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName qName) {
        this.log.call(qName);
        MessageExchangeFactoryImpl messageExchangeFactoryImpl = new MessageExchangeFactoryImpl(this, this.context.getAddress(), this.logger);
        messageExchangeFactoryImpl.setDefaultServiceName(qName);
        return messageExchangeFactoryImpl;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void send(javax.jbi.messaging.MessageExchange messageExchange) throws MessagingException {
        this.log.call("Exchange Id:" + messageExchange.getExchangeId());
        this.sendExchange(messageExchange, 0L, false);
    }

    public boolean sendSync(javax.jbi.messaging.MessageExchange messageExchange) throws MessagingException {
        return this.sendSync(messageExchange, 0L);
    }

    /*
     * Unable to fully structure code
     */
    public boolean sendSync(javax.jbi.messaging.MessageExchange var1_1, long var2_2) throws MessagingException {
        block6: {
            this.log.call("Exchange Id:" + var1_1.getExchangeId() + " - Timeout:" + var2_2);
            var4_3 = (MessageExchangeDecorator)var1_1;
            try {
                var4_3.setWaitingOnSynchronousSend(true);
                var5_4 = this.sendExchange(var4_3, var2_2, true);
                if (var5_4 != null) {
                    var4_3.setMessageExchange(var5_4);
                    var4_3.setWaitingOnSynchronousSend(false);
                } else {
                    var4_3.getMessageExchange().setRole(var4_3.getObserverRole());
                    var4_3.setStatus(ExchangeStatus.ERROR);
                    var4_3.getMessageExchange().setTerminated(true);
                }
                break block6;
            }
            catch (MessagingException var5_5) {
                this.log.debug(var5_5.getMessage());
                var4_3.getMessageExchange().setRole(var4_3.getObserverRole());
                var4_3.setStatus(ExchangeStatus.ERROR);
                var4_3.getMessageExchange().setTerminated(true);
                var6_6 = var5_5.getCause();
                ** while (var6_6 != null)
            }
lbl-1000:
            // 1 sources

            {
                if (var6_6 instanceof InterruptedException) {
                    this.log.end();
                    return false;
                }
                var6_6 = var6_6.getCause();
                continue;
            }
lbl26:
            // 1 sources

            throw var5_5;
        }
        this.log.end();
        return var4_3.isWaitingOnSynchronousSend() == false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logMessage(javax.jbi.messaging.MessageExchange messageExchange) {
        java.util.logging.Logger logger = null;
        try {
            logger = this.context.getLogger("", null);
            if (!logger.isLoggable(Level.FINEST)) return;
            if (ExchangeStatus.ACTIVE.equals(messageExchange.getStatus())) {
                Object object;
                Object object2;
                NormalizedMessage normalizedMessage;
                block16: {
                    block14: {
                        InputStream inputStream;
                        Source source;
                        block15: {
                            normalizedMessage = messageExchange.getMessage("out");
                            String string = "out";
                            if (normalizedMessage == null) {
                                normalizedMessage = messageExchange.getFault();
                                string = "Fault";
                            }
                            if (normalizedMessage == null) {
                                normalizedMessage = messageExchange.getMessage("in");
                                string = "in";
                            }
                            logger.finest("Message " + string + " with Id '" + messageExchange.getExchangeId() + "' to send");
                            object2 = normalizedMessage.getPropertyNames().iterator();
                            while (true) {
                                if (!object2.hasNext()) {
                                    source = normalizedMessage.getContent();
                                    if (source == null) break block14;
                                    if (source instanceof StreamSource) {
                                        object = (StreamSource)source;
                                        inputStream = ((StreamSource)object).getInputStream();
                                        object2 = inputStream != null ? new InputStreamForker(inputStream) : new InputStreamForker((InputStream)new ReaderInputStream(((StreamSource)object).getReader()));
                                    }
                                    break block15;
                                }
                                source = object2.next();
                                logger.finest("Message property '" + source + "' : " + normalizedMessage.getProperty((String)((Object)source)));
                            }
                            normalizedMessage.setContent((Source)new StreamSource(object2.getInputStreamOne()));
                            source = new StreamSource(object2.getInputStreamTwo());
                        }
                        object2 = Transformers.getDefaultTransformer();
                        ((Transformer)object2).setOutputProperty("encoding", Charset.defaultCharset().name());
                        object = new ByteArrayOutputStream();
                        try {
                            ((Transformer)object2).transform(source, new StreamResult((OutputStream)object));
                        }
                        catch (Throwable throwable) {
                            inputStream = null;
                            ((Transformer)object2).reset();
                            throw throwable;
                        }
                        {
                            inputStream = null;
                            ((Transformer)object2).reset();
                            logger.finest("Message Content : " + new String(((ByteArrayOutputStream)object).toByteArray()));
                            break block16;
                        }
                    }
                    logger.finest("Message Content is null");
                }
                object = normalizedMessage.getAttachmentNames().iterator();
                while (true) {
                    if (!object.hasNext()) {
                        return;
                    }
                    object2 = object.next();
                    logger.finest("Got a message attachment named '" + object2 + "'");
                }
            }
            if (ExchangeStatus.DONE.equals(messageExchange.getStatus())) {
                logger.finest("Message acknowledgement DONE with Id '" + messageExchange.getExchangeId() + "' to send");
                return;
            }
            logger.finest("Message acknowledgement ERROR with Id '" + messageExchange.getExchangeId() + "' to send");
            logger.finest("Message Error : " + messageExchange.getError().getMessage());
            return;
        }
        catch (Throwable throwable) {
            if (logger == null) return;
            logger.fine("failed to log the content of the message to send: " + throwable.getMessage());
        }
    }

    private javax.jbi.messaging.MessageExchange poll(long l) throws MessagingException {
        this.log.start();
        this.checkDeliveryChannelIsOpened();
        MessageExchange messageExchange = null;
        try {
            messageExchange = this.context.getRouter().receive(this.context, l);
        }
        catch (RoutingException routingException) {
            throw new MessagingException((Throwable)((Object)routingException));
        }
        javax.jbi.messaging.MessageExchange messageExchange2 = null;
        if (messageExchange != null) {
            messageExchange2 = this.messageExchangeFactory.createExchangeDecorator(messageExchange, messageExchange.getPattern());
            if (this.context.getTransactionManager() != null) {
                TransactionManagerImpl.decodeTransactionContext(((MessageExchangeDecorator)messageExchange2).getMessageExchange());
            }
        }
        this.log.end();
        return messageExchange2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageExchange sendExchange(javax.jbi.messaging.MessageExchange messageExchange, long l, boolean bl) throws MessagingException {
        this.checkDeliveryChannelIsOpened();
        DeliveryChannelImpl.checkMessageExchange(messageExchange);
        this.logMessage(messageExchange);
        MessageExchangeDecorator messageExchangeDecorator = (MessageExchangeDecorator)messageExchange;
        MessageExchange messageExchange2 = messageExchangeDecorator.getMessageExchange();
        MessageExchange messageExchange3 = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                if (!ExchangeStatus.ACTIVE.equals(messageExchange2.getStatus())) {
                    messageExchange2.setTerminated(true);
                    if (bl) {
                        throw new MessagingException("Sending an acknowledgment in synchronous mode is forbidden");
                    }
                }
                if (this.context.getTransactionManager() != null) {
                    TransactionManagerImpl.encodeTransactionContext(messageExchange2);
                }
                if (bl) {
                    messageExchange3 = this.context.getRouter().sendSync(this.context, messageExchange2, l);
                    if (messageExchange3 != null && this.context.getTransactionManager() != null) {
                        TransactionManagerImpl.decodeTransactionContext(messageExchange3);
                    }
                } else {
                    this.context.getRouter().send(this.context, messageExchange2);
                }
            }
            catch (JBIException jBIException) {
                throw new MessagingException((Throwable)jBIException);
            }
            catch (SystemException systemException) {
                throw new MessagingException((Throwable)systemException);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var10_12 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.log.end();
            return messageExchange3;
        }
    }
}

