/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.net.URI;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.DeliveryChannel;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.jbi.messaging.exchange.types.InOnlyImpl;
import org.ow2.petals.jbi.messaging.exchange.types.InOptionalOutImpl;
import org.ow2.petals.jbi.messaging.exchange.types.InOutImpl;
import org.ow2.petals.jbi.messaging.exchange.types.RobustInOnlyImpl;
import org.ow2.petals.util.IDGenerator;
import org.ow2.petals.util.LoggingUtil;

public class MessageExchangeFactoryImpl
implements MessageExchangeFactory {
    protected DeliveryChannel channel;
    protected ServiceEndpoint consumerEndpoint;
    protected QName defaultInterfaceName;
    protected javax.jbi.servicedesc.ServiceEndpoint defaultServiceEndpoint;
    protected QName defaultServiceName;
    protected LoggingUtil log;

    public MessageExchangeFactoryImpl(DeliveryChannel deliveryChannel, ServiceEndpoint serviceEndpoint, Logger logger) {
        this.log = new LoggingUtil(logger);
        this.channel = deliveryChannel;
        this.consumerEndpoint = serviceEndpoint;
    }

    public javax.jbi.messaging.MessageExchange createExchange(QName qName, QName qName2) throws MessagingException {
        this.log.call(qName + "," + qName2);
        MessageExchangeImpl messageExchangeImpl = this.createExchange();
        this.setDefaultMessageExchangeProperties(messageExchangeImpl);
        messageExchangeImpl.setService(qName);
        messageExchangeImpl.setOperation(qName2);
        return new MessageExchangeDecorator(messageExchangeImpl, MessageExchange.Role.CONSUMER);
    }

    public javax.jbi.messaging.MessageExchange createExchange(URI uRI) throws MessagingException {
        this.log.call(uRI);
        if (!(MessageExchange.IN_ONLY_PATTERN.equals(uRI) || MessageExchange.ROBUST_IN_ONLY_PATTERN.equals(uRI) || MessageExchange.IN_OUT_PATTERN.equals(uRI) || MessageExchange.IN_OPTIONAL_OUT_PATTERN.equals(uRI))) {
            throw new MessagingException("This Message Exchange Pattern is not recognized by JBI.");
        }
        return this.createExchangeDecorator(this.createExchange(), uRI);
    }

    public javax.jbi.messaging.MessageExchange createExchangeDecorator(MessageExchange messageExchange, URI uRI) throws MessagingException {
        this.log.call(uRI);
        if (MessageExchange.IN_ONLY_PATTERN.equals(uRI)) {
            return new InOnlyImpl(messageExchange, messageExchange.getRole());
        }
        if (MessageExchange.ROBUST_IN_ONLY_PATTERN.equals(uRI)) {
            return new RobustInOnlyImpl(messageExchange, messageExchange.getRole());
        }
        if (MessageExchange.IN_OUT_PATTERN.equals(uRI)) {
            return new InOutImpl(messageExchange, messageExchange.getRole());
        }
        if (MessageExchange.IN_OPTIONAL_OUT_PATTERN.equals(uRI)) {
            return new InOptionalOutImpl(messageExchange, messageExchange.getRole());
        }
        return new MessageExchangeDecorator(messageExchange, messageExchange.getRole());
    }

    public InOnly createInOnlyExchange() throws MessagingException {
        this.log.call();
        MessageExchangeImpl messageExchangeImpl = this.createExchange();
        return new InOnlyImpl(messageExchangeImpl, MessageExchange.Role.CONSUMER);
    }

    public InOptionalOut createInOptionalOutExchange() throws MessagingException {
        this.log.call();
        MessageExchangeImpl messageExchangeImpl = this.createExchange();
        return new InOptionalOutImpl(messageExchangeImpl, MessageExchange.Role.CONSUMER);
    }

    public InOut createInOutExchange() throws MessagingException {
        this.log.call();
        MessageExchangeImpl messageExchangeImpl = this.createExchange();
        return new InOutImpl(messageExchangeImpl, MessageExchange.Role.CONSUMER);
    }

    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        this.log.call();
        MessageExchangeImpl messageExchangeImpl = this.createExchange();
        return new RobustInOnlyImpl(messageExchangeImpl, MessageExchange.Role.CONSUMER);
    }

    public void setDefaultInterfaceName(QName qName) {
        this.defaultInterfaceName = qName;
    }

    public void setDefaultServiceEndpoint(javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint) {
        this.defaultServiceEndpoint = serviceEndpoint;
    }

    public void setDefaultServiceName(QName qName) {
        this.defaultServiceName = qName;
    }

    protected MessageExchangeImpl createExchange() throws MessagingException {
        this.log.call();
        this.channel.checkDeliveryChannelIsOpened();
        MessageExchangeImpl messageExchangeImpl = new MessageExchangeImpl(this.consumerEndpoint);
        this.setDefaultMessageExchangeProperties(messageExchangeImpl);
        messageExchangeImpl.setExchangeId(IDGenerator.getInstance().getNewID());
        return messageExchangeImpl;
    }

    protected void setDefaultMessageExchangeProperties(MessageExchangeImpl messageExchangeImpl) {
        this.log.call();
        if (this.defaultInterfaceName != null) {
            messageExchangeImpl.setInterfaceName(this.defaultInterfaceName);
        }
        if (this.defaultServiceName != null) {
            messageExchangeImpl.setService(this.defaultServiceName);
        }
        if (this.defaultServiceEndpoint != null) {
            messageExchangeImpl.setEndpoint(this.defaultServiceEndpoint);
        }
    }
}

