/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.FaultImpl;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.exchange.NormalizedMessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageExchangeImpl
implements Serializable,
Cloneable,
MessageExchange {
    private static final long serialVersionUID = -4354354L;
    private static final short SERIALIZE_ROLE_CONSUMER = 0;
    private static final short SERIALIZE_ROLE_PROVIDER = 1;
    private static final short SERIALIZE_STATUS_ACTIVE = 0;
    private static final short SERIALIZE_STATUS_DONE = 1;
    private static final short SERIALIZE_STATUS_ERROR = 2;
    protected ServiceEndpoint consumerEndpoint;
    protected ServiceEndpoint endpoint;
    protected Exception error;
    protected String exchangeId;
    protected Fault fault;
    protected QName interfaceName;
    protected Map<String, NormalizedMessage> messages = new HashMap<String, NormalizedMessage>();
    protected QName operation;
    protected URI pattern;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected transient MessageExchange.Role role;
    protected QName service;
    protected transient ExchangeStatus status = ExchangeStatus.ACTIVE;
    protected boolean terminated;
    protected boolean transacted;

    public MessageExchangeImpl(ServiceEndpoint serviceEndpoint) {
        this.role = MessageExchange.Role.CONSUMER;
        this.consumerEndpoint = serviceEndpoint;
    }

    public Fault createFault() throws MessagingException {
        return new FaultImpl();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return new NormalizedMessageImpl();
    }

    @Override
    public ServiceEndpoint getConsumerEndpoint() {
        return this.consumerEndpoint;
    }

    public javax.jbi.servicedesc.ServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.endpoint;
    }

    public Exception getError() {
        return this.error;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public Fault getFault() {
        return this.fault;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public NormalizedMessage getMessage(String string) {
        if (string != null) {
            return this.messages.get(string.toLowerCase());
        }
        return null;
    }

    @Override
    public Map<String, NormalizedMessage> getMessages() {
        return this.messages;
    }

    public QName getOperation() {
        return this.operation;
    }

    public URI getPattern() {
        return this.pattern;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Set<?> getPropertyNames() {
        return this.properties.keySet();
    }

    public MessageExchange.Role getRole() {
        return this.role;
    }

    public QName getService() {
        return this.service;
    }

    public ExchangeStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setEndpoint(javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint) {
        this.endpoint = (ServiceEndpoint)serviceEndpoint;
    }

    public void setError(Exception exception) {
        this.error = exception;
        try {
            this.setStatus(ExchangeStatus.ERROR);
        }
        catch (MessagingException messagingException) {}
    }

    public void setExchangeId(String string) {
        this.exchangeId = string;
    }

    public void setFault(Fault fault) throws MessagingException {
        this.checkNotTerminated();
        if (this.role == null) {
            throw new MessagingException("The Role is not defined.");
        }
        if (ExchangeStatus.DONE.equals(this.status) || ExchangeStatus.ERROR.equals(this.status)) {
            throw new MessagingException("The MessageExchange state and the current Role do not allow this operation.");
        }
        if (!(!MessageExchange.Role.CONSUMER.equals(this.role) || MessageExchange.IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) && this.messages.containsKey("out"))) {
            throw new MessagingException("The MessageExchange state and the current Role do not allow this operation.");
        }
        this.fault = fault;
    }

    public void setInterfaceName(QName qName) {
        this.interfaceName = qName;
    }

    public void setMessage(NormalizedMessage normalizedMessage, String string) throws MessagingException {
        this.checkNotTerminated();
        if (normalizedMessage == null) {
            throw new MessagingException("NormalizedMessage must be non null.");
        }
        if (string == null || string.trim().length() == 0) {
            throw new MessagingException("The message reference must be non null and non empty.");
        }
        this.checkPatternMatching(string);
        this.checkRoleMatching(string);
        if (this.messages.containsKey(string.toLowerCase())) {
            throw new MessagingException("A message has already been set with the '" + string + "' reference.");
        }
        this.messages.put(string.toLowerCase(), normalizedMessage);
    }

    public void setOperation(QName qName) {
        this.operation = qName;
    }

    @Override
    public void setPattern(URI uRI) {
        this.pattern = uRI;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    @Override
    public void setRole(MessageExchange.Role role) {
        this.role = role;
    }

    public void setService(QName qName) {
        this.service = qName;
    }

    public void setStatus(ExchangeStatus exchangeStatus) throws MessagingException {
        this.checkNotTerminated();
        if (ExchangeStatus.DONE.equals(exchangeStatus)) {
            if (MessageExchange.Role.CONSUMER.equals(this.role)) {
                if (MessageExchange.IN_ONLY_PATTERN.equals(this.pattern)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (MessageExchange.IN_OUT_PATTERN.equals(this.pattern) && this.fault == null && this.getMessage("out") == null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (MessageExchange.IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) && this.fault == null && this.getMessage("out") == null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
            } else {
                if (MessageExchange.ROBUST_IN_ONLY_PATTERN.equals(this.pattern) && this.fault != null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (MessageExchange.IN_OUT_PATTERN.equals(this.pattern)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (MessageExchange.IN_OPTIONAL_OUT_PATTERN.equals(this.pattern)) {
                    if (this.fault != null && this.getMessage("out") == null) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                    if (this.fault == null && this.getMessage("out") != null) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                }
            }
        } else if (ExchangeStatus.ERROR.equals(exchangeStatus) && MessageExchange.Role.PROVIDER.equals(this.role) && MessageExchange.IN_OUT_PATTERN.equals(this.pattern)) {
            throw new MessagingException("The MessageExchange state does not allow this operation.");
        }
        this.status = exchangeStatus;
    }

    @Override
    public void setTerminated(boolean bl) {
        this.terminated = bl;
    }

    @Override
    public void setTransacted(boolean bl) {
        this.transacted = bl;
    }

    public String toString() {
        return "MessageExchange@" + this.getExchangeId();
    }

    protected void checkNotTerminated() throws MessagingException {
        if (this.isTerminated()) {
            throw new MessagingException("The Exchange is terminated.");
        }
    }

    protected void checkPatternMatching(String string) throws MessagingException {
        if (this.pattern == null) {
            throw new MessagingException("The MEP is not defined.");
        }
        if (string == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if ("in".equalsIgnoreCase(string) ? MessageExchange.IN_ONLY_PATTERN.equals(this.pattern) || MessageExchange.ROBUST_IN_ONLY_PATTERN.equals(this.pattern) || MessageExchange.IN_OUT_PATTERN.equals(this.pattern) || MessageExchange.IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) : "out".equalsIgnoreCase(string) && (MessageExchange.IN_OUT_PATTERN.equals(this.pattern) || MessageExchange.IN_OPTIONAL_OUT_PATTERN.equals(this.pattern))) {
            return;
        }
        throw new MessagingException("the MessageExchange state does not allow this operation.");
    }

    protected void checkRoleMatching(String string) throws MessagingException {
        if (this.role == null) {
            throw new MessagingException("the Role is not defined.");
        }
        if (string == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if (MessageExchange.Role.CONSUMER.equals(this.role) ? "in".equalsIgnoreCase(string) : MessageExchange.Role.PROVIDER.equals(this.role) && "out".equalsIgnoreCase(string)) {
            return;
        }
        throw new MessagingException("The Role does not allow this operation.");
    }

    @Override
    public void cleanMessages() {
        if (!ExchangeStatus.ACTIVE.equals(this.status)) {
            this.messages.clear();
            this.fault = null;
        }
        if (this.fault != null) {
            this.messages.clear();
        }
        if (this.messages.containsKey("out") && this.messages.containsKey("in")) {
            this.messages.remove("in");
        }
    }

    protected void readObjectDelegate(ObjectInputStream objectInputStream) throws IOException {
        switch (objectInputStream.readShort()) {
            case 0: {
                this.role = MessageExchange.Role.CONSUMER;
                break;
            }
            case 1: {
                this.role = MessageExchange.Role.PROVIDER;
                break;
            }
        }
        switch (objectInputStream.readShort()) {
            case 0: {
                this.status = ExchangeStatus.ACTIVE;
                break;
            }
            case 1: {
                this.status = ExchangeStatus.DONE;
                break;
            }
            case 2: {
                this.status = ExchangeStatus.ERROR;
                break;
            }
        }
        try {
            objectInputStream.defaultReadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getClass() + ":" + classNotFoundException.getMessage());
        }
    }

    protected void writeObjectDelegate(ObjectOutputStream objectOutputStream) throws IOException {
        if (MessageExchange.Role.CONSUMER.equals(this.role)) {
            objectOutputStream.writeShort(0);
        } else {
            objectOutputStream.writeShort(1);
        }
        if (ExchangeStatus.ACTIVE.equals(this.status)) {
            objectOutputStream.writeShort(0);
        } else if (ExchangeStatus.DONE.equals(this.status)) {
            objectOutputStream.writeShort(1);
        } else {
            objectOutputStream.writeShort(2);
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.readObjectDelegate(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.writeObjectDelegate(objectOutputStream);
    }

    @Override
    public void setConsumerEndpoint(ServiceEndpoint serviceEndpoint) {
        this.consumerEndpoint = serviceEndpoint;
    }
}

