/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Cardinality;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.messaging.registry.BaseEndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.jbi.messaging.registry.RegistryListener;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.config.Configuration;
import org.ow2.petals.registry.api.config.ConfigurationLoader;
import org.ow2.petals.registry.api.config.ConfigurationLoaderFactory;
import org.ow2.petals.registry.api.config.RemoteConfiguration;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.client.RegistryClientFactory;
import org.ow2.petals.registry.core.factory.RegistryFactory;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=EndpointRegistry.class)})
public class DistributedEndpointRegistryImpl
extends BaseEndpointRegistry
implements BindingController,
LifeCycleController {
    private LoggerFactory loggerFactory;
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    @Requires(name="topology", signature=TopologyService.class)
    protected TopologyService localTopologyService;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="listener", signature=RegistryListener.class)
    protected Hashtable<String, Object> listeners = new Hashtable();
    protected ContainerConfiguration localContainerConfiguration;
    private ScheduledExecutorService registryTopologyUpdater;
    private Configuration localConfig;
    private boolean registeredOnMaster = false;
    protected Logger logger;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws Exception {
        this.log = new LoggingUtil(this.logger);
        this.localContainerConfiguration = this.configurationService.getContainerConfiguration();
        URL uRL = this.getClass().getResource("/server.properties");
        if (uRL == null) {
            throw new IOException("Registry configuration file has not been found, check classpath for /server.properties");
        }
        File file = new File(uRL.toURI());
        try {
            this.createRegistryConfig(file);
            this.loadRegistry();
            this.createRegistryTopology();
            this.registry.init();
            this.registry.start();
            this.cleanData();
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            this.log.error(registryException.getMessage(), registryException);
            if (this.registry != null && (this.registry.isInitialized() || this.registry.isStarted())) {
                try {
                    this.registry.stop();
                }
                catch (LifeCycleException lifeCycleException) {
                    throw new RegistryException(lifeCycleException);
                }
            }
            throw new RegistryException(registryException);
        }
        this.createTopologyUpdater();
        try {
            this.registry.synchronizeData();
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            if (this.log.isDebugEnabled()) {
                this.log.warning("Can not synchronize data from network, mode will be downgraded", registryException);
            }
            this.log.warning("Can not synchronize data from network, mode will be downgraded");
        }
        this.client = RegistryClientFactory.getNewClient((LocalRegistry)this.registry);
        this.log.info("The registry is ready process requests on " + this.registry.getContext().getConfiguration().getMessageReceiverURL());
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void loadRegistry() throws PetalsException, org.ow2.petals.registry.api.exception.RegistryException {
        this.registry = RegistryFactory.getInstance().loadLocal(this.localConfig);
        if (this.registry == null) {
            throw new PetalsException("Registry can not be loaded!");
        }
    }

    protected void createTopologyUpdater() {
        if (this.localTopologyService.hasValidLocalContainerDynamicTopologyConfiguration()) {
            long l = this.configurationService.getContainerConfiguration().getTopologyUpdatePeriod();
            this.registryTopologyUpdater = Executors.newSingleThreadScheduledExecutor();
            this.registryTopologyUpdater.scheduleAtFixedRate(new TopologyUpdater(), 30L, l, TimeUnit.SECONDS);
            try {
                this.localTopologyService.registerLocalContainerOnMaster();
                this.localTopologyService.updateTopology();
                this.registeredOnMaster = true;
            }
            catch (Throwable throwable) {
                this.registeredOnMaster = false;
                this.log.warning("Can't register local node onto the master node (nor updating the topology)");
            }
        }
    }

    protected void createRegistryTopology() throws PetalsException {
        Set<ContainerConfiguration> set = this.localTopologyService.getContainersConfiguration(null);
        String string = null;
        for (ContainerConfiguration containerConfiguration : set) {
            if (!containerConfiguration.getName().equals(this.localContainerConfiguration.getName())) continue;
            string = containerConfiguration.getSubdomainName();
            break;
        }
        ArrayList<ContainerConfiguration> arrayList = new ArrayList<ContainerConfiguration>();
        for (ContainerConfiguration containerConfiguration : set) {
            if (!containerConfiguration.getSubdomainName().equals(string) || containerConfiguration.getSubdomainName().equals(this.localContainerConfiguration.getName()) || !containerConfiguration.getRegistryMode().equals((Object)ContainerConfiguration.RegistryMode.MASTER) && !containerConfiguration.getRegistryMode().equals((Object)ContainerConfiguration.RegistryMode.PEER)) continue;
            arrayList.add(containerConfiguration);
        }
        if (this.localContainerConfiguration.isSlave() || this.localContainerConfiguration.isPeer()) {
            for (ContainerConfiguration containerConfiguration : arrayList) {
                RemoteConfiguration remoteConfiguration = new RemoteConfiguration("Registry@PETALSESB-" + containerConfiguration.getName());
                remoteConfiguration.setMessageSenderClassName(this.localConfig.getMessageSenderClassName());
                String string2 = "http://" + containerConfiguration.getHost() + ":" + containerConfiguration.getRegistryPort();
                remoteConfiguration.setUri(string2);
                this.registry.getContext().getTopology().add(remoteConfiguration);
            }
        }
        if (this.localContainerConfiguration.isPeer()) {
            this.registry.getContext().getProperties().put("registry.mode", "peer");
        }
        if (this.localContainerConfiguration.isMaster()) {
            this.registry.getContext().getProperties().put("registry.mode", "master");
        }
        if (this.localContainerConfiguration.isSlave()) {
            this.registry.getContext().getProperties().put("registry.mode", "slave");
        }
        if (this.localContainerConfiguration.isStandalone()) {
            this.registry.getContext().getProperties().put("registry.mode", "standalone");
        }
    }

    protected void createRegistryConfig(File file) throws org.ow2.petals.registry.api.exception.RegistryException {
        ConfigurationLoader configurationLoader = ConfigurationLoaderFactory.getLoader((File)file);
        if (configurationLoader == null) {
            throw new org.ow2.petals.registry.api.exception.RegistryException("Can not get a configuration loader for the file " + file.getName());
        }
        try {
            this.localConfig = configurationLoader.loadLocal((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new org.ow2.petals.registry.api.exception.RegistryException((Throwable)fileNotFoundException);
        }
        this.localConfig.setName("Registry@PEtALSESB-" + this.localContainerConfiguration.getName());
        this.localConfig.setRootPath(this.localContainerConfiguration.getWorkDirectoryPath());
        String string = "http://" + this.localContainerConfiguration.getHost() + ":" + this.localContainerConfiguration.getRegistryPort();
        this.localConfig.setMessageReceiverURL(string);
    }

    private void cleanData() {
        block5: {
            block4: {
                this.registry.pauseReceive();
                try {
                    this.registry.delete(this.getRootPath(), true);
                }
                catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
                    if (!this.log.isErrorEnabled()) break block4;
                    this.log.error(registryException.getMessage());
                }
            }
            try {
                this.registry.clean();
            }
            catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error(registryException.getMessage());
            }
        }
        this.registry.resumeReceive();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.localTopologyService = (TopologyService)object;
            return;
        }
        if (string.startsWith("listener")) {
            if (!RegistryListener.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RegistryListener.class.getName());
            }
            this.listeners.put(string, object);
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("topology");
        arrayList.addAll((Collection)this.listeners.keySet());
        return arrayList.toArray(new String[0]);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws Exception {
        block9: {
            block8: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stopping...");
                }
                this.registry.pauseReceive();
                try {
                    this.registry.cleanRemoteData();
                }
                catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
                    if (!this.log.isErrorEnabled()) break block8;
                    this.log.error(registryException.getMessage());
                }
            }
            try {
                this.registry.delete(this.getRootPath(), true);
            }
            catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
                if (!this.log.isErrorEnabled()) break block9;
                this.log.error(registryException.getMessage());
            }
        }
        if (this.registryTopologyUpdater != null) {
            this.registryTopologyUpdater.shutdownNow();
        }
        try {
            this.registry.stop();
        }
        catch (LifeCycleException lifeCycleException) {
            throw new RegistryException(lifeCycleException);
        }
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("topology")) {
            return this.localTopologyService;
        }
        if (string.startsWith(string)) {
            return this.listeners.get(string);
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("topology")) {
            this.localTopologyService = null;
            return;
        }
        if (this.listeners.containsKey(string)) {
            this.listeners.remove(string);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    protected final String getRootPath() {
        return "/endpoints/" + this.configurationService.getContainerConfiguration().getName() + "/";
    }

    @Override
    public List<RegistryListener> getListeners() {
        ArrayList<RegistryListener> arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList<RegistryListener>();
            for (Object object : this.listeners.values()) {
                if (!(object instanceof RegistryListener)) continue;
                arrayList.add((RegistryListener)object);
            }
        }
        return arrayList;
    }

    @Override
    public void synchronizeData() throws RegistryException {
        if (this.registry == null) {
            throw new RegistryException("Registry is null and can not be managed!");
        }
        try {
            this.registry.synchronizeData();
        }
        catch (org.ow2.petals.registry.api.exception.RegistryException registryException) {
            throw new RegistryException(registryException);
        }
    }

    class TopologyExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        TopologyExceptionHandler() {
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            DistributedEndpointRegistryImpl.this.logger.log(BasicLevel.ERROR, (Object)(String.valueOf(throwable.getMessage()) + " : " + throwable.getCause()));
        }
    }

    class TopologyUpdater
    implements Runnable {
        TopologyUpdater() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    DistributedEndpointRegistryImpl.this.registry.pauseReceive();
                    if (!DistributedEndpointRegistryImpl.this.registeredOnMaster) {
                        DistributedEndpointRegistryImpl.this.localTopologyService.registerLocalContainerOnMaster();
                        DistributedEndpointRegistryImpl.this.registeredOnMaster = true;
                    }
                    DistributedEndpointRegistryImpl.this.localTopologyService.updateTopology();
                    Set<ContainerConfiguration> set = DistributedEndpointRegistryImpl.this.localTopologyService.getContainersConfigurationsForLocalSubdomain();
                    for (ContainerConfiguration containerConfiguration : set) {
                        RemoteConfiguration remoteConfiguration = new RemoteConfiguration("Registry@PETALSESB-" + containerConfiguration.getName());
                        remoteConfiguration.setMessageSenderClassName(DistributedEndpointRegistryImpl.this.localConfig.getMessageSenderClassName());
                        String string = "http://" + containerConfiguration.getHost() + ":" + containerConfiguration.getRegistryPort();
                        remoteConfiguration.setUri(string);
                        DistributedEndpointRegistryImpl.this.registry.getContext().getTopology().add(remoteConfiguration);
                    }
                }
                catch (Throwable throwable) {
                    DistributedEndpointRegistryImpl.this.registeredOnMaster = false;
                    DistributedEndpointRegistryImpl.this.log.warning("Can't synchronize local topology with master topology : " + throwable.getCause());
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                DistributedEndpointRegistryImpl.this.registry.resumeReceive();
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            DistributedEndpointRegistryImpl.this.registry.resumeReceive();
        }
    }
}

