/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Cardinality;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.commons.stream.InputStreamForker;
import org.ow2.petals.commons.stream.ReaderInputStream;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.InstallModule;
import org.ow2.petals.jbi.messaging.routing.module.ReceiverModule;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.transport.TransportException;
import org.ow2.petals.transport.TransportListener;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RouterService.class), @Interface(name="transportlistener", signature=TransportListener.class)})
public class RouterServiceImpl
implements BindingController,
LifeCycleController,
RouterService,
TransportListener {
    private LoggerFactory loggerFactory;
    private static final String INSTALLMODULE_FRACTAL_PREFIX = "installmodule";
    private static final String PROVIDER_SUFFIX = "-provider";
    private static final int QUEUE_SIZE = 10000;
    private static final String RECEIVERMODULE_FRACTAL_PREFIX = "receivermodule";
    private static final String SENDERMODULE_FRACTAL_PREFIX = "sendermodule";
    private static final int STOP_TRAFFIC_TIMEOUT = 10000;
    private static final String TRANSPORTER_FRACTAL_PREFIX = "transporter";
    private Map<String, Map<String, InputStreamForker>> exchangeForkedStreamCache;
    private Map<String, BlockingQueue<MessageExchange>> exchangeQueues;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="installmodule", signature=InstallModule.class)
    private final Map<String, Object> installModules = new Hashtable<String, Object>();
    private LoggingUtil log;
    private Logger logger;
    private Map<String, List<MessageExchange>> pendingMessageExchanges;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="receivermodule", signature=ReceiverModule.class)
    private final Map<String, Object> receiverModules = new Hashtable<String, Object>();
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="sendermodule", signature=SenderModule.class)
    private final Map<String, Object> senderModules = new Hashtable<String, Object>();
    private boolean stopTraffic;
    private List<Thread> threadsList;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="transporter", signature=Transporter.class)
    private final Map<String, Object> transporters = new Hashtable<String, Object>();

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void addComponent(ComponentContext componentContext) throws RoutingException {
        this.log.start();
        for (Object object : this.installModules.values()) {
            ((InstallModule)object).addComponent(componentContext);
        }
        this.exchangeQueues.put(componentContext.getComponentName(), new ArrayBlockingQueue(10000));
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifiedSALifeCycle(List<ServiceUnitLifeCycle> list) {
        this.log.start();
        Map<String, List<MessageExchange>> map = this.pendingMessageExchanges;
        synchronized (map) {
            for (ServiceUnitLifeCycle serviceUnitLifeCycle : list) {
                List list2 = serviceUnitLifeCycle.getServiceUnitDescriptor().getServices().getProvides();
                if (list2 == null) continue;
                String string = serviceUnitLifeCycle.getCurrentState();
                for (org.ow2.petals.jbi.descriptor.original.generated.Provides provides : list2) {
                    String string2 = String.valueOf(provides.getEndpointName()) + provides.getServiceName() + PROVIDER_SUFFIX;
                    if ("Stopped".equals(string) || "Shutdown".equals(string)) {
                        if (this.pendingMessageExchanges.containsKey(string2)) continue;
                        this.pendingMessageExchanges.put(string2, new Vector(100));
                        continue;
                    }
                    if (!"Started".equals(string)) continue;
                    BlockingQueue<MessageExchange> blockingQueue = this.exchangeQueues.get(serviceUnitLifeCycle.getTargetComponentName());
                    blockingQueue.addAll((Collection<MessageExchange>)this.pendingMessageExchanges.remove(string2));
                }
            }
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExchange(MessageExchange messageExchange) {
        this.log.start();
        String string = null;
        Map<String, List<MessageExchange>> map = this.pendingMessageExchanges;
        synchronized (map) {
            if (messageExchange.getRole().equals(MessageExchange.Role.CONSUMER)) {
                string = messageExchange.getConsumerEndpoint().getLocation().getComponentName();
            } else if (messageExchange.getRole().equals(MessageExchange.Role.PROVIDER)) {
                ServiceEndpoint serviceEndpoint = (ServiceEndpoint)messageExchange.getEndpoint();
                String string2 = String.valueOf(serviceEndpoint.getEndpointName()) + serviceEndpoint.getServiceName() + PROVIDER_SUFFIX;
                if (this.pendingMessageExchanges.containsKey(string2)) {
                    this.log.debug("SU not started, store the exchange");
                    this.pendingMessageExchanges.get(string2).add(messageExchange);
                } else {
                    string = ((ServiceEndpoint)messageExchange.getEndpoint()).getLocation().getComponentName();
                }
            }
        }
        if (string != null) {
            this.exchangeQueues.get(string).add(messageExchange);
        }
        this.log.end();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MessageExchange receive(ComponentContext componentContext, long l) throws RoutingException {
        Iterator<Object> iterator;
        MessageExchange messageExchange;
        String string;
        block9: {
            block8: {
                string = componentContext.getComponentName();
                this.log.start("Component : " + string + " - Timeout : " + l);
                this.checkStopTraffic();
                if (l != 0L) break block8;
                messageExchange = (MessageExchange)this.exchangeQueues.get(string).poll();
                break block9;
            }
            this.threadsList.add(Thread.currentThread());
            try {
                try {
                    messageExchange = l > 0L ? this.exchangeQueues.get(string).poll(l, TimeUnit.MILLISECONDS) : this.exchangeQueues.get(string).take();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new RoutingException("The pending receipt for the component '" + componentContext.getComponentName() + "' is interrupted", interruptedException);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.threadsList.remove(Thread.currentThread());
                throw throwable;
            }
            {
                iterator = null;
                this.threadsList.remove(Thread.currentThread());
            }
        }
        if (messageExchange == null) {
            this.log.end("No exchange - Component : " + string);
            return messageExchange;
        }
        iterator = this.receiverModules.values().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.log.end("Exchange Id : " + messageExchange.getExchangeId() + " - Component : " + string);
                return messageExchange;
            }
            Object object = iterator.next();
            ((ReceiverModule)object).receiveExchange(messageExchange, componentContext);
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.startsWith(INSTALLMODULE_FRACTAL_PREFIX)) {
            if (!InstallModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + InstallModule.class.getName());
            }
            this.installModules.put(string, object);
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.startsWith(RECEIVERMODULE_FRACTAL_PREFIX)) {
            if (!ReceiverModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ReceiverModule.class.getName());
            }
            this.receiverModules.put(string, object);
            return;
        }
        if (string.startsWith(SENDERMODULE_FRACTAL_PREFIX)) {
            if (!SenderModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SenderModule.class.getName());
            }
            this.senderModules.put(string, object);
            return;
        }
        if (string.startsWith(TRANSPORTER_FRACTAL_PREFIX)) {
            if (!Transporter.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + Transporter.class.getName());
            }
            this.transporters.put(string, object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.installModules.keySet());
        arrayList.addAll(this.receiverModules.keySet());
        arrayList.addAll(this.senderModules.keySet());
        arrayList.addAll(this.transporters.keySet());
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.startsWith(string)) {
            return this.installModules.get(string);
        }
        if (string.startsWith(string)) {
            return this.receiverModules.get(string);
        }
        if (string.startsWith(string)) {
            return this.senderModules.get(string);
        }
        if (string.startsWith(string)) {
            return this.transporters.get(string);
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void removeComponent(ComponentContext componentContext) throws RoutingException {
        this.log.start();
        for (Object object : this.installModules.values()) {
            ((InstallModule)object).removeComponent(componentContext);
        }
        this.exchangeQueues.remove(componentContext.getComponentName());
        this.log.end();
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (this.installModules.containsKey(string)) {
            this.installModules.remove(string);
            return;
        }
        if (this.receiverModules.containsKey(string)) {
            this.receiverModules.remove(string);
            return;
        }
        if (this.senderModules.containsKey(string)) {
            this.senderModules.remove(string);
            return;
        }
        if (this.transporters.containsKey(string)) {
            this.transporters.remove(string);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void send(ComponentContext componentContext, MessageExchange messageExchange) throws RoutingException {
        this.log.call();
        this.checkStopTraffic();
        if (!RouterServiceImpl.checkBypassMessageExchange(messageExchange)) {
            messageExchange.cleanMessages();
            LinkedHashMap<ServiceEndpoint, TransportSendContext> linkedHashMap = new LinkedHashMap<ServiceEndpoint, TransportSendContext>();
            for (Object object : this.senderModules.values()) {
                ((SenderModule)object).electEndpoints(linkedHashMap, componentContext, messageExchange);
            }
            if (MessageExchange.Role.CONSUMER.equals(messageExchange.getRole())) {
                messageExchange.setRole(MessageExchange.Role.PROVIDER);
            } else {
                messageExchange.setRole(MessageExchange.Role.CONSUMER);
            }
            if (MessageExchange.Role.PROVIDER.equals(messageExchange.getRole())) {
                this.sendToProvider(linkedHashMap, componentContext, messageExchange, false, 0L);
            } else {
                Object object;
                object = (TransportSendContext)linkedHashMap.values().iterator().next();
                this.sendToConsumer((TransportSendContext)object, messageExchange, false, 0L);
            }
        }
    }

    @Override
    public MessageExchange sendSync(ComponentContext componentContext, MessageExchange messageExchange, long l) throws RoutingException {
        Object object2;
        this.log.call();
        this.checkStopTraffic();
        messageExchange.cleanMessages();
        this.removeBypassMessageExchange(messageExchange);
        LinkedHashMap<ServiceEndpoint, TransportSendContext> linkedHashMap = new LinkedHashMap<ServiceEndpoint, TransportSendContext>();
        for (Object object2 : this.senderModules.values()) {
            ((SenderModule)object2).electEndpoints(linkedHashMap, componentContext, messageExchange);
        }
        if (MessageExchange.Role.CONSUMER.equals(messageExchange.getRole())) {
            messageExchange.setRole(MessageExchange.Role.PROVIDER);
        } else {
            messageExchange.setRole(MessageExchange.Role.CONSUMER);
        }
        object2 = null;
        if (MessageExchange.Role.PROVIDER.equals(messageExchange.getRole())) {
            object2 = this.sendToProvider(linkedHashMap, componentContext, messageExchange, true, l);
        } else {
            Object object3 = (TransportSendContext)linkedHashMap.values().iterator().next();
            object2 = this.sendToConsumer((TransportSendContext)object3, messageExchange, true, l);
        }
        for (Object object3 : this.receiverModules.values()) {
            ((ReceiverModule)object3).receiveExchange((MessageExchange)object2, componentContext);
        }
        return object2;
    }

    @Override
    public void stopTraffic() {
        this.log.start();
        long l = 10000L + System.currentTimeMillis();
        boolean bl = false;
        try {
            while (System.currentTimeMillis() < l && !bl) {
                for (BlockingQueue<MessageExchange> blockingQueue : this.exchangeQueues.values()) {
                    if (blockingQueue.size() <= 0) continue;
                    Thread.sleep(1000L);
                    break;
                }
                bl = true;
            }
        }
        catch (InterruptedException interruptedException) {}
        if (!bl) {
            this.log.warning("The timeout for stopping the Router traffic has been reached. Some message have not beed accepted by the component, they are lost.");
        }
        this.stopTraffic = true;
        boolean bl2 = true;
        while (bl2) {
            try {
                for (Thread thread : this.threadsList) {
                    if (!thread.isAlive()) continue;
                    thread.interrupt();
                }
                bl2 = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws RoutingException {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
        this.exchangeQueues = new ConcurrentHashMap<String, BlockingQueue<MessageExchange>>();
        this.pendingMessageExchanges = new ConcurrentHashMap<String, List<MessageExchange>>();
        this.exchangeForkedStreamCache = new ConcurrentHashMap<String, Map<String, InputStreamForker>>();
        this.threadsList = new Vector<Thread>(100);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws RoutingException {
        this.log.call();
    }

    private void checkStopTraffic() throws RoutingException {
        if (this.stopTraffic) {
            Thread.currentThread().interrupt();
            throw new RoutingException("The Router traffic is stopped", new InterruptedException());
        }
    }

    private void cleanExchangeSources(MessageExchange messageExchange) {
        Map<String, InputStreamForker> map = this.exchangeForkedStreamCache.remove(messageExchange.getExchangeId());
        if (map != null) {
            for (InputStreamForker inputStreamForker : map.values()) {
                try {
                    inputStreamForker.getInputStreamTwo().close();
                }
                catch (IOException iOException) {
                    this.log.warning("Failed to clean a forked Source", iOException);
                }
            }
        }
    }

    private void forkExchangeSources(MessageExchange messageExchange) throws MessagingException {
        Map<String, InputStreamForker> map = this.exchangeForkedStreamCache.get(messageExchange.getExchangeId());
        if (map == null) {
            map = new HashMap<String, InputStreamForker>();
            this.exchangeForkedStreamCache.put(messageExchange.getExchangeId(), map);
        }
        Map<String, NormalizedMessage> map2 = messageExchange.getMessages();
        for (String string : map2.keySet()) {
            StreamSource streamSource;
            InputStream inputStream;
            Source source = map2.get(string).getContent();
            if (!(source instanceof StreamSource)) continue;
            InputStreamForker inputStreamForker = map.get(string);
            inputStreamForker = inputStreamForker != null ? new InputStreamForker(inputStreamForker.getInputStreamTwo()) : ((inputStream = (streamSource = (StreamSource)source).getInputStream()) != null ? new InputStreamForker(inputStream) : new InputStreamForker((InputStream)new ReaderInputStream(streamSource.getReader())));
            map.put(string, inputStreamForker);
            streamSource = new StreamSource(inputStreamForker.getInputStreamOne());
            map2.get(string).setContent((Source)streamSource);
        }
    }

    private boolean removeBypassMessageExchange(MessageExchange messageExchange) {
        this.log.call();
        if (messageExchange.isTerminated()) {
            if (MessageExchange.Role.CONSUMER.equals(messageExchange.getRole())) {
                if (messageExchange.getProperty("org.ow2.petals.router.consumer.noack") != null) {
                    messageExchange.setProperty("org.ow2.petals.router.consumer.noack", "false");
                    this.log.warning("Property 'org.ow2.petals.router.consumer.noack' is not supported by a synchronous sending");
                }
            } else if (messageExchange.getProperty("org.ow2.petals.router.provider.noack") != null) {
                messageExchange.setProperty("org.ow2.petals.router.provider.noack", "false");
                this.log.warning("Property 'org.ow2.petals.router.provider.noack' is not supported by a synchronous sending");
            }
        }
        return false;
    }

    private MessageExchange sendToConsumer(TransportSendContext transportSendContext, MessageExchange messageExchange, boolean bl, long l) throws RoutingException {
        this.log.start();
        MessageExchange messageExchange2 = null;
        long l2 = System.currentTimeMillis();
        boolean bl2 = true;
        int n = 0;
        while (bl2) {
            bl2 = false;
            if (n != 0) {
                try {
                    Thread.sleep(transportSendContext.delay);
                }
                catch (InterruptedException interruptedException) {
                    throw new RoutingException(interruptedException);
                }
            }
            try {
                if (transportSendContext.attempt > 1) {
                    try {
                        this.forkExchangeSources(messageExchange);
                    }
                    catch (MessagingException messagingException) {
                        throw new RoutingException(messagingException);
                    }
                }
                if (bl) {
                    if (l > 0L) {
                        long l3 = System.currentTimeMillis() - l2;
                        if (l3 > l) {
                            messageExchange.setRole(MessageExchange.Role.PROVIDER);
                            bl2 = false;
                            break;
                        }
                        transportSendContext.timeout = l - l3;
                    }
                    if ((messageExchange2 = ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).sendSync(messageExchange, transportSendContext)) == null) {
                        messageExchange.setRole(MessageExchange.Role.PROVIDER);
                    }
                } else {
                    ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).send(messageExchange, transportSendContext);
                }
                bl2 = false;
            }
            catch (TransportException transportException) {
                transportSendContext.attempt = (short)(transportSendContext.attempt - 1);
                if (transportSendContext.attempt > 0) {
                    this.log.warning("The send attempt to the " + transportSendContext.destination + " failed", (Throwable)((Object)transportException));
                    bl2 = true;
                    n = transportSendContext.delay;
                    continue;
                }
                messageExchange.setRole(MessageExchange.Role.PROVIDER);
                throw new RoutingException((Throwable)((Object)transportException));
            }
        }
        this.cleanExchangeSources(messageExchange);
        this.log.end();
        return messageExchange2;
    }

    private MessageExchange sendToProvider(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchange messageExchange, boolean bl, long l) throws RoutingException {
        this.log.start();
        MessageExchange messageExchange2 = null;
        TransportSendContext transportSendContext = null;
        long l2 = System.currentTimeMillis();
        boolean bl2 = true;
        int n = 0;
        block6: while (bl2) {
            if (n != 0) {
                this.log.debug("Wait " + n + " millisecond before the next send attempt");
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    throw new RoutingException(interruptedException);
                }
            }
            bl2 = false;
            Iterator<ServiceEndpoint> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                ServiceEndpoint serviceEndpoint = iterator.next();
                transportSendContext = map.get(serviceEndpoint);
                if (transportSendContext.attempt <= 0) continue;
                this.log.debug("Send attempt to endpoint '" + serviceEndpoint.getEndpointName() + "'");
                try {
                    messageExchange.setEndpoint(serviceEndpoint);
                    messageExchange.setService(serviceEndpoint.getServiceName());
                    messageExchange.setInterfaceName(serviceEndpoint.getInterfaces()[0]);
                    if (iterator.hasNext() || n > 0 || transportSendContext.attempt > 1) {
                        try {
                            this.forkExchangeSources(messageExchange);
                        }
                        catch (MessagingException messagingException) {
                            throw new RoutingException(messagingException);
                        }
                    }
                    if (bl) {
                        if (l > 0L) {
                            long l3 = System.currentTimeMillis() - l2;
                            if (l3 > l) {
                                this.log.debug("Timeout reached!");
                                messageExchange.setRole(MessageExchange.Role.CONSUMER);
                                bl2 = false;
                                continue block6;
                            }
                            transportSendContext.timeout = l - l3;
                        }
                        if ((messageExchange2 = ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).sendSync(messageExchange, transportSendContext)) == null) {
                            messageExchange.setRole(MessageExchange.Role.CONSUMER);
                        }
                    } else {
                        ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).send(messageExchange, transportSendContext);
                    }
                    bl2 = false;
                    continue block6;
                }
                catch (TransportException transportException) {
                    transportSendContext.attempt = (short)(transportSendContext.attempt - 1);
                    if (transportSendContext.attempt > 0) {
                        bl2 = true;
                        if (transportSendContext.delay > n) {
                            n = transportSendContext.delay;
                        }
                    }
                    if (iterator.hasNext() || bl2) {
                        this.log.warning("The send attempt to the endpoint '" + serviceEndpoint.getEndpointName() + "' with destination " + transportSendContext.destination + " failed", (Throwable)((Object)transportException));
                        continue;
                    }
                    messageExchange.setRole(MessageExchange.Role.CONSUMER);
                    throw new RoutingException((Throwable)((Object)transportException));
                }
            }
        }
        this.cleanExchangeSources(messageExchange);
        this.log.end();
        return messageExchange2;
    }

    private static final boolean checkBypassMessageExchange(MessageExchange messageExchange) {
        boolean bl = false;
        Object object = null;
        if (messageExchange.isTerminated()) {
            object = MessageExchange.Role.CONSUMER.equals(messageExchange.getRole()) ? messageExchange.getProperty("org.ow2.petals.router.provider.noack") : messageExchange.getProperty("org.ow2.petals.router.consumer.noack");
            bl = object != null && object.toString().toLowerCase().equals("true");
        }
        return bl;
    }
}

