/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.jbi.component.Component;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.descriptor.original.generated.LinkType;
import org.ow2.petals.jbi.messaging.control.ExchangeCheckerClient;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.jbi.messaging.routing.module.endpoint.EndpointOrderer;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class)})
public class EndpointResolverModule
implements BindingController,
LifeCycleController,
SenderModule {
    private LoggerFactory loggerFactory;
    protected LoggingUtil log;
    protected Logger logger;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    protected EndpointRegistry endpointRegistry;
    @Requires(contingency=Contingency.OPTIONAL, name="topology", signature=TopologyService.class)
    protected TopologyService topologyService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    @Requires(name="checker", signature=ExchangeCheckerClient.class)
    protected ExchangeCheckerClient exchangeCheckerService;
    public static final List<Object> DEFAULT_STRATEGY_PARAMETERS = Arrays.asList("highest", new Float(3.0f), new Float(2.0f), new Float(1.0f));
    private static List<Object> defaultStrategyParameters;
    private EndpointOrderer endpointOrderer;
    private Random random;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
        try {
            defaultStrategyParameters = EndpointResolverModule.tokenizeAndAnalyseStrategy(containerConfiguration.getRouterStrategy());
        }
        catch (RoutingException routingException) {
            defaultStrategyParameters = DEFAULT_STRATEGY_PARAMETERS;
        }
        this.endpointOrderer = new EndpointOrderer(this.log, containerConfiguration, this.topologyService);
        this.random = new Random();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws RoutingException {
        this.log.call();
    }

    @Override
    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, org.ow2.petals.jbi.messaging.exchange.MessageExchange messageExchange) throws RoutingException {
        this.log.call();
        if (MessageExchange.Role.CONSUMER.equals(messageExchange.getRole())) {
            List<ServiceEndpoint> list = this.resolveEndpoints(componentContext.getComponent(), messageExchange);
            for (ServiceEndpoint serviceEndpoint : list) {
                map.put(serviceEndpoint, new TransportSendContext(serviceEndpoint.getLocation()));
            }
        } else {
            map.put(messageExchange.getConsumerEndpoint(), new TransportSendContext(messageExchange.getConsumerEndpoint().getLocation()));
        }
    }

    private List<ServiceEndpoint> resolveEndpoints(Component component, MessageExchange messageExchange) throws RoutingException {
        this.log.start();
        ServiceEndpoint serviceEndpoint = (ServiceEndpoint)messageExchange.getEndpoint();
        QName qName = messageExchange.getService();
        QName qName2 = messageExchange.getInterfaceName();
        LinkType linkType = LinkType.STANDARD;
        if (messageExchange.getProperty("org.ow2.petals.router.provider.linktype") != null) {
            linkType = LinkType.fromValue((String)((String)messageExchange.getProperty("org.ow2.petals.router.provider.linktype")));
        }
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        if (serviceEndpoint != null) {
            ServiceEndpoint serviceEndpoint2 = this.getTargetedEndpointFromGivenEndpoint(serviceEndpoint, linkType);
            arrayList.add(serviceEndpoint2);
        } else if (qName != null) {
            arrayList = this.getTargetedEndpointFromGivenServiceName(qName, messageExchange, component, linkType);
        } else if (qName2 != null) {
            arrayList = this.getTargetedEndpointFromGivenInterfaceName(qName2, messageExchange, component, linkType);
        }
        if (arrayList == null || arrayList.size() == 0) {
            throw new RoutingException("Failed to find a destination for the MessageExchange with id: " + messageExchange.getExchangeId());
        }
        this.log.end();
        return arrayList;
    }

    private ServiceEndpoint getTargetedEndpointFromGivenEndpoint(ServiceEndpoint serviceEndpoint, LinkType linkType) throws RoutingException {
        this.log.call();
        ServiceEndpoint serviceEndpoint2 = null;
        if (serviceEndpoint.getType() == ServiceEndpoint.EndpointType.INTERNAL) {
            if (linkType == LinkType.SOFT) {
                throw new RoutingException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' is not a SOFT link");
            }
            serviceEndpoint2 = serviceEndpoint;
        } else if (serviceEndpoint.getType() == ServiceEndpoint.EndpointType.LINKED) {
            if (linkType == LinkType.HARD) {
                throw new RoutingException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' is not an HARD link");
            }
            try {
                serviceEndpoint2 = this.endpointRegistry.getEndpoint(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
            }
            catch (RegistryException registryException) {
                throw new RoutingException((Throwable)((Object)registryException));
            }
        } else if (serviceEndpoint.getType() == ServiceEndpoint.EndpointType.EXTERNAL) {
            serviceEndpoint2 = this.findEndpointInRegistry(serviceEndpoint);
        }
        return serviceEndpoint2;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("checker")) {
            if (!ExchangeCheckerClient.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ExchangeCheckerClient.class.getName());
            }
            this.exchangeCheckerService = (ExchangeCheckerClient)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("endpoint");
        arrayList.add("topology");
        arrayList.add("configuration");
        arrayList.add("checker");
        return arrayList.toArray(new String[0]);
    }

    private ServiceEndpoint findEndpointInRegistry(ServiceEndpoint serviceEndpoint) throws RoutingException {
        this.log.call();
        ServiceEndpoint serviceEndpoint2 = null;
        try {
            serviceEndpoint2 = this.endpointRegistry.getEndpoint(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
        }
        catch (RegistryException registryException) {
            throw new RoutingException(registryException.getMessage());
        }
        if (serviceEndpoint2 == null) {
            throw new RoutingException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' does not match a registered endpoint");
        }
        return serviceEndpoint2;
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        if (string.equals("topology")) {
            return this.topologyService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("checker")) {
            return this.exchangeCheckerService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("checker")) {
            this.exchangeCheckerService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private List<ServiceEndpoint> getTargetedEndpointFromGivenServiceName(QName qName, MessageExchange messageExchange, Component component, LinkType linkType) throws RoutingException {
        this.log.call();
        List<ServiceEndpoint> list = null;
        try {
            list = this.getEnabledEndpoints(kindSearch.SERVICE_SEARCH, component, qName, messageExchange, linkType);
        }
        catch (RegistryException registryException) {
            throw new RoutingException((Throwable)((Object)registryException));
        }
        List<Object> list2 = EndpointResolverModule.getAndAnalyseStrategy(messageExchange);
        List<ServiceEndpoint> list3 = null;
        if (list.size() == 1) {
            list3 = new ArrayList<ServiceEndpoint>(1);
            list3.add(list.get(0));
        } else if (list.size() > 1) {
            list3 = this.endpointOrderer.orderEndpoints(list, messageExchange, list2, this.random);
        }
        if (list3 == null || list3.size() == 0) {
            throw new RoutingException("No endpoint found matching the target service '" + qName + "'");
        }
        return list3;
    }

    private List<ServiceEndpoint> getTargetedEndpointFromGivenInterfaceName(QName qName, MessageExchange messageExchange, Component component, LinkType linkType) throws RoutingException {
        this.log.call();
        List<ServiceEndpoint> list = null;
        try {
            list = this.getEnabledEndpoints(kindSearch.INTERFACE_SEARCH, component, qName, messageExchange, linkType);
        }
        catch (RegistryException registryException) {
            throw new RoutingException((Throwable)((Object)registryException));
        }
        List<Object> list2 = EndpointResolverModule.getAndAnalyseStrategy(messageExchange);
        List<ServiceEndpoint> list3 = null;
        if (list.size() == 1) {
            list3 = new ArrayList<ServiceEndpoint>(1);
            list3.add(list.get(0));
        } else if (list.size() > 1) {
            list3 = this.endpointOrderer.orderEndpoints(list, messageExchange, list2, this.random);
        }
        if (list3 == null || list3.size() == 0) {
            throw new RoutingException("No endpoint found matching the target interface '" + qName + "'");
        }
        return list3;
    }

    private List<ServiceEndpoint> getEnabledEndpoints(kindSearch kindSearch2, Component component, QName qName, MessageExchange messageExchange, LinkType linkType) throws RegistryException {
        this.log.call();
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        ServiceEndpoint[] serviceEndpointArray = null;
        serviceEndpointArray = kindSearch2 == kindSearch.SERVICE_SEARCH ? this.endpointRegistry.getInternalEndpointsForService(qName, linkType) : this.endpointRegistry.getInternalEndpointsForInterface(qName, linkType);
        ServiceEndpoint[] serviceEndpointArray2 = serviceEndpointArray;
        int n = serviceEndpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceEndpoint serviceEndpoint = serviceEndpointArray2[n2];
            if (this.controlAcceptationExchange(component, serviceEndpoint, messageExchange)) {
                arrayList.add(serviceEndpoint);
            }
            ++n2;
        }
        return arrayList;
    }

    private boolean controlAcceptationExchange(Component component, ServiceEndpoint serviceEndpoint, MessageExchange messageExchange) {
        this.log.call();
        boolean bl = false;
        if (this.configurationService.getContainerConfiguration().isExchangeValidation()) {
            if (component.isExchangeWithProviderOkay((javax.jbi.servicedesc.ServiceEndpoint)serviceEndpoint, messageExchange) && this.exchangeCheckerService.isExchangeWithConsumerOkayForComponent(serviceEndpoint, messageExchange)) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private static List<Object> getAndAnalyseStrategy(MessageExchange messageExchange) throws RoutingException {
        if (messageExchange == null) {
            throw new NullPointerException("the exchange must be non null");
        }
        String string = (String)messageExchange.getProperty("org.objectweb.petals.routing.strategy");
        List<Object> list = string == null ? defaultStrategyParameters : EndpointResolverModule.tokenizeAndAnalyseStrategy(string);
        return list;
    }

    private static List<Object> tokenizeAndAnalyseStrategy(String string) throws RoutingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return EndpointResolverModule.analyseStrategy(arrayList);
    }

    private static List<Object> analyseStrategy(List<String> list) throws RoutingException {
        ArrayList<Object> arrayList = null;
        try {
            if (list == null || list.size() != 4) {
                throw new RoutingException("Invalid Parameters: 4 parameters are required to configure the routing strategy");
            }
            EndpointOrderer.verifStrategyParameters(list.get(0).toLowerCase(), Float.valueOf(list.get(1)).floatValue(), Float.valueOf(list.get(2)).floatValue(), Float.valueOf(list.get(3)).floatValue());
            arrayList = new ArrayList<Object>();
            arrayList.add(list.get(0).toLowerCase());
            arrayList.add(Float.valueOf(list.get(1)));
            arrayList.add(Float.valueOf(list.get(2)));
            arrayList.add(Float.valueOf(list.get(3)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RoutingException("Impossible to convert the parameters to realize the routing strategy");
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum kindSearch {
        SERVICE_SEARCH,
        INTERFACE_SEARCH;

    }
}

