/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module.endpoint;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jbi.messaging.MessageExchange;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.EndpointResolverModule;
import org.ow2.petals.jbi.messaging.routing.module.endpoint.WeightedEndpoint;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndpointOrderer {
    public static final String HIGHEST = "highest";
    public static final String RANDOM = "random";
    public static final String PROPERTY_STRATEGY_PROTOCOLS = "org.objectweb.petals.routing.strategy";
    public static final int NUMBER_STRATEGY_PARAMETERS = 4;
    public static final String STRATEGY_SEPARATOR = ",";
    private LoggingUtil log;
    private ContainerConfiguration containerConfiguration;
    private TopologyService topologyService;

    public EndpointOrderer(LoggingUtil loggingUtil, ContainerConfiguration containerConfiguration, TopologyService topologyService) {
        this.log = loggingUtil;
        this.containerConfiguration = containerConfiguration;
        this.topologyService = topologyService;
    }

    public List<ServiceEndpoint> orderEndpoints(List<ServiceEndpoint> list, MessageExchange messageExchange, List<Object> list2, Random random) throws RoutingException {
        float f;
        float f2;
        float f3;
        String string;
        Object object;
        if (!(EndpointResolverModule.DEFAULT_STRATEGY_PARAMETERS.equals(list2) || list2 != null && list2.size() >= 4)) {
            throw new RoutingException("Invalid Parameters: 4 parameters are required to configure the routing strategy");
        }
        try {
            object = list2.toArray();
            string = ((String)object[0]).toLowerCase();
            f3 = ((Float)object[1]).floatValue();
            f2 = ((Float)object[2]).floatValue();
            f = ((Float)object[3]).floatValue();
        }
        catch (ClassCastException classCastException) {
            throw new RoutingException("Impossible to convert the parameters to realize the routing strategy");
        }
        if (!EndpointResolverModule.DEFAULT_STRATEGY_PARAMETERS.equals(list2)) {
            EndpointOrderer.verifStrategyParameters(string, f3, f2, f);
        }
        object = null;
        if (string.equals(HIGHEST)) {
            object = this.loadHighestChoose(list, messageExchange, f3, f2, f, random);
        } else if (string.equals(RANDOM)) {
            object = this.loadRandomChoose(list, messageExchange, f3, f2, f, random);
        }
        return object;
    }

    public static final void verifStrategyParameters(String string, float f, float f2, float f3) throws RoutingException {
        if (!string.equals(HIGHEST) && !string.equals(RANDOM)) {
            throw new RoutingException("the " + string + " routing strategy is unknown");
        }
        if (f < 0.0f || f2 < 0.0f || f3 < 0.0f) {
            throw new RoutingException("impossible to have a negative parameter in routing strategy");
        }
        if (f == 0.0f && f2 == 0.0f && f3 == 0.0f) {
            throw new RoutingException("Impossible to find an endpoint with these ponderations: 0,0,0");
        }
    }

    private List<ServiceEndpoint> loadRandomChoose(List<ServiceEndpoint> list, MessageExchange messageExchange, float f, float f2, float f3, Random random) {
        TreeSet<WeightedEndpoint> treeSet = new TreeSet<WeightedEndpoint>(new Comparator<WeightedEndpoint>(){

            @Override
            public int compare(WeightedEndpoint weightedEndpoint, WeightedEndpoint weightedEndpoint2) {
                return weightedEndpoint.weight.compareTo(weightedEndpoint2.weight);
            }
        });
        this.log.debug("Apply the algorithm RANDOM");
        return this.fillSortedList(list, f, f2, f3, random, treeSet);
    }

    private List<ServiceEndpoint> loadHighestChoose(List<ServiceEndpoint> list, MessageExchange messageExchange, float f, float f2, float f3, Random random) {
        final Float[] floatArray = new Float[]{Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3)};
        TreeSet<WeightedEndpoint> treeSet = new TreeSet<WeightedEndpoint>(new Comparator<WeightedEndpoint>(){

            @Override
            public int compare(WeightedEndpoint weightedEndpoint, WeightedEndpoint weightedEndpoint2) {
                int n = floatArray[weightedEndpoint2.localization.ordinal()].compareTo(floatArray[weightedEndpoint.localization.ordinal()]);
                if (n != 0) {
                    return n;
                }
                return weightedEndpoint.weight.compareTo(weightedEndpoint2.weight);
            }
        });
        this.log.debug("Apply the algorithm HIGHEST");
        return this.fillSortedList(list, f, f2, f3, random, treeSet);
    }

    private List<ServiceEndpoint> fillSortedList(List<ServiceEndpoint> list, float f, float f2, float f3, Random random, SortedSet<WeightedEndpoint> sortedSet) {
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        for (ServiceEndpoint object : list) {
            if (ServiceEndpoint.EndpointType.INTERNAL.equals((Object)object.getType())) {
                String string = object.getLocation().getContainerName();
                if (string.equals(this.containerConfiguration.getName())) {
                    sortedSet.add(new WeightedEndpoint(object, f * random.nextFloat(), WeightedEndpoint.Localization.LOCAL));
                    continue;
                }
                if (this.topologyService.isContainerStarted(string)) {
                    sortedSet.add(new WeightedEndpoint(object, f2 * random.nextFloat(), WeightedEndpoint.Localization.REMOTE_ACTIVE));
                    continue;
                }
                sortedSet.add(new WeightedEndpoint(object, f3 * random.nextFloat(), WeightedEndpoint.Localization.REMOTE_INACTIVE));
                continue;
            }
            sortedSet.add(new WeightedEndpoint(object, f2 * random.nextFloat(), WeightedEndpoint.Localization.REMOTE_ACTIVE));
        }
        for (WeightedEndpoint weightedEndpoint : sortedSet) {
            arrayList.add(weightedEndpoint.endpoint);
        }
        return arrayList;
    }
}

