/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jbi.messaging.MessageExchange;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.strategy.HighestStrategy;
import org.ow2.petals.jbi.messaging.routing.module.strategy.RandomStrategy;
import org.ow2.petals.jbi.messaging.routing.module.strategy.StandaloneStrategy;
import org.ow2.petals.jbi.messaging.routing.module.strategy.Strategy;
import org.ow2.petals.kernel.configuration.ConfigurationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndpointChooserStrategy {
    public static final String STRATEGY_SEPARATOR = ",";
    private final Map<String, Strategy> strategiesMap;
    private final TopologyService topologyService;
    private final ConfigurationService configurationService;

    public EndpointChooserStrategy(ConfigurationService configurationService, TopologyService topologyService) {
        this.topologyService = topologyService;
        this.configurationService = configurationService;
        this.strategiesMap = new Hashtable<String, Strategy>();
    }

    public synchronized javax.jbi.servicedesc.ServiceEndpoint choose(List<ServiceEndpoint> list, MessageExchange messageExchange) throws RoutingException {
        javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint = null;
        if (list.size() > 1) {
            Strategy strategy = this.analyseAndGetStrategy(messageExchange);
            serviceEndpoint = strategy.electEndpoint(list, messageExchange);
        } else if (list.size() == 1) {
            serviceEndpoint = list.get(0);
        }
        return serviceEndpoint;
    }

    public Map<javax.jbi.servicedesc.ServiceEndpoint, Float> getWeightingEndpoints(List<ServiceEndpoint> list, float f, float f2, float f3) {
        HashMap<javax.jbi.servicedesc.ServiceEndpoint, Float> hashMap = new HashMap<javax.jbi.servicedesc.ServiceEndpoint, Float>();
        for (ServiceEndpoint serviceEndpoint : list) {
            if (serviceEndpoint.getLocation().getContainerName().equals(this.configurationService.getContainerConfiguration().getName())) {
                hashMap.put(serviceEndpoint, new Float(f));
                continue;
            }
            if (this.topologyService.isContainerStarted(serviceEndpoint.getLocation().getContainerName())) {
                hashMap.put(serviceEndpoint, new Float(f2));
                continue;
            }
            hashMap.put(serviceEndpoint, new Float(f3));
        }
        return hashMap;
    }

    private Strategy getStrategy(String string) throws RoutingException {
        Strategy strategy = this.strategiesMap.get(string);
        if (strategy == null) {
            if ("standalone".equals(string)) {
                strategy = this.strategiesMap.put("standalone", new StandaloneStrategy());
            } else if ("random".equals(string)) {
                strategy = this.strategiesMap.put("random", new RandomStrategy(this));
            } else if ("highest".equals(string)) {
                strategy = this.strategiesMap.put("highest", new HighestStrategy(this));
            } else {
                throw new RoutingException("The " + string + " routing strategy is unknown");
            }
        }
        return strategy;
    }

    private Strategy analyseAndGetStrategy(MessageExchange messageExchange) throws RoutingException {
        Strategy strategy = null;
        if (messageExchange == null) {
            throw new NullPointerException("The exchange must be non null");
        }
        String string = (String)messageExchange.getProperty("org.ow2.petals.routing.strategy");
        if (string == null) {
            strategy = this.getDefaultRoutingStrategy();
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, STRATEGY_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
            if (arrayList.size() == 0) {
                throw new RoutingException("The first parameter of the routing strategy is mandatory");
            }
            strategy = this.getStrategy((String)arrayList.get(0));
            arrayList.remove(0);
            strategy.validateStrategyParameters(arrayList);
        }
        return strategy;
    }

    private Strategy getDefaultRoutingStrategy() throws RoutingException {
        if (!this.strategiesMap.containsKey("default")) {
            String string = this.configurationService.getContainerConfiguration().getRouterStrategy();
            StringTokenizer stringTokenizer = new StringTokenizer(string, STRATEGY_SEPARATOR);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
            if (arrayList.size() == 0) {
                throw new RoutingException("The first parameter of the routing strategy is mandatory");
            }
            Strategy strategy = null;
            if ("standalone".equals(arrayList.get(0))) {
                strategy = new StandaloneStrategy();
            } else if ("random".equals(arrayList.get(0))) {
                strategy = new RandomStrategy(this);
            } else if ("highest".equals(arrayList.get(0))) {
                strategy = new HighestStrategy(this);
            } else {
                throw new RoutingException("The " + (String)arrayList.get(0) + " routing strategy is unknown");
            }
            arrayList.remove(0);
            strategy.validateStrategyParameters(arrayList);
            this.strategiesMap.put("default", strategy);
        }
        return this.strategiesMap.get("default");
    }
}

