/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module.strategy;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.jbi.messaging.MessageExchange;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.strategy.EndpointChooserStrategy;
import org.ow2.petals.jbi.messaging.routing.module.strategy.Strategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighestStrategy
implements Strategy {
    private static final int NUMBER_STRATEGY_PARAMETERS = 3;
    public EndpointChooserStrategy endpointChooserStrategy;
    private float localWeighting;
    private float remoteActiveWeighting;
    private float remoteInactiveWeighting;
    private Random random = new Random();

    public HighestStrategy(EndpointChooserStrategy endpointChooserStrategy) {
        this.endpointChooserStrategy = endpointChooserStrategy;
    }

    @Override
    public void validateStrategyParameters(List<String> list) throws RoutingException {
        try {
            if (list.size() != 3) {
                throw new RoutingException("Invalid parameters: 3 parameters are required by the highest routing strategy");
            }
            Iterator<String> iterator = list.iterator();
            this.localWeighting = Float.valueOf(iterator.next()).floatValue();
            this.remoteActiveWeighting = Float.valueOf(iterator.next()).floatValue();
            this.remoteInactiveWeighting = Float.valueOf(iterator.next()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new RoutingException("Impossible to convert values of parameters for the highest routing strategy");
        }
        if (this.localWeighting < 0.0f || this.remoteActiveWeighting < 0.0f || this.remoteInactiveWeighting < 0.0f) {
            throw new RoutingException("Negative parameter not allowed by the highest strategy");
        }
        if (this.localWeighting == 0.0f && this.remoteActiveWeighting == 0.0f && this.remoteInactiveWeighting == 0.0f) {
            throw new RoutingException("Weighting 0,0,0 is not allowed by the highest strategy");
        }
    }

    @Override
    public javax.jbi.servicedesc.ServiceEndpoint electEndpoint(List<ServiceEndpoint> list, MessageExchange messageExchange) throws RoutingException {
        javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint = null;
        float[] fArray = HighestStrategy.sortWeighting(this.localWeighting, this.remoteActiveWeighting, this.remoteInactiveWeighting);
        Map<javax.jbi.servicedesc.ServiceEndpoint, Float> map = this.endpointChooserStrategy.getWeightingEndpoints(list, this.localWeighting, this.remoteActiveWeighting, this.remoteInactiveWeighting);
        int n = this.random.nextInt(list.size());
        int n2 = 0;
        while (n2 < list.size()) {
            int n3 = (n2 + n) % list.size();
            if (map.get(list.get(n3)).equals(Float.valueOf(fArray[2]))) {
                serviceEndpoint = list.get(n3);
                break;
            }
            ++n2;
        }
        return serviceEndpoint;
    }

    private static float[] sortWeighting(float f, float f2, float f3) {
        float[] fArray = new float[]{f, f2, f3};
        Arrays.sort(fArray);
        return fArray;
    }
}

