/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module.strategy;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.jbi.messaging.MessageExchange;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.strategy.EndpointChooserStrategy;
import org.ow2.petals.jbi.messaging.routing.module.strategy.Strategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomStrategy
implements Strategy {
    private static final int NUMBER_STRATEGY_PARAMETERS = 3;
    public EndpointChooserStrategy endpointChooserStrategy;
    private float localWeighting;
    private float remoteActiveWeighting;
    private float remoteInactiveWeighting;
    private Random random = new Random();

    public RandomStrategy(EndpointChooserStrategy endpointChooserStrategy) {
        this.endpointChooserStrategy = endpointChooserStrategy;
    }

    @Override
    public void validateStrategyParameters(List<String> list) throws RoutingException {
        try {
            if (list.size() != 3) {
                throw new RoutingException("Invalid parameters: 3 parameters are required by the random routing strategy");
            }
            Iterator<String> iterator = list.iterator();
            this.localWeighting = Float.valueOf(iterator.next()).floatValue();
            this.remoteActiveWeighting = Float.valueOf(iterator.next()).floatValue();
            this.remoteInactiveWeighting = Float.valueOf(iterator.next()).floatValue();
        }
        catch (ClassCastException classCastException) {
            throw new RoutingException("Impossible to convert values of parameters for the random routing strategy");
        }
        if (this.localWeighting < 0.0f || this.remoteActiveWeighting < 0.0f || this.remoteInactiveWeighting < 0.0f) {
            throw new RoutingException("Negative parameter not allowed by the random strategy");
        }
        if (this.localWeighting == 0.0f && this.remoteActiveWeighting == 0.0f && this.remoteInactiveWeighting == 0.0f) {
            throw new RoutingException("Weighting 0,0,0 is not allowed by the random strategy");
        }
    }

    @Override
    public javax.jbi.servicedesc.ServiceEndpoint electEndpoint(List<ServiceEndpoint> list, MessageExchange messageExchange) throws RoutingException {
        Map<javax.jbi.servicedesc.ServiceEndpoint, Float> map = this.endpointChooserStrategy.getWeightingEndpoints(list, this.localWeighting, this.remoteActiveWeighting, this.remoteInactiveWeighting);
        float f = RandomStrategy.sumWeightings(map) * this.random.nextFloat();
        javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint2 = null;
        Iterator<ServiceEndpoint> iterator = list.iterator();
        if (f == 0.0f) {
            serviceEndpoint2 = iterator.next();
        }
        while (serviceEndpoint2 == null && iterator.hasNext()) {
            serviceEndpoint = iterator.next();
            f3 = f2 + map.get(serviceEndpoint).floatValue();
            if (f2 <= f && f < f3) {
                serviceEndpoint2 = serviceEndpoint;
            }
            f2 = f3;
        }
        return serviceEndpoint2;
    }

    private static float sumWeightings(Map<javax.jbi.servicedesc.ServiceEndpoint, Float> map) {
        float f = 0.0f;
        for (Float f2 : map.values()) {
            f += f2.floatValue();
        }
        return f;
    }
}

