/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.management.deployment.DeploymentServiceMBean;
import org.ow2.petals.jbi.management.installation.InstallationServiceMBean;
import org.ow2.petals.kernel.admin.PetalsAdminInterface;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.kernel.configuration.SubDomainConfiguration;
import org.ow2.petals.kernel.server.PetalsStopThread;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=PetalsAdminInterface.class)})
public class PetalsAdminServiceImpl
implements BindingController,
LifeCycleController,
PetalsAdminInterface {
    private LoggerFactory loggerFactory;
    protected LoggingUtil log;
    protected Logger logger;
    @Requires(name="deployment", signature=DeploymentServiceMBean.class)
    protected DeploymentServiceMBean deployment;
    @Requires(name="installation", signature=InstallationServiceMBean.class)
    protected InstallationServiceMBean installation;
    @Requires(contingency=Contingency.OPTIONAL, name="topology", signature=TopologyService.class)
    protected TopologyService topologyService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private ContainerConfiguration containerConfiguration;
    private SubDomainConfiguration subDomainConfiguration;
    private DomainConfiguration domainConfiguration;
    private PetalsStopThread petalsStopThread;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public Set<Map<String, String>> retrieveTopology() throws PetalsException {
        this.log.start();
        HashSet<Map<String, String>> hashSet = new HashSet<Map<String, String>>();
        hashSet.add(this.getDomainMap());
        Set<SubDomainConfiguration> set = this.getSubDomainsConfiguration();
        for (SubDomainConfiguration object2 : set) {
            hashSet.add(this.getSubdomainMap(object2));
        }
        Set<ContainerConfiguration> set2 = this.getContainersConfiguration();
        for (Object containerConfiguration : set2) {
            Map<String, String> map = this.getContainerMap((ContainerConfiguration)containerConfiguration);
            hashSet.add(map);
        }
        this.log.end();
        return hashSet;
    }

    @Override
    public void shutdownContainer() throws Exception {
        this.log.start();
        this.log.info("PEtALS is shutting down...");
        this.log.info("  1/3 Undeploy Service Assemblies...");
        try {
            this.deployment.shutdown();
        }
        catch (Exception exception) {
            this.log.error("Can not shut down the Deployment service.", exception);
        }
        this.log.info("  2/3 Uninstall Shared Libraries and Components...");
        try {
            this.installation.shutdown();
        }
        catch (Exception exception) {
            this.log.error("Can not shut down the Installation service", exception);
        }
        this.log.info("  3/3 Stopping the server...");
        this.petalsStopThread.start();
        this.log.end();
    }

    @Override
    public void stopContainer() throws Exception {
        this.log.start();
        this.log.info("PEtALS is stopping...");
        this.petalsStopThread.start();
        this.log.end();
    }

    @Override
    public void setPetalsStopThread(PetalsStopThread petalsStopThread) {
        this.petalsStopThread = petalsStopThread;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IllegalLifeCycleException {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
        this.containerConfiguration = this.configurationService.getContainerConfiguration();
        this.subDomainConfiguration = this.configurationService.getSubDomainConfiguration();
        this.domainConfiguration = this.configurationService.getDomainConfiguration();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws IllegalLifeCycleException {
        this.log.call();
    }

    private Set<ContainerConfiguration> getContainersConfiguration() throws PetalsException {
        this.log.start();
        HashSet<ContainerConfiguration> hashSet = null;
        if (this.topologyService == null) {
            hashSet = new HashSet<ContainerConfiguration>();
            hashSet.add(this.containerConfiguration);
        } else {
            hashSet = this.topologyService.getContainersConfiguration(null);
        }
        this.log.end();
        return hashSet;
    }

    private Set<SubDomainConfiguration> getSubDomainsConfiguration() throws PetalsException {
        this.log.start();
        Set<Object> set = null;
        if (this.topologyService == null) {
            set = new HashSet();
            set.add(this.subDomainConfiguration);
        } else {
            set = this.topologyService.getSubDomainsConfiguration();
        }
        this.log.end();
        return set;
    }

    private Map<String, String> getDomainMap() {
        this.log.start();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", "domain");
        hashMap.put("domainName", this.domainConfiguration.getName());
        if (this.domainConfiguration.getDescription() != null) {
            hashMap.put("domainDescription", this.domainConfiguration.getDescription());
        }
        if (DomainConfiguration.DomainMode.STATIC.equals((Object)this.domainConfiguration.getMode())) {
            hashMap.put("domainMode", "static");
        } else {
            hashMap.put("domainMode", "standalone");
        }
        if (this.domainConfiguration.getJndiConfiguration() != null) {
            URI uRI;
            if (this.domainConfiguration.getJndiConfiguration().getJndiFactory() != null) {
                hashMap.put("jndiFactory", this.domainConfiguration.getJndiConfiguration().getJndiFactory());
            }
            if ((uRI = this.domainConfiguration.getJndiConfiguration().getJndiProviderUrl()) != null) {
                hashMap.put("jndiHost", uRI.getHost());
                hashMap.put("jndiPort", Integer.toString(uRI.getPort()));
            }
        }
        this.log.end();
        return hashMap;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("deployment")) {
            if (!DeploymentServiceMBean.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DeploymentServiceMBean.class.getName());
            }
            this.deployment = (DeploymentServiceMBean)object;
            return;
        }
        if (string.equals("installation")) {
            if (!InstallationServiceMBean.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + InstallationServiceMBean.class.getName());
            }
            this.installation = (InstallationServiceMBean)object;
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private Map<String, String> getSubdomainMap(SubDomainConfiguration subDomainConfiguration) {
        this.log.start();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", "subdomain");
        hashtable.put("subdomainName", subDomainConfiguration.getName());
        if (subDomainConfiguration.getDescription() != null) {
            hashtable.put("subdomainDescription", subDomainConfiguration.getDescription());
        }
        hashtable.put("networkTimeSynchronized", Boolean.toString(subDomainConfiguration.isNetworkTimeSynchronized()));
        this.log.end();
        return hashtable;
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("deployment");
        arrayList.add("installation");
        arrayList.add("topology");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("deployment")) {
            return this.deployment;
        }
        if (string.equals("installation")) {
            return this.installation;
        }
        if (string.equals("topology")) {
            return this.topologyService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private Map<String, String> getContainerMap(ContainerConfiguration containerConfiguration) {
        this.log.start();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", "container");
        hashtable.put("containerName", containerConfiguration.getName());
        if (containerConfiguration.getDescription() != null) {
            hashtable.put("containerDescription", containerConfiguration.getDescription());
        }
        hashtable.put("subdomainName", containerConfiguration.getSubdomainName());
        hashtable.put("host", containerConfiguration.getHost());
        hashtable.put("user", containerConfiguration.getUser());
        hashtable.put("password", containerConfiguration.getPassword());
        hashtable.put("jmxRMIPort", Integer.toString(containerConfiguration.getJmxRMIConnectorPort()));
        if (containerConfiguration.getTCPPort() != 0) {
            hashtable.put("TCPPort", Integer.toString(containerConfiguration.getTCPPort()));
        }
        if (ContainerConfiguration.ContainerState.STARTED.equals((Object)containerConfiguration.getState())) {
            hashtable.put("state", "STARTED");
        } else {
            hashtable.put("state", "STOPPED");
        }
        this.log.end();
        return hashtable;
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("deployment")) {
            this.deployment = null;
            return;
        }
        if (string.equals("installation")) {
            this.installation = null;
            return;
        }
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public boolean ping() {
        return this.topologyService.isContainerStarted(this.containerConfiguration.getName());
    }
}

