/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.configuration;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.ow2.petals.kernel.api.server.util.SystemUtil;
import org.ow2.petals.kernel.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerConfiguration
implements Serializable {
    private static final long serialVersionUID = 6543213857L;
    private String subdomainName;
    private String name;
    private String description;
    private String host;
    private ContainerState state = ContainerState.UNKNOWN;
    private String rootDirectoryPath;
    private String repositoryDirectoryPath;
    private String workDirectoryPath;
    private boolean exchangeValidation;
    private long taskTimeout;
    private boolean isolateJBIClassLoaders;
    private boolean activateAutoloader = true;
    private String user;
    private String password;
    private int jmxRMIConnectorPort;
    private int webservicePort = 9001;
    private String webservicePrefix = "petals/ws";
    private String routerQOS = "fast";
    private String routerStrategy = "random,1,1,1";
    private short routerSendAttempt = (short)2;
    private int routerSendDelay = 1000;
    private long topologyUpdatePeriod = 30L;
    private int tcpPort;
    private String sslKeyPassword;
    private int tcpReceivers = 10;
    private int tcpSenders = 10;
    private long tcpConnectionTimeout = 5000L;
    private long tcpSendTimeout = 5000L;
    private long tcpSenderEvictorDelay = 60000L;
    private long tcpSenderEvictableDelay = 60000L;
    private String sslKeystore;
    private String sslKeystorePassword;
    private String sslTruststore;
    private String sslTruststorePassword;
    private int registryPort;
    private RegistryMode registryMode = null;
    private int registrySynchroPeriod = 0;
    private int registryTransportTimeout = 0;
    private String registryIncomingManagerClassName = null;
    private String registryOutgoingManagerClassName = null;
    private String registryMessageSenderClassName = null;
    private String registryMessageReceiverClassName = null;
    private String registryRepository = null;
    private String registryDatabaseDriver = null;
    private String registryDatabaseUrl = null;
    private String registryDatabaseUser = null;
    private String registryDatabasePassword = null;
    private String registryDatabaseDialect = null;
    private Map<String, String> userConfiguration;

    public void init() throws ConfigurationException {
        try {
            this.setRootDirectoryPath(SystemUtil.getPetalsInstallDirectory().getCanonicalPath());
        }
        catch (IOException iOException) {
            throw new ConfigurationException("The PEtALS install directory is not valid : " + SystemUtil.getPetalsInstallDirectory().getAbsolutePath());
        }
        this.setRepositoryDirectoryPath(String.valueOf(this.getRootDirectoryPath()) + File.separator + "repository");
        this.setWorkDirectoryPath(String.valueOf(this.getRootDirectoryPath()) + File.separator + "work");
    }

    public static long getSerialVersionUID() {
        return 6543213857L;
    }

    public String getSubdomainName() {
        return this.subdomainName;
    }

    public void setSubdomainName(String string) {
        this.subdomainName = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public ContainerState getState() {
        return this.state;
    }

    public void setState(ContainerState containerState) {
        this.state = containerState;
    }

    public String getRootDirectoryPath() {
        return this.rootDirectoryPath;
    }

    public void setRootDirectoryPath(String string) {
        this.rootDirectoryPath = string;
    }

    public String getRepositoryDirectoryPath() {
        return this.repositoryDirectoryPath;
    }

    public void setRepositoryDirectoryPath(String string) {
        this.repositoryDirectoryPath = string;
    }

    public String getWorkDirectoryPath() {
        return this.workDirectoryPath;
    }

    public void setWorkDirectoryPath(String string) {
        this.workDirectoryPath = string;
    }

    public boolean isExchangeValidation() {
        return this.exchangeValidation;
    }

    public void setExchangeValidation(boolean bl) {
        this.exchangeValidation = bl;
    }

    public long getTaskTimeout() {
        return this.taskTimeout;
    }

    public void setTaskTimeout(long l) {
        this.taskTimeout = l;
    }

    public boolean isIsolateJBIClassLoaders() {
        return this.isolateJBIClassLoaders;
    }

    public void setIsolateJBIClassLoaders(boolean bl) {
        this.isolateJBIClassLoaders = bl;
    }

    public boolean isActivateAutoloader() {
        return this.activateAutoloader;
    }

    public void setActivateAutoloader(boolean bl) {
        this.activateAutoloader = bl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public int getJmxRMIConnectorPort() {
        return this.jmxRMIConnectorPort;
    }

    public void setJmxRMIConnectorPort(int n) {
        this.jmxRMIConnectorPort = n;
    }

    public int getWebservicePort() {
        return this.webservicePort;
    }

    public void setWebservicePort(int n) {
        this.webservicePort = n;
    }

    public String getWebservicePrefix() {
        return this.webservicePrefix;
    }

    public void setWebservicePrefix(String string) {
        this.webservicePrefix = string;
    }

    public String getTransportQOS() {
        return this.routerQOS;
    }

    public String getRouterQOS() {
        return this.routerQOS;
    }

    public void setTransportQOS(String string) {
        this.setRouterQOS(string);
    }

    public String getRouterStrategy() {
        return this.routerStrategy;
    }

    public void setRouterStrategy(String string) {
        this.routerStrategy = string;
    }

    public short getRouterSendAttempt() {
        return this.routerSendAttempt;
    }

    public void setRouterSendAttempt(short s) {
        this.routerSendAttempt = s;
    }

    public int getRouterSendDelay() {
        return this.routerSendDelay;
    }

    public void setRouterSendDelay(int n) {
        this.routerSendDelay = n;
    }

    public int getTCPPort() {
        return this.tcpPort;
    }

    public void setTCPPort(int n) {
        this.setTcpPort(n);
    }

    public String getSSLKeyPassword() {
        return this.sslKeyPassword;
    }

    public void setSSLKeyPassword(String string) {
        this.setSslKeyPassword(string);
    }

    public int getTCPReceivers() {
        return this.tcpReceivers;
    }

    public void setTCPReceivers(int n) {
        this.setTcpReceivers(n);
    }

    public int getTCPSenders() {
        return this.tcpSenders;
    }

    public void setTCPSenders(int n) {
        this.setTcpSenders(n);
    }

    public long getTCPConnectionTimeout() {
        return this.tcpConnectionTimeout;
    }

    public void setTCPConnectionTimeout(long l) {
        this.setTcpConnectionTimeout(l);
    }

    public long getTCPSendTimeout() {
        return this.tcpSendTimeout;
    }

    public void setTCPSendTimeout(long l) {
        this.setTcpSendTimeout(l);
    }

    public long getTCPSenderEvictorDelay() {
        return this.tcpSenderEvictorDelay;
    }

    public void setTCPSenderEvictorDelay(long l) {
        this.setTcpSenderEvictorDelay(l);
    }

    public long getTCPSenderEvictableDelay() {
        return this.tcpSenderEvictableDelay;
    }

    public void setTCPSenderEvictableDelay(long l) {
        this.setTcpSenderEvictableDelay(l);
    }

    public String getSSLKeystore() {
        return this.sslKeystore;
    }

    public void setSSLKeystore(String string) {
        this.setSslKeystore(string);
    }

    public String getSSLKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public void setSSLKeystorePassword(String string) {
        this.setSslKeystorePassword(string);
    }

    public String getSSLTruststore() {
        return this.sslTruststore;
    }

    public void setSSLTruststore(String string) {
        this.setSslTruststore(string);
    }

    public String getSSLTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public void setSSLTruststorePassword(String string) {
        this.setSslTruststorePassword(string);
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public void setRegistryPort(int n) {
        this.registryPort = n;
    }

    public RegistryMode getRegistryMode() {
        return this.registryMode;
    }

    public long getTopologyUpdatePeriod() {
        return this.topologyUpdatePeriod;
    }

    public void setRegistryMode(RegistryMode registryMode) {
        this.registryMode = registryMode;
    }

    public boolean isMaster() {
        return this.getRegistryMode().equals((Object)RegistryMode.MASTER);
    }

    public boolean isSlave() {
        return this.getRegistryMode().equals((Object)RegistryMode.SLAVE);
    }

    public boolean isInMasterSlaveMode() {
        return this.isMaster() || this.isSlave();
    }

    public boolean isInFloodingMode() {
        return this.isPeer();
    }

    public boolean isPeer() {
        return this.getRegistryMode().equals((Object)RegistryMode.PEER);
    }

    public boolean isInStandaloneMode() {
        return this.isStandalone();
    }

    public boolean isStandalone() {
        return this.getRegistryMode().equals((Object)RegistryMode.STANDALONE);
    }

    public int getRegistrySynchroPeriod() {
        return this.registrySynchroPeriod;
    }

    protected void setRegistrySynchroPeriod(int n) {
        this.registrySynchroPeriod = n;
    }

    public int getRegistryTransportTimeout() {
        return this.registryTransportTimeout;
    }

    protected void setRegistryTransportTimeout(int n) {
        this.registryTransportTimeout = n;
    }

    public String getRegistryIncomingManagerClassName() {
        return this.registryIncomingManagerClassName;
    }

    protected void setRegistryIncomingManagerClassName(String string) {
        this.registryIncomingManagerClassName = string;
    }

    public String getRegistryOutgoingManagerClassName() {
        return this.registryOutgoingManagerClassName;
    }

    protected void setRegistryOutgoingManagerClassName(String string) {
        this.registryOutgoingManagerClassName = string;
    }

    public String getRegistryMessageSenderClassName() {
        return this.registryMessageSenderClassName;
    }

    protected void setRegistryMessageSenderClassName(String string) {
        this.registryMessageSenderClassName = string;
    }

    public String getRegistryMessageReceiverClassName() {
        return this.registryMessageReceiverClassName;
    }

    protected void setRegistryMessageReceiverClassName(String string) {
        this.registryMessageReceiverClassName = string;
    }

    public String getRegistryRepository() {
        return this.registryRepository;
    }

    protected void setRegistryRepository(String string) {
        this.registryRepository = string;
    }

    public String getRegistryDatabaseDriver() {
        return this.registryDatabaseDriver;
    }

    protected void setRegistryDatabaseDriver(String string) {
        this.registryDatabaseDriver = string;
    }

    public String getRegistryDatabaseUrl() {
        return this.registryDatabaseUrl;
    }

    protected void setRegistryDatabaseUrl(String string) {
        this.registryDatabaseUrl = string;
    }

    public String getRegistryDatabaseUser() {
        return this.registryDatabaseUser;
    }

    protected void setRegistryDatabaseUser(String string) {
        this.registryDatabaseUser = string;
    }

    public String getRegistryDatabasePassword() {
        return this.registryDatabasePassword;
    }

    protected void setRegistryDatabasePassword(String string) {
        this.registryDatabasePassword = string;
    }

    public String getRegistryDatabaseDialect() {
        return this.registryDatabaseDialect;
    }

    protected void setRegistryDatabaseDialect(String string) {
        this.registryDatabaseDialect = string;
    }

    public Map<String, String> getUserConfiguration() {
        return this.userConfiguration;
    }

    protected void setUserConfiguration(Map<String, String> map) {
        this.setUserConfiguration(map);
    }

    public void setRouterQOS(String string) {
        this.routerQOS = string;
    }

    public void setTcpPort(int n) {
        this.tcpPort = n;
    }

    public void setSslKeyPassword(String string) {
        this.sslKeyPassword = string;
    }

    public void setTcpReceivers(int n) {
        this.tcpReceivers = n;
    }

    public void setTcpSenders(int n) {
        this.tcpSenders = n;
    }

    public void setTcpConnectionTimeout(long l) {
        this.tcpConnectionTimeout = l;
    }

    public void setTcpSendTimeout(long l) {
        this.tcpSendTimeout = l;
    }

    public void setTcpSenderEvictorDelay(long l) {
        this.tcpSenderEvictorDelay = l;
    }

    public void setTcpSenderEvictableDelay(long l) {
        this.tcpSenderEvictableDelay = l;
    }

    public void setSslKeystore(String string) {
        this.sslKeystore = string;
    }

    public void setSslKeystorePassword(String string) {
        this.sslKeystorePassword = string;
    }

    public void setSslTruststore(String string) {
        this.sslTruststore = string;
    }

    public void setSslTruststorePassword(String string) {
        this.sslTruststorePassword = string;
    }

    public void setTopologyUpdatePeriod(long l) {
        this.topologyUpdatePeriod = l;
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Container ").append(this.getName()).append(" on ").append(this.getHost()).append(" in sub-domain ").append(this.getSubdomainName());
        if (this.getDescription() != null) {
            stringBuilder.append("\n\t\t\tDescription :\n\t\t\t  ").append(this.getDescription());
        }
        stringBuilder.append("\n\t\t\tConfiguration :\n\t\t\t  - InstallDirectory:").append(this.getRootDirectoryPath());
        stringBuilder.append("\n\t\t\t  - RepositoryDirectory:").append(this.getRepositoryDirectoryPath());
        stringBuilder.append("\n\t\t\t  - ExchangeValidation:").append(this.isExchangeValidation());
        stringBuilder.append("\n\t\t\t  - TransportQOS:").append(this.getTransportQOS());
        stringBuilder.append("\n\t\t\t  - RoutingStrategy:").append(this.getRouterStrategy());
        stringBuilder.append("\n\t\t\t  - TaskTimeout:").append(this.getTaskTimeout());
        stringBuilder.append("\n\t\t\t  - IsolateClassLoaders:").append(this.isIsolateJBIClassLoaders());
        stringBuilder.append("\n\t\t\t  - ActivateAutoloader:").append(this.isActivateAutoloader());
        stringBuilder.append("\n\t\t\t  - User:").append(this.getUser() != null ? this.getUser() : "none");
        if (this.getPassword() != null) {
            stringBuffer = new StringBuffer(this.getPassword().length());
            while (stringBuffer.length() < this.getPassword().length()) {
                stringBuffer.append("*");
            }
            stringBuilder.append("\n\t\t\t  - Password:").append(stringBuffer);
        } else {
            stringBuilder.append("\n\t\t\t  - Password:none");
        }
        stringBuilder.append("\n\t\t\t  - JMXRMIConnectionPort:").append(this.getJmxRMIConnectorPort());
        stringBuilder.append("\n\t\t\t  - TCPPort:").append(this.getTCPPort() != 0 ? Integer.valueOf(this.getTCPPort()) : "none");
        if (this.getSSLKeyPassword() != null) {
            stringBuffer = new StringBuffer(this.getSSLKeyPassword().length());
            while (stringBuffer.length() < this.getSSLKeyPassword().length()) {
                stringBuffer.append("*");
            }
            stringBuilder.append("\n\t\t\t  - sslKeyPassword:").append(stringBuffer);
        } else {
            stringBuilder.append("\n\t\t\t  - sslKeyPassword:none");
        }
        stringBuilder.append("\n\t\t\t  - Keystore:").append(this.getSSLKeystore() != null ? this.getSSLKeystore() : "none");
        if (this.getSSLKeystorePassword() != null) {
            stringBuffer = new StringBuffer(this.getSSLKeystorePassword().length());
            while (stringBuffer.length() < this.getSSLKeystorePassword().length()) {
                stringBuffer.append("*");
            }
            stringBuilder.append("\n\t\t\t  - KeystorePassword:").append(stringBuffer);
        } else {
            stringBuilder.append("\n\t\t\t  - KeystorePassword:none");
        }
        stringBuilder.append("\n\t\t\t  - Truststore:").append(this.getSSLTruststore() != null ? this.getSSLTruststore() : "none");
        if (this.getSSLTruststorePassword() != null) {
            stringBuffer = new StringBuffer(this.getSSLTruststorePassword().length());
            while (stringBuffer.length() < this.getSSLTruststorePassword().length()) {
                stringBuffer.append("*");
            }
            stringBuilder.append("\n\t\t\t  - TruststorePassword:").append(stringBuffer);
        } else {
            stringBuilder.append("\n\t\t\t  - TruststorePassword:none");
        }
        if (this.getTCPPort() != 0) {
            stringBuilder.append("\n\t\t\t  - TCPReceivers:").append(this.getTCPReceivers());
            stringBuilder.append("\n\t\t\t  - TCPSenders:").append(this.getTCPSenders());
            stringBuilder.append("\n\t\t\t  - TCPConnectionTimeout:").append(this.getTCPConnectionTimeout());
            stringBuilder.append("\n\t\t\t  - TCPSendTimeout:").append(this.getTCPSendTimeout());
            stringBuilder.append("\n\t\t\t  - TCPSenderEvictorDelay:").append(this.getTCPSenderEvictorDelay());
            stringBuilder.append("\n\t\t\t  - TCPSenderEvictableDelay:").append(this.getTCPSenderEvictableDelay());
        }
        stringBuilder.append("\n\t\t\t  - State:").append(this.getState().name());
        stringBuilder.append("\n\t\t\t  - RegistryPort:").append(this.getRegistryPort());
        stringBuilder.append("\n\t\t\t  - RegistryMode:").append((Object)this.getRegistryMode());
        stringBuilder.append("\n\t\t\t  - RegistrySynchroPeriod:").append(this.getRegistrySynchroPeriod());
        stringBuilder.append("\n\t\t\t  - RegistryTransportTimeout:").append(this.getRegistryTransportTimeout());
        stringBuilder.append("\n\t\t\t  - RegistryIncomingManagerClassName:").append(this.getRegistryIncomingManagerClassName());
        stringBuilder.append("\n\t\t\t  - RegistryOutgoingManagerClassName:").append(this.getRegistryOutgoingManagerClassName());
        stringBuilder.append("\n\t\t\t  - RegistryMessageSenderClassName:").append(this.getRegistryMessageSenderClassName());
        stringBuilder.append("\n\t\t\t  - RegistryMessageReceiverClassName:").append(this.getRegistryMessageReceiverClassName());
        stringBuilder.append("\n\t\t\t  - RegistryRepository:").append(this.getRegistryRepository());
        stringBuilder.append("\n\t\t\t  - RegistryDatabaseDriver:").append(this.getRegistryDatabaseDriver());
        stringBuilder.append("\n\t\t\t  - RegistryDatabaseUrl:").append(this.getRegistryDatabaseUrl());
        stringBuilder.append("\n\t\t\t  - RegistryDatabaseUser:").append(this.getRegistryDatabaseUser());
        if (this.getRegistryDatabasePassword() != null) {
            stringBuffer = new StringBuffer(this.getRegistryDatabasePassword().length());
            while (stringBuffer.length() < this.getRegistryDatabasePassword().length()) {
                stringBuffer.append("*");
            }
            stringBuilder.append("\n\t\t\t  - RegistryDatabasePassword:").append(stringBuffer);
        } else {
            stringBuilder.append("\n\t\t\t  - RegistryDatabasePassword:none");
        }
        stringBuilder.append("\n\t\t\t  - RegistryDatabaseDialect:").append(this.getRegistryDatabaseDialect());
        stringBuilder.append("\n\t\t\t  - WebServicePort:").append(this.getWebservicePort());
        stringBuilder.append("\n\t\t\t  - WebServicePrefix:").append(this.getWebservicePrefix());
        if (this.getUserConfiguration() != null) {
            stringBuffer = new StringBuffer();
            for (String string : this.getUserConfiguration().keySet()) {
                stringBuffer.append("\n\t\t\t\t").append(string).append('=').append(this.getUserConfiguration().get(string));
            }
            stringBuilder.append("\n\t\t\t  - User properties:").append(stringBuffer.toString());
        }
        stringBuilder.append("\n\t\t\t  - Topology update period:").append(this.getTopologyUpdatePeriod());
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.isActivateAutoloader() ? 1231 : 1237);
        n = 31 * n + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        n = 31 * n + this.getTCPPort();
        n = 31 * n + this.getTCPReceivers();
        n = 31 * n + this.getTCPSenders();
        n = 31 * n + (int)(this.getTCPConnectionTimeout() ^ this.getTCPConnectionTimeout() >>> 32);
        n = 31 * n + (int)(this.getTCPSendTimeout() ^ this.getTCPSendTimeout() >>> 32);
        n = 31 * n + (int)(this.getTCPSenderEvictorDelay() ^ this.getTCPSenderEvictorDelay() >>> 32);
        n = 31 * n + (int)(this.getTCPSenderEvictableDelay() ^ this.getTCPSenderEvictableDelay() >>> 32);
        n = 31 * n + (this.isExchangeValidation() ? 1231 : 1237);
        n = 31 * n + (this.getHost() == null ? 0 : this.getHost().hashCode());
        n = 31 * n + (this.getRootDirectoryPath() == null ? 0 : this.getRootDirectoryPath().hashCode());
        n = 31 * n + (this.isIsolateJBIClassLoaders() ? 1231 : 1237);
        n = 31 * n + this.getJmxRMIConnectorPort();
        n = 31 * n + (this.getSSLKeyPassword() == null ? 0 : this.getSSLKeyPassword().hashCode());
        n = 31 * n + (this.getSSLKeystore() == null ? 0 : this.getSSLKeystore().hashCode());
        n = 31 * n + (this.getSSLKeystorePassword() == null ? 0 : this.getSSLKeystorePassword().hashCode());
        n = 31 * n + (this.getName() == null ? 0 : this.getName().hashCode());
        n = 31 * n + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        n = 31 * n + (this.getRepositoryDirectoryPath() == null ? 0 : this.getRepositoryDirectoryPath().hashCode());
        n = 31 * n + (this.getRouterStrategy() == null ? 0 : this.getRouterStrategy().hashCode());
        n = 31 * n + (this.getState() == null ? 0 : this.getState().hashCode());
        n = 31 * n + (this.getSubdomainName() == null ? 0 : this.getSubdomainName().hashCode());
        n = 31 * n + (int)(this.getTaskTimeout() ^ this.getTaskTimeout() >>> 32);
        n = 31 * n + (this.getTransportQOS() == null ? 0 : this.getTransportQOS().hashCode());
        n = 31 * n + (this.getSSLTruststore() == null ? 0 : this.getSSLTruststore().hashCode());
        n = 31 * n + (this.getSSLTruststorePassword() == null ? 0 : this.getSSLTruststorePassword().hashCode());
        n = 31 * n + (this.getUser() == null ? 0 : this.getUser().hashCode());
        n = 31 * n + this.getWebservicePort();
        n = 31 * n + (this.getWebservicePrefix() == null ? 0 : this.getWebservicePrefix().hashCode());
        n = 31 * n + (this.getUserConfiguration() == null ? 0 : this.getUserConfiguration().hashCode());
        n = 31 * n + this.getRegistryPort();
        n = 31 * n + (this.getRegistryMode() == null ? 0 : this.getRegistryMode().hashCode());
        n = 31 * n + this.getRegistrySynchroPeriod();
        n = 31 * n + this.getRegistryTransportTimeout();
        n = 31 * n + (this.getRegistryIncomingManagerClassName() == null ? 0 : this.getRegistryIncomingManagerClassName().hashCode());
        n = 31 * n + (this.getRegistryOutgoingManagerClassName() == null ? 0 : this.getRegistryOutgoingManagerClassName().hashCode());
        n = 31 * n + (this.getRegistryMessageSenderClassName() == null ? 0 : this.getRegistryMessageSenderClassName().hashCode());
        n = 31 * n + (this.getRegistryMessageReceiverClassName() == null ? 0 : this.getRegistryMessageReceiverClassName().hashCode());
        n = 31 * n + (this.getRegistryRepository() == null ? 0 : this.getRegistryRepository().hashCode());
        n = 31 * n + (this.getRegistryDatabaseDriver() == null ? 0 : this.getRegistryDatabaseDriver().hashCode());
        n = 31 * n + (this.getRegistryDatabaseUrl() == null ? 0 : this.getRegistryDatabaseUrl().hashCode());
        n = 31 * n + (this.getRegistryDatabaseUser() == null ? 0 : this.getRegistryDatabaseUser().hashCode());
        n = 31 * n + (this.getRegistryDatabasePassword() == null ? 0 : this.getRegistryDatabasePassword().hashCode());
        n = 31 * n + (this.getRegistryDatabaseDialect() == null ? 0 : this.getRegistryDatabaseDialect().hashCode());
        n = 31 * n + (int)this.getTopologyUpdatePeriod();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        boolean bl = false;
        if (object instanceof ContainerConfiguration) {
            ContainerConfiguration containerConfiguration = (ContainerConfiguration)object;
            bl = containerConfiguration.getName().equals(this.getName()) && containerConfiguration.getHost().equals(this.getHost()) && containerConfiguration.isExchangeValidation() == this.isExchangeValidation() && containerConfiguration.getTransportQOS().equals(this.getTransportQOS()) && containerConfiguration.getRouterStrategy().equals(this.getRouterStrategy()) && containerConfiguration.getTaskTimeout() == this.getTaskTimeout() && containerConfiguration.isIsolateJBIClassLoaders() == this.isIsolateJBIClassLoaders() && containerConfiguration.isActivateAutoloader() == this.isActivateAutoloader() && containerConfiguration.getUser().equals(this.getUser()) && containerConfiguration.getPassword().equals(this.getPassword()) && containerConfiguration.getJmxRMIConnectorPort() == this.getJmxRMIConnectorPort() && containerConfiguration.getTCPPort() == this.getTCPPort() && containerConfiguration.getRegistryMode() == this.getRegistryMode() && containerConfiguration.getTCPReceivers() == this.getTCPReceivers() && containerConfiguration.getTCPSenders() == this.getTCPSenders() && containerConfiguration.getTCPConnectionTimeout() == this.getTCPConnectionTimeout() && containerConfiguration.getTCPSendTimeout() == this.getTCPSendTimeout() && containerConfiguration.getTCPSenderEvictorDelay() == this.getTCPSenderEvictorDelay() && containerConfiguration.getTCPSenderEvictableDelay() == this.getTCPSenderEvictableDelay() && containerConfiguration.getSSLKeyPassword().equals(this.getSSLKeyPassword()) && containerConfiguration.getSSLKeystore().equals(this.getSSLKeystore()) && containerConfiguration.getSSLKeystorePassword().equals(this.getSSLKeystorePassword()) && containerConfiguration.getSSLTruststore().equals(this.getSSLTruststore()) && containerConfiguration.getSSLTruststorePassword().equals(this.getSSLTruststorePassword()) && containerConfiguration.getWebservicePort() == this.getWebservicePort() && containerConfiguration.getWebservicePrefix().equals(this.getWebservicePrefix()) && containerConfiguration.getRegistryPort() == this.getRegistryPort() && containerConfiguration.getRegistryMode().equals((Object)this.getRegistryMode()) && containerConfiguration.getRegistrySynchroPeriod() == this.getRegistrySynchroPeriod() && containerConfiguration.getRegistryTransportTimeout() == this.getRegistryTransportTimeout() && containerConfiguration.getRegistryIncomingManagerClassName().equals(this.getRegistryIncomingManagerClassName()) && containerConfiguration.getRegistryOutgoingManagerClassName().equals(this.getRegistryOutgoingManagerClassName()) && containerConfiguration.getRegistryMessageSenderClassName().equals(this.getRegistryMessageSenderClassName()) && containerConfiguration.getRegistryMessageReceiverClassName().equals(this.getRegistryMessageReceiverClassName()) && containerConfiguration.getRegistryRepository().equals(this.getRegistryRepository()) && containerConfiguration.getRegistryDatabaseDriver().equals(this.getRegistryDatabaseDriver()) && containerConfiguration.getRegistryDatabaseUrl().equals(this.getRegistryDatabaseUrl()) && containerConfiguration.getRegistryDatabaseUser().equals(this.getRegistryDatabaseUser()) && containerConfiguration.getRegistryDatabasePassword().equals(this.getRegistryDatabasePassword()) && containerConfiguration.getRegistryDatabaseDialect().equals(this.getRegistryDatabaseDialect()) && (containerConfiguration.getUserConfiguration() == this.getUserConfiguration() || containerConfiguration.getUserConfiguration() != null && containerConfiguration.getUserConfiguration().equals(this.getUserConfiguration())) && containerConfiguration.getTopologyUpdatePeriod() == this.getTopologyUpdatePeriod();
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContainerState {
        STARTED,
        STOPPED,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RegistryMode {
        STANDALONE,
        PEER,
        MASTER,
        SLAVE;

    }
}

