/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.server;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.jmx.agent.Introspector;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.monolog.wrapper.remote.lib.MonologFactoryMBeanImpl;
import org.ow2.petals.communication.jmx.JMXService;
import org.ow2.petals.jbi.management.admin.AdminServiceMBean;
import org.ow2.petals.jbi.management.deployment.DeploymentServiceMBean;
import org.ow2.petals.jbi.management.installation.InstallationServiceMBean;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistryMBean;
import org.ow2.petals.kernel.admin.PetalsAdminServiceMBean;
import org.ow2.petals.kernel.server.FractalHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanHelper {
    public static String CURRENCY_TIME_LIMIT = "-1";
    public static final String DOMAIN = "Petals";
    public static final String ADMIN_MBEAN = "Admin";
    public static final String DEPLOYMENT_MBEAN = "Deployment";
    public static final String INSTALLATION_MBEAN = "Installation";
    public static final String LOGGER_MBEAN = "Logger";
    public static final String MONITORING_MBEAN = "Monitoring";
    public static final String ENDPOINT_MBEAN = "EndpointRegistry";
    public static final String PETALS_ADMIN = "PetalsAdmin";
    public static final String TRANSPORTER_MONITORING = "TransportMonitoring";

    public static final MBeanServer findLocalJMXServer(Component component) throws ADLException, NoSuchInterfaceException {
        ContentController contentController = Fractal.getContentController((Component)component);
        Component component2 = FractalHelper.getRecursiveComponentByName(contentController, "JMXServiceImpl");
        MBeanServer mBeanServer = ((JMXService)component2.getFcInterface("service")).getLocalJMXServer();
        return mBeanServer;
    }

    public static final void registerMBeans(Component component) throws Exception {
        ContentController contentController = Fractal.getContentController((Component)component);
        Introspector.CURRENCY_TIME_LIMIT = "-1";
        MBeanServer mBeanServer = MBeanHelper.findLocalJMXServer(component);
        MBeanHelper.registerComponent(contentController, "AdminServiceImpl", mBeanServer, AdminServiceMBean.class, "Petals:name=Admin,type=service");
        MBeanHelper.registerComponent(contentController, "DeploymentServiceImpl", mBeanServer, DeploymentServiceMBean.class, "Petals:name=Deployment,type=service");
        MBeanHelper.registerComponent(contentController, "InstallationServiceImpl", mBeanServer, InstallationServiceMBean.class, "Petals:name=Installation,type=service");
        MBeanHelper.registerComponent(contentController, "EndpointRegistryImpl", mBeanServer, EndpointRegistryMBean.class, "Petals:name=EndpointRegistry,type=service");
        MBeanHelper.registerComponent(contentController, "PetalsAdminServiceImpl", mBeanServer, PetalsAdminServiceMBean.class, "Petals:name=PetalsAdmin,type=service");
        mBeanServer.registerMBean(Introspector.createMBean((Object)new MonologFactoryMBeanImpl()), new ObjectName("Petals:name=Logger,type=service"));
    }

    public static final ObjectName retrieveServiceMBean(String string, MBeanServer mBeanServer) throws MalformedObjectNameException {
        ObjectName objectName = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("name", string);
        hashtable.put("type", "service");
        ObjectName objectName2 = new ObjectName(DOMAIN, hashtable);
        Set<ObjectName> set = mBeanServer.queryNames(objectName2, null);
        if (set != null && set.size() == 1) {
            objectName = set.iterator().next();
        }
        return objectName;
    }

    public static final void registerComponent(ContentController contentController, String string, MBeanServer mBeanServer, Class clazz, String string2) throws Exception {
        Component component = FractalHelper.getRecursiveComponentByName(contentController, string);
        Object object = component.getFcInterface("/content");
        mBeanServer.registerMBean(MBeanHelper.createCustomMBean(object, clazz), new ObjectName(string2));
    }

    public static final RequiredModelMBean createCustomMBean(Object object, Class<?> clazz) throws InstanceNotFoundException, MBeanException, RuntimeOperationsException, InvalidTargetObjectTypeException {
        Cloneable cloneable;
        Object object2;
        Method[] methodArray = clazz.getMethods();
        Vector<DescriptorSupport> vector = new Vector<DescriptorSupport>();
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().startsWith("get") || methodArray[n].getName().startsWith("set") || methodArray[n].getName().startsWith("is")) {
                object2 = methodArray[n].getName().startsWith("is") ? methodArray[n].getName().substring(2) : methodArray[n].getName().substring(3);
                object2 = ((String)object2).substring(0, 1).toLowerCase().concat(((String)object2).substring(1));
                try {
                    try {
                        object.getClass().getDeclaredField((String)object2);
                        cloneable = MBeanHelper.doAttribute(methodArray, n);
                        if (cloneable != null) {
                            vector.add((DescriptorSupport)cloneable);
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        cloneable = MBeanHelper.doOperation(methodArray, n, true);
                        if (cloneable != null) {
                            vector2.add(cloneable);
                        }
                    }
                }
                catch (Exception exception) {}
            } else {
                try {
                    object2 = MBeanHelper.doOperation(methodArray, n, false);
                    if (object2 != null) {
                        vector2.add(object2);
                    }
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        Object[] objectArray = new ModelMBeanAttributeInfo[vector.size()];
        vector.copyInto(objectArray);
        object2 = new ModelMBeanOperationInfo[vector2.size()];
        vector2.copyInto((Object[])object2);
        cloneable = new DescriptorSupport();
        cloneable.setField("name", object.getClass().getName());
        cloneable.setField("descriptorType", "MBean");
        ModelMBeanInfoSupport modelMBeanInfoSupport = new ModelMBeanInfoSupport(object.getClass().getName(), object.getClass().getName(), (ModelMBeanAttributeInfo[])objectArray, new ModelMBeanConstructorInfo[0], (ModelMBeanOperationInfo[])object2, new ModelMBeanNotificationInfo[0], (Descriptor)cloneable);
        RequiredModelMBean requiredModelMBean = new RequiredModelMBean(modelMBeanInfoSupport);
        requiredModelMBean.setManagedResource(object, "ObjectReference");
        return requiredModelMBean;
    }

    private static ModelMBeanAttributeInfo doAttribute(Method[] methodArray, int n) throws JMException {
        int n2;
        Object object;
        String string = null;
        Method method = null;
        Method method2 = null;
        String string2 = null;
        if (methodArray[n].getName().startsWith("get") && methodArray[n].getParameterTypes().length == 0) {
            object = "s" + methodArray[n].getName().substring(1);
            string = methodArray[n].getName().substring(3);
            method = methodArray[n];
            string2 = methodArray[n].getReturnType().getName();
            n2 = 0;
            while (n2 < methodArray.length) {
                if (methodArray[n2].getName().equals(object)) {
                    method2 = methodArray[n2];
                    break;
                }
                ++n2;
            }
        } else if (methodArray[n].getName().startsWith("set") && methodArray[n].getParameterTypes().length == 1) {
            object = "g" + methodArray[n].getName().substring(1);
            string = methodArray[n].getName().substring(3);
            n2 = 0;
            while (n2 < methodArray.length) {
                if (methodArray[n2].getName().equals(object)) {
                    return null;
                }
                ++n2;
            }
            method2 = methodArray[n];
            string2 = methodArray[n].getParameterTypes()[0].getName();
        } else if (methodArray[n].getName().startsWith("is") && methodArray[n].getParameterTypes() == null) {
            string = methodArray[n].getName().substring(2);
            method = methodArray[n];
            string2 = Boolean.TYPE.getName();
        } else {
            return null;
        }
        object = new DescriptorSupport();
        object.setField("name", string);
        object.setField("descriptorType", "attribute");
        object.setField("displayName", string);
        object.setField("currencyTimeLimit", CURRENCY_TIME_LIMIT);
        if (method != null) {
            object.setField("getMethod", method.getName());
        }
        if (method2 != null) {
            object.setField("setMethod", method2.getName());
        }
        ModelMBeanAttributeInfo modelMBeanAttributeInfo = new ModelMBeanAttributeInfo(string, string2, string, method != null, method2 != null, false, (Descriptor)object);
        return modelMBeanAttributeInfo;
    }

    private static ModelMBeanOperationInfo doOperation(Method[] methodArray, int n, boolean bl) throws JMException {
        DescriptorSupport descriptorSupport = new DescriptorSupport();
        descriptorSupport.setField("name", methodArray[n].getName());
        descriptorSupport.setField("descriptorType", "operation");
        descriptorSupport.setField("currencyTimeLimit", CURRENCY_TIME_LIMIT);
        if (bl) {
            if ((methodArray[n].getName().startsWith("get") || methodArray[n].getName().startsWith("is")) && methodArray[n].getParameterTypes().length == 0) {
                descriptorSupport.setField("role", "getter");
            } else if (methodArray[n].getName().startsWith("set") && methodArray[n].getParameterTypes().length == 1) {
                descriptorSupport.setField("role", "setter");
            }
        } else {
            descriptorSupport.setField("role", "operation");
        }
        ModelMBeanOperationInfo modelMBeanOperationInfo = new ModelMBeanOperationInfo(methodArray[n].getName(), methodArray[n], (Descriptor)descriptorSupport);
        return modelMBeanOperationInfo;
    }
}

