/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.server;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.monolog.Monolog;
import org.ow2.petals.communication.jndi.client.JNDIService;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.recovery.SystemRecoveryService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.kernel.admin.PetalsAdminInterface;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.api.server.PetalsServer;
import org.ow2.petals.kernel.api.server.PetalsStateListener;
import org.ow2.petals.kernel.api.server.util.SystemUtil;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.kernel.server.FractalHelper;
import org.ow2.petals.kernel.server.MBeanHelper;
import org.ow2.petals.kernel.server.PetalsStopThread;
import org.ow2.petals.service.ServiceEndpointImpl;
import org.ow2.petals.tools.ws.WebServiceException;
import org.ow2.petals.tools.ws.WebServiceManager;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.util.JNDIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetalsServerImpl
implements PetalsServer {
    private static final String LOGGER_PROPERTIES_FILE_NAME = "loggers.properties";
    private static final String[] MONOLOG_FILE_HANDLERS = new String[]{"petalsFile"};
    private final List<PetalsStateListener> petalsListeners;
    private final PetalsStopThread petalsStopThread = new PetalsStopThread(this);
    private DomainConfiguration domainConfiguration;
    private ContainerConfiguration containerConfiguration;
    private Component petalsComposite;
    private ContentController petalsContentController;
    private EndpointRegistry registry;

    public PetalsServerImpl() throws PetalsException {
        this(false);
    }

    public PetalsServerImpl(boolean bl) throws PetalsException {
        this.petalsListeners = new Vector<PetalsStateListener>();
    }

    @Override
    public void init() throws PetalsException {
        System.setProperty("javax.management.builder.initial", "mx4j.server.MX4JMBeanServerBuilder");
        try {
            this.initializeMonolog();
            this.initializePetalsComposite();
        }
        catch (IOException iOException) {
            throw new PetalsException("Problem while initializing Petals", iOException);
        }
    }

    @Override
    public void start() throws PetalsException {
        try {
            this.startPetalsComposite();
            this.registerPetalsServer();
            MBeanHelper.registerMBeans(this.petalsComposite);
            this.startTools();
            this.recoverSystem();
            this.startupDone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (this.petalsComposite != null) {
                System.err.println("Problem while starting PEtALS, try to stop PEtALS cleanly...");
                try {
                    FractalHelper.stopComponent(this.petalsComposite);
                }
                catch (Throwable throwable) {
                    System.err.println("Failed to stop PEtALS cleanly");
                }
            }
            throw new PetalsException("Failed to start PEtALS", exception);
        }
        for (PetalsStateListener petalsStateListener : this.petalsListeners) {
            petalsStateListener.onPetalsStarted();
        }
    }

    @Override
    public void stop() throws PetalsException {
        Exception exception = null;
        try {
            this.stopPetalsComposite();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        for (PetalsStateListener petalsStateListener : this.petalsListeners) {
            if (exception == null) {
                petalsStateListener.onPetalsStopped(true, null);
                continue;
            }
            petalsStateListener.onPetalsStopped(false, exception);
        }
        if (exception != null) {
            if (exception instanceof PetalsException) {
                throw (PetalsException)exception;
            }
            throw new PetalsException(exception);
        }
    }

    @Override
    public void addPetalsStateListener(PetalsStateListener petalsStateListener) {
        this.petalsListeners.add(petalsStateListener);
    }

    @Override
    public boolean removePetalsStateListener(PetalsStateListener petalsStateListener) {
        return this.petalsListeners.remove(petalsStateListener);
    }

    @Override
    public String getContainerConfiguration() throws PetalsException {
        if (this.containerConfiguration == null) {
            throw new PetalsException("The container configuration is not properly set");
        }
        return this.containerConfiguration.toString();
    }

    @Override
    public String browseJNDI() throws PetalsException {
        if (this.containerConfiguration == null) {
            throw new PetalsException("The container configuration is not properly set");
        }
        String string = null;
        Component component = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "JNDIServiceImpl");
        try {
            JNDIService jNDIService = (JNDIService)component.getFcInterface("service");
            InitialContext initialContext = jNDIService.getInitialContext();
            if (this.domainConfiguration.getJndiConfiguration() == null) {
                string = JNDIUtil.browseJNDI(initialContext, null, 0);
            } else {
                URI uRI = this.domainConfiguration.getJndiConfiguration().getJndiProviderUrl();
                string = JNDIUtil.browseJNDI(initialContext, uRI.getHost(), uRI.getPort());
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException(noSuchInterfaceException);
        }
        catch (NamingException namingException) {
            throw new PetalsException(namingException);
        }
        return string;
    }

    @Override
    public List<org.ow2.petals.kernel.api.service.ServiceEndpoint> getServiceEndpoints(boolean bl) throws PetalsException {
        ArrayList<org.ow2.petals.kernel.api.service.ServiceEndpoint> arrayList = new ArrayList<org.ow2.petals.kernel.api.service.ServiceEndpoint>();
        try {
            List<ServiceEndpoint> list = this.registry.getEndpoints();
            if (list != null) {
                for (org.ow2.petals.kernel.api.service.ServiceEndpoint serviceEndpoint : list) {
                    ServiceEndpointImpl serviceEndpointImpl = new ServiceEndpointImpl();
                    serviceEndpointImpl.setInterfacesName(serviceEndpoint.getInterfacesName());
                    serviceEndpointImpl.setEndpointName(serviceEndpoint.getEndpointName());
                    serviceEndpointImpl.setServiceName(serviceEndpoint.getServiceName());
                    serviceEndpointImpl.setDescription(serviceEndpoint.getDescription());
                    serviceEndpointImpl.setLocation(serviceEndpoint.getLocation());
                    arrayList.add(serviceEndpointImpl);
                }
            }
        }
        catch (RegistryException registryException) {
            throw new PetalsException("Can not get endpoints");
        }
        return arrayList;
    }

    private void initializePetalsComposite() throws PetalsException {
        try {
            this.petalsComposite = FractalHelper.createNewComponent("Petals");
            this.petalsContentController = Fractal.getContentController((Component)this.petalsComposite);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException("Error creating PEtALS Fractal Composite", noSuchInterfaceException);
        }
        catch (ADLException aDLException) {
            throw new PetalsException("Error creating PEtALS Fractal Composite", aDLException);
        }
    }

    private void initializeMonolog() throws IOException {
        URL uRL = this.getClass().getResource("/loggers.properties");
        if (uRL == null) {
            throw new IOException("Failed to reach Monolog resource 'loggers.properties'");
        }
        Properties properties = new Properties();
        properties.load(uRL.openStream());
        this.configureMonologHandlers(properties);
        Monolog.getMonologFactory(properties);
    }

    private void configureMonologHandlers(Properties properties) {
        File file = new File(SystemUtil.getPetalsInstallDirectory(), "logs");
        file.mkdirs();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = simpleDateFormat.format(date);
        String[] stringArray = MONOLOG_FILE_HANDLERS;
        int n = MONOLOG_FILE_HANDLERS.length;
        int n2 = 0;
        while (n2 < n) {
            String string2;
            String string3 = stringArray[n2];
            String string4 = properties.getProperty("handler." + string3 + ".output");
            if (string4 != null) {
                string4 = string4.replace("%d", string);
                properties.setProperty("handler." + string3 + ".output", new File(file, string4).getAbsolutePath());
            }
            if ("true".equals(string2 = properties.getProperty("handler." + string3 + ".appendMode")) || "false".equals(string2)) {
                System.setProperty(string2, string2);
            }
            ++n2;
        }
    }

    private void startPetalsComposite() throws ADLException, NoSuchInterfaceException, IllegalBindingException, IllegalContentException, IllegalLifeCycleException, PetalsException {
        BindingController bindingController;
        Component component;
        Component component2 = FractalHelper.getComponentByName(this.petalsContentController, "ConfigurationServiceImpl");
        if (!FractalHelper.startComponent(component2)) {
            throw new PetalsException("Failed to start PEtALS Fractal component ConfigurationServiceImpl");
        }
        ConfigurationService configurationService = (ConfigurationService)component2.getFcInterface("service");
        this.containerConfiguration = configurationService.getContainerConfiguration();
        this.domainConfiguration = configurationService.getDomainConfiguration();
        if (!this.containerConfiguration.isActivateAutoloader()) {
            component = FractalHelper.getComponentByName(this.petalsContentController, "AutoLoaderServiceImpl");
            bindingController = Fractal.getBindingController((Component)component);
            String[] stringArray = bindingController.listFc();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                bindingController.unbindFc(string);
                ++n2;
            }
            this.petalsContentController.removeFcSubComponent(component);
        }
        if (!FractalHelper.startComponent(component = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "Communication"))) {
            throw new PetalsException("Failed to start PEtALS Fractal composite Communication");
        }
        if (!FractalHelper.startComponent(this.petalsComposite)) {
            throw new PetalsException("Failed to start PEtALS Fractal components");
        }
        bindingController = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "EndpointRegistryImpl");
        if (bindingController == null) {
            throw new PetalsException("Can not find the registry component EndpointRegistryImpl");
        }
        this.registry = (EndpointRegistry)bindingController.getFcInterface("service");
    }

    private void stopPetalsComposite() throws Exception {
        LifeCycleController lifeCycleController = Fractal.getLifeCycleController((Component)this.petalsComposite);
        if ("STARTED".equals(lifeCycleController.getFcState())) {
            Object object;
            Component component4;
            Component component22;
            Component component3 = FractalHelper.getComponentByName(this.petalsContentController, "Container");
            ContentController contentController = Fractal.getContentController((Component)component3);
            List<Component> list = FractalHelper.getComponentListByPrefix(contentController, "ServiceAssemblyLifeCycle.");
            Collections.reverse(list);
            for (Component component22 : list) {
                FractalHelper.stopComponent(component22);
            }
            component22 = FractalHelper.getComponentListByPrefix(contentController, "ComponentLifeCycle.");
            Collections.reverse(component22);
            for (Component component4 : component22) {
                FractalHelper.stopComponent(component4);
            }
            if (DomainConfiguration.DomainMode.STANDALONE.equals((Object)this.domainConfiguration.getMode())) {
                component4 = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "StandaloneTransporter");
                object = (Transporter)component4.getFcInterface("service");
                object.stopTraffic();
            } else {
                component4 = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "TcpTransporter");
                object = (Transporter)component4.getFcInterface("service");
                object.stopTraffic();
                Component component5 = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "LocalTransporter");
                Transporter transporter = (Transporter)component5.getFcInterface("service");
                transporter.stopTraffic();
            }
            component4 = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "RouterServiceImpl");
            object = (RouterService)component4.getFcInterface("service");
            object.stopTraffic();
            FractalHelper.stopComposite(this.petalsComposite);
        }
    }

    private void registerPetalsServer() throws NoSuchInterfaceException, PetalsException {
        Component component = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "PetalsAdminServiceImpl");
        PetalsAdminInterface petalsAdminInterface = (PetalsAdminInterface)component.getFcInterface("service");
        petalsAdminInterface.setPetalsStopThread(this.petalsStopThread);
    }

    private void recoverSystem() throws ADLException, NoSuchInterfaceException, IllegalBindingException, IllegalContentException, IllegalLifeCycleException, ManagementException, PetalsException {
        Component component = FractalHelper.getComponentByName(this.petalsContentController, "JBI-Management");
        ContentController contentController = Fractal.getContentController((Component)component);
        Component component2 = FractalHelper.getComponentByName(contentController, "SystemRecoveryServiceImpl");
        SystemRecoveryService systemRecoveryService = (SystemRecoveryService)component2.getFcInterface("service");
        systemRecoveryService.recoverAllEntities();
        FractalHelper.stopComponent(component2);
        BindingController bindingController = Fractal.getBindingController((Component)component2);
        String[] stringArray = bindingController.listFc();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            bindingController.unbindFc(string);
            ++n2;
        }
        contentController.removeFcSubComponent(component2);
    }

    private void startupDone() throws Exception {
        Component component = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "TopologyServiceImpl");
        if (component == null) {
            if (!DomainConfiguration.DomainMode.STANDALONE.equals((Object)this.domainConfiguration.getMode())) {
                throw new NullPointerException("The topology fractal component is null");
            }
        } else {
            TopologyService topologyService = (TopologyService)component.getFcInterface("service");
            topologyService.setContainerState(this.containerConfiguration.getName(), ContainerConfiguration.ContainerState.STARTED);
        }
    }

    private void startTools() throws NoSuchInterfaceException, PetalsException {
        Component component = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "WebServiceManagerImpl");
        if (component != null) {
            WebServiceManager webServiceManager = (WebServiceManager)component.getFcInterface("service");
            try {
                webServiceManager.exposeServices();
            }
            catch (WebServiceException webServiceException) {
                throw new PetalsException("Fail to expose services : " + webServiceException.getMessage());
            }
        }
    }

    @Override
    public void synchronizeRegistry() throws PetalsException {
        try {
            this.registry.synchronizeData();
        }
        catch (RegistryException registryException) {
            throw new PetalsException("Fail to synchronize registry : " + registryException.getMessage());
        }
    }
}

