/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.repository;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.system.repository.RepositoryFileFilter;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.ZipUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RepositoryService.class)})
public class RepositoryServiceImpl
implements BindingController,
LifeCycleController,
RepositoryService {
    private LoggerFactory loggerFactory;
    private static final String COMPONENTS_PATH = "components";
    private static final String DATE_PATTERN = "MM-dd-yyyy-hhmmssSSS";
    private static final String INSTALL_PATH = "install";
    private static final String LOSTPLUSFOUND_PATH = "lost+found";
    private static final String SERVICEASSEMBLIES_PATH = "service-assemblies";
    private static final String SHAREDLIBRARIES_PATH = "shared-libraries";
    private static final String WORK_PATH = "work";
    protected LoggingUtil log;
    protected Logger logger;
    private File componentsDirectory;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private ContainerConfiguration containerConfiguration;
    private SimpleDateFormat folderDateFormat;
    private File lostFoundDirectory;
    private File repositoryDirectory;
    private File serviceAssembliesDirectory;
    private File sharedLibrariesDirectory;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public File addComponent(String string, File file) throws IOException {
        return this.addPackage(string, file, EntityType.COMPONENT_TYPE);
    }

    public File addServiceAssembly(String string, File file) throws IOException {
        return this.addPackage(string, file, EntityType.SA_TYPE);
    }

    public File addSharedLibrary(String string, File file) throws IOException {
        return this.addPackage(string, file, EntityType.SL_TYPE);
    }

    public File explodeSUIntoSAInstallDirectory(String string, URL uRL, String string2) throws IOException {
        File file = this.createSUInstallDirectory(string, string2);
        try {
            File file2 = new File(uRL.getPath());
            ZipUtil.unzipArchive(file2, file);
        }
        catch (IOException iOException) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException iOException2) {
                this.log.warning("Failed to clean a failed installation", iOException);
            }
            throw iOException;
        }
        return file;
    }

    public File getComponentDirectory(String string) throws IOException {
        return this.getEntityRoot(string, EntityType.COMPONENT_TYPE);
    }

    public File getComponentInstallDirectory(String string) throws IOException {
        return new File(this.getComponentDirectory(string), INSTALL_PATH);
    }

    public File getComponentsDirectory() {
        return this.componentsDirectory;
    }

    public File getComponentWorkDirectory(String string) throws IOException {
        return new File(this.getComponentDirectory(string), WORK_PATH);
    }

    public File getLostPlusFoundDirectory() {
        return this.lostFoundDirectory;
    }

    public File getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    public File getServiceAssembliesDirectory() {
        return this.serviceAssembliesDirectory;
    }

    public File getServiceAssemblyDirectory(String string) throws IOException {
        return this.getEntityRoot(string, EntityType.SA_TYPE);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public File getServiceAssemblyInstallDirectory(String string) throws IOException {
        return new File(this.getServiceAssemblyDirectory(string), INSTALL_PATH);
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public File getServiceAssemblyWorkDirectory(String string) throws IOException {
        return new File(this.getServiceAssemblyDirectory(string), WORK_PATH);
    }

    public File getSharedLibrariesDirectory() {
        return this.sharedLibrariesDirectory;
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public File getSharedLibraryDirectory(String string) throws IOException {
        return this.getEntityRoot(string, EntityType.SL_TYPE);
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public File getSharedLibraryInstallDirectory(String string) throws IOException {
        String string2 = INSTALL_PATH;
        return new File(this.getSharedLibraryDirectory(string), string2);
    }

    public File getSharedLibraryWorkDirectory(String string) throws IOException {
        return new File(this.getSharedLibraryDirectory(string), WORK_PATH);
    }

    public void removeComponent(String string) throws IOException {
        this.removePackage(string, EntityType.COMPONENT_TYPE);
    }

    public void removeServiceAssembly(String string) throws IOException {
        this.removePackage(string, EntityType.SA_TYPE);
    }

    public void removeSharedLibrary(String string) throws IOException {
        this.removePackage(string, EntityType.SL_TYPE);
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IOException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.folderDateFormat = new SimpleDateFormat(DATE_PATTERN);
        this.containerConfiguration = this.configurationService.getContainerConfiguration();
        this.repositoryDirectory = new File(this.containerConfiguration.getRepositoryDirectoryPath());
        try {
            if (!this.repositoryDirectory.exists() && !this.repositoryDirectory.mkdir()) {
                throw new IOException("Directory '" + this.repositoryDirectory.getAbsolutePath() + "' can not be create");
            }
            this.lostFoundDirectory = new File(this.repositoryDirectory, LOSTPLUSFOUND_PATH);
            if (!this.lostFoundDirectory.exists()) {
                this.lostFoundDirectory.mkdir();
            }
            this.componentsDirectory = new File(this.repositoryDirectory, COMPONENTS_PATH);
            if (!this.componentsDirectory.exists()) {
                this.componentsDirectory.mkdir();
            }
            this.serviceAssembliesDirectory = new File(this.repositoryDirectory, SERVICEASSEMBLIES_PATH);
            if (!this.serviceAssembliesDirectory.exists()) {
                this.serviceAssembliesDirectory.mkdir();
            }
            this.sharedLibrariesDirectory = new File(this.repositoryDirectory, SHAREDLIBRARIES_PATH);
            if (!this.sharedLibrariesDirectory.exists()) {
                this.sharedLibrariesDirectory.mkdir();
            }
        }
        catch (SecurityException securityException) {
            this.log.error(securityException);
            throw securityException;
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
    }

    private File addPackage(String string, File file, EntityType entityType) throws IOException {
        File file2 = this.createEntityDirectory(string, entityType);
        File file3 = this.createEntityInstallDirectory(file2);
        File file4 = this.createEntityWorkDirectory(file2);
        try {
            FileUtils.copyDirectory((File)file, (File)file3);
            FileUtils.forceDelete((File)file);
        }
        catch (IOException iOException) {
            try {
                FileUtils.forceDelete((File)file2);
                FileUtils.forceDelete((File)file4);
            }
            catch (IOException iOException2) {
                this.log.warning("Residual incomplete component directory");
            }
            throw iOException;
        }
        return file3;
    }

    private File createComponentDirectory(String string) {
        String string2 = String.valueOf(string) + "-" + this.folderDateFormat.format(new Date(System.currentTimeMillis()));
        File file = new File(this.componentsDirectory, string2);
        file.mkdir();
        return file;
    }

    private File createEntityDirectory(String string, EntityType entityType) throws IOException {
        File file = null;
        switch (entityType) {
            case COMPONENT_TYPE: {
                file = this.createComponentDirectory(string);
                break;
            }
            case SA_TYPE: {
                file = this.createServiceAssemblyDirectory(string);
                break;
            }
            case SL_TYPE: {
                file = this.createSharedLibraryDirectory(string);
            }
        }
        return file;
    }

    private File createEntityInstallDirectory(File file) {
        File file2 = new File(file, INSTALL_PATH);
        file2.mkdir();
        return file2;
    }

    private File createEntityWorkDirectory(File file) {
        File file2 = new File(file, WORK_PATH);
        file2.mkdir();
        return file2;
    }

    private File createServiceAssemblyDirectory(String string) {
        String string2 = String.valueOf(string) + "-" + this.folderDateFormat.format(new Date(System.currentTimeMillis()));
        File file = new File(this.serviceAssembliesDirectory, string2);
        file.mkdir();
        return file;
    }

    private File createSharedLibraryDirectory(String string) {
        String string2 = String.valueOf(string) + "-" + this.folderDateFormat.format(new Date(System.currentTimeMillis()));
        File file = new File(this.sharedLibrariesDirectory, string2);
        file.mkdir();
        return file;
    }

    private File createSUInstallDirectory(String string, String string2) throws IOException {
        File file = new File(this.getServiceAssemblyInstallDirectory(string2), string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private File getEntityRoot(String string, EntityType entityType) throws IOException {
        File file = null;
        switch (entityType) {
            case COMPONENT_TYPE: {
                file = this.getComponentsDirectory();
                break;
            }
            case SA_TYPE: {
                file = this.getServiceAssembliesDirectory();
                break;
            }
            case SL_TYPE: {
                file = this.getSharedLibrariesDirectory();
            }
        }
        String[] stringArray = file.list(new RepositoryFileFilter(string));
        String string2 = "";
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            if (string2.compareTo(string3) < 0) {
                string2 = string3;
            }
            ++n2;
        }
        return new File(file, stringArray[0]);
    }

    private void removePackage(String string, EntityType entityType) throws IOException {
        File file = null;
        switch (entityType) {
            case COMPONENT_TYPE: {
                file = this.getComponentDirectory(string);
                break;
            }
            case SA_TYPE: {
                file = this.getServiceAssemblyDirectory(string);
                break;
            }
            case SL_TYPE: {
                file = this.getSharedLibraryDirectory(string);
            }
        }
        if (file != null) {
            FileUtils.deleteDirectory((File)file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntityType {
        COMPONENT_TYPE,
        SA_TYPE,
        SL_TYPE;

    }
}

