/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.systemstate;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.systemstate.SystemStateBuilder;
import org.ow2.petals.systemstate.SystemStateException;
import org.ow2.petals.systemstate.generated.Component;
import org.ow2.petals.systemstate.generated.ObjectFactory;
import org.ow2.petals.systemstate.generated.ServiceAssembly;
import org.ow2.petals.systemstate.generated.SharedLibrary;
import org.ow2.petals.systemstate.generated.SystemState;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SystemStateService.class)})
public class SystemStateServiceImpl
implements BindingController,
LifeCycleController,
SystemStateService {
    private LoggerFactory loggerFactory;
    private static final String SYSTEMSTATE_FILE = "system-state.xml";
    private LoggingUtil log;
    private Logger logger;
    private ObjectFactory objectFactory;
    @Requires(name="repository", signature=RepositoryService.class)
    private RepositoryService repositoryService;
    private SystemState systemState;
    private File systemStateFile;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component createComponentStateHolder(String string, URL uRL, String string2) throws SystemStateException {
        Component component = this.objectFactory.createComponent();
        component.setName(string);
        component.setInstallURL(uRL.toExternalForm());
        component.setInstallState("Uninstalled");
        component.setArchiveName(string2);
        component.setLifecycleState("Unknown");
        SystemState systemState = this.systemState;
        synchronized (systemState) {
            this.systemState.getComponents().getComponent().add(component);
            SystemStateBuilder.buildXmlFileSystemState((SystemState)this.systemState, (File)this.systemStateFile);
        }
        return component;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceAssembly createServiceAssemblyStateHolder(String string, URL uRL, String string2) throws SystemStateException {
        ServiceAssembly serviceAssembly = this.objectFactory.createServiceAssembly();
        serviceAssembly.setName(string);
        serviceAssembly.setInstallURL(uRL.toExternalForm());
        serviceAssembly.setArchiveName(string2);
        serviceAssembly.setLifecycleState("Unknown");
        SystemState systemState = this.systemState;
        synchronized (systemState) {
            this.systemState.getServiceAssemblies().getServiceAssembly().add(serviceAssembly);
            SystemStateBuilder.buildXmlFileSystemState((SystemState)this.systemState, (File)this.systemStateFile);
        }
        return serviceAssembly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedLibrary createSharedLibraryStateHolder(String string, String string2, URL uRL, String string3) throws SystemStateException {
        SharedLibrary sharedLibrary = this.objectFactory.createSharedLibrary();
        sharedLibrary.setName(string);
        sharedLibrary.setVersion(string2);
        sharedLibrary.setInstallURL(uRL.toExternalForm());
        sharedLibrary.setArchiveName(string3);
        SystemState systemState = this.systemState;
        synchronized (systemState) {
            this.systemState.getSharedLibraries().getSharedLibrary().add(sharedLibrary);
            SystemStateBuilder.buildXmlFileSystemState((SystemState)this.systemState, (File)this.systemStateFile);
        }
        return sharedLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component deleteComponentStateHolder(String string) throws SystemStateException {
        Component component = null;
        for (Component component2 : this.systemState.getComponents().getComponent()) {
            if (!string.equals(component2.getName())) continue;
            component = component2;
            break;
        }
        if (component != null) {
            Component component2;
            component2 = this.systemState;
            synchronized (component2) {
                this.systemState.getComponents().getComponent().remove(component);
                SystemStateBuilder.buildXmlFileSystemState((SystemState)this.systemState, (File)this.systemStateFile);
            }
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceAssembly deleteServiceAssemblyStateHolder(String string) throws SystemStateException {
        ServiceAssembly serviceAssembly = null;
        for (ServiceAssembly serviceAssembly2 : this.systemState.getServiceAssemblies().getServiceAssembly()) {
            if (!string.equals(serviceAssembly2.getName())) continue;
            serviceAssembly = serviceAssembly2;
            break;
        }
        if (serviceAssembly != null) {
            ServiceAssembly serviceAssembly2;
            serviceAssembly2 = this.systemState;
            synchronized (serviceAssembly2) {
                this.systemState.getServiceAssemblies().getServiceAssembly().remove(serviceAssembly);
                SystemStateBuilder.buildXmlFileSystemState((SystemState)this.systemState, (File)this.systemStateFile);
            }
        }
        return serviceAssembly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedLibrary deleteSharedLibraryStateHolder(String string, String string2) throws SystemStateException {
        SharedLibrary sharedLibrary = null;
        for (SharedLibrary sharedLibrary2 : this.systemState.getSharedLibraries().getSharedLibrary()) {
            if (!string.equals(sharedLibrary2.getName()) || !string2.equals(sharedLibrary2.getVersion())) continue;
            sharedLibrary = sharedLibrary2;
            break;
        }
        if (sharedLibrary != null) {
            SharedLibrary sharedLibrary2;
            sharedLibrary2 = this.systemState;
            synchronized (sharedLibrary2) {
                this.systemState.getSharedLibraries().getSharedLibrary().remove(sharedLibrary);
                SystemStateBuilder.buildXmlFileSystemState((SystemState)this.systemState, (File)this.systemStateFile);
            }
        }
        return sharedLibrary;
    }

    @Override
    public Component getComponentStateHolder(String string) {
        for (Component component : this.systemState.getComponents().getComponent()) {
            if (!string.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    @Override
    public List<Component> getComponentStateHolders() {
        return new ArrayList<Component>(this.systemState.getComponents().getComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceAssembly getServiceAssemblyStateHolder(String string) {
        SystemState systemState = this.systemState;
        synchronized (systemState) {
            for (ServiceAssembly serviceAssembly : this.systemState.getServiceAssemblies().getServiceAssembly()) {
                if (!string.equals(serviceAssembly.getName())) continue;
                return serviceAssembly;
            }
        }
        return null;
    }

    @Override
    public List<ServiceAssembly> getServiceAssemblyStateHolders() {
        return new ArrayList<ServiceAssembly>(this.systemState.getServiceAssemblies().getServiceAssembly());
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("repository")) {
            if (!RepositoryService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RepositoryService.class.getName());
            }
            this.repositoryService = (RepositoryService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedLibrary getSharedLibraryStateHolder(String string, String string2) {
        SystemState systemState = this.systemState;
        synchronized (systemState) {
            for (SharedLibrary sharedLibrary : this.systemState.getSharedLibraries().getSharedLibrary()) {
                if (!string.equals(sharedLibrary.getName()) || !string2.equals(sharedLibrary.getVersion())) continue;
                return sharedLibrary;
            }
        }
        return null;
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("repository");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("repository")) {
            return this.repositoryService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public List<SharedLibrary> getSharedLibraryStateHolders() {
        return new ArrayList<SharedLibrary>(this.systemState.getSharedLibraries().getSharedLibrary());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SharedLibrary> getSharedLibraryStateHolders(String string) {
        ArrayList<SharedLibrary> arrayList = new ArrayList<SharedLibrary>();
        SystemState systemState = this.systemState;
        synchronized (systemState) {
            for (SharedLibrary sharedLibrary : this.systemState.getSharedLibraries().getSharedLibrary()) {
                if (!string.equals(sharedLibrary.getName())) continue;
                arrayList.add(sharedLibrary);
            }
        }
        return arrayList;
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("repository")) {
            this.repositoryService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public boolean isComponentInstalled(String string) {
        boolean bl = false;
        Component component = this.getComponentStateHolder(string);
        if ("Installed".equals(component.getInstallState())) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateComponentInstallationState(String string, String string2) throws SystemStateException {
        SystemState systemState = this.systemState;
        synchronized (systemState) {
            for (Component component : this.systemState.getComponents().getComponent()) {
                if (!string.equals(component.getName())) continue;
                component.setInstallState(string2);
                SystemStateBuilder.buildXmlFileSystemState((SystemState)this.systemState, (File)this.systemStateFile);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateComponentLifeCycleState(String string, String string2) throws SystemStateException {
        SystemState systemState = this.systemState;
        synchronized (systemState) {
            for (Component component : this.systemState.getComponents().getComponent()) {
                if (!string.equals(component.getName())) continue;
                component.setLifecycleState(string2);
                SystemStateBuilder.buildXmlFileSystemState((SystemState)this.systemState, (File)this.systemStateFile);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateServiceAssemblyState(String string, String string2) throws SystemStateException {
        SystemState systemState = this.systemState;
        synchronized (systemState) {
            for (ServiceAssembly serviceAssembly : this.systemState.getServiceAssemblies().getServiceAssembly()) {
                if (!string.equals(serviceAssembly.getName())) continue;
                serviceAssembly.setLifecycleState(string2);
                SystemStateBuilder.buildXmlFileSystemState((SystemState)this.systemState, (File)this.systemStateFile);
                break;
            }
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IOException, SystemStateException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.objectFactory = new ObjectFactory();
        File file = this.repositoryService.getRepositoryDirectory();
        if (file.exists()) {
            file.mkdirs();
        }
        try {
            this.systemStateFile = new File(file.getAbsolutePath(), SYSTEMSTATE_FILE);
            if (!this.systemStateFile.exists()) {
                this.systemStateFile.createNewFile();
                this.systemState = this.objectFactory.createSystemState();
                this.systemState.setComponents(this.objectFactory.createComponents());
                this.systemState.setServiceAssemblies(this.objectFactory.createServiceAssemblies());
                this.systemState.setSharedLibraries(this.objectFactory.createSharedLibraries());
                SystemStateBuilder.buildXmlFileSystemState((SystemState)this.systemState, (File)this.systemStateFile);
            } else {
                this.systemState = SystemStateBuilder.createSystemState((File)this.systemStateFile);
            }
        }
        catch (SystemStateException systemStateException) {
            this.log.error("Failed to start System State Service", systemStateException);
            throw systemStateException;
        }
        catch (IOException iOException) {
            this.log.error("Failed to start System State Service", iOException);
            throw iOException;
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
    }
}

