/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.local;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.jbi.messaging.MessagingException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.transport.TransportException;
import org.ow2.petals.transport.TransportListener;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.transport.util.TransporterUtil;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=Transporter.class)})
public class LocalTransporterImpl
implements BindingController,
LifeCycleController,
Transporter {
    private LoggerFactory loggerFactory;
    private static final int QUEUE_SIZE = 10000;
    private Logger logger;
    @Requires(name="transportlistener", signature=TransportListener.class)
    private TransportListener transportListener;
    private LoggingUtil log;
    private List<MessageExchange> pendingSyncExchanges;
    private boolean stopTraffic;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTraffic() {
        this.log.start();
        this.stopTraffic = true;
        boolean bl = true;
        while (bl) {
            try {
                Iterator<MessageExchange> iterator = this.pendingSyncExchanges.iterator();
                while (iterator.hasNext()) {
                    MessageExchange messageExchange;
                    MessageExchange messageExchange2 = messageExchange = iterator.next();
                    synchronized (messageExchange2) {
                        messageExchange.notify();
                    }
                }
                bl = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.log.end();
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(MessageExchange messageExchange, TransportSendContext transportSendContext) throws TransportException {
        this.log.start();
        this.checkTransporterState();
        if (TransporterUtil.getSyncMode(messageExchange, true)) {
            this.pendingSyncExchanges.remove(messageExchange);
            MessageExchange messageExchange2 = messageExchange;
            synchronized (messageExchange2) {
                messageExchange.notify();
            }
        } else {
            this.transportListener.onExchange(messageExchange);
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageExchange sendSync(MessageExchange messageExchange, TransportSendContext transportSendContext) throws TransportException {
        boolean bl;
        this.log.start();
        this.checkTransporterState();
        try {
            bl = TransporterUtil.setSendSyncProperties(messageExchange);
        }
        catch (MessagingException messagingException) {
            throw new TransportException(messagingException);
        }
        MessageExchange messageExchange2 = messageExchange;
        synchronized (messageExchange2) {
            if (bl) {
                messageExchange.notify();
            } else {
                this.pendingSyncExchanges.add(messageExchange);
            }
            try {
                if (!bl) {
                    this.transportListener.onExchange(messageExchange);
                }
                messageExchange.wait(transportSendContext.timeout);
            }
            catch (InterruptedException interruptedException) {
                throw new TransportException("Failed to receive the response message of a synchronous send", interruptedException);
            }
        }
        if (!TransporterUtil.updateSyncProperties(messageExchange) && this.pendingSyncExchanges.contains(messageExchange)) {
            this.checkTransporterState();
            this.pendingSyncExchanges.remove(messageExchange);
            this.log.warning("Failed to send synchronously the exchange: " + messageExchange.getExchangeId() + ". Timeout occured");
            this.log.end();
            return null;
        }
        this.log.end();
        return messageExchange;
    }

    public int getQueueMaxSize() throws TransportException {
        return 10000;
    }

    public Map<String, Integer> getQueueSizes() throws TransportException {
        return null;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws Exception {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
        this.pendingSyncExchanges = new Vector<MessageExchange>(100);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws Exception {
        this.log.call();
    }

    private void checkTransporterState() throws TransportException {
        if (this.stopTraffic) {
            Thread.currentThread().interrupt();
            throw new TransportException("The Transporter traffic is stopped", new InterruptedException());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("transportlistener")) {
            if (!TransportListener.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TransportListener.class.getName());
            }
            this.transportListener = (TransportListener)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("transportlistener");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("transportlistener")) {
            return this.transportListener;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("transportlistener")) {
            this.transportListener = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

