/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.MessagingException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.transport.TransportException;
import org.ow2.petals.transport.TransportListener;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.transport.platform.nio.client.NioClientObjectPool;
import org.ow2.petals.transport.platform.nio.selector.NioClient;
import org.ow2.petals.transport.platform.nio.server.NioReceiver;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.transport.util.TransporterUtil;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=Transporter.class), @Interface(name="receiver", signature=NioReceiver.class)})
public class NioTransporterImpl
implements BindingController,
LifeCycleController,
Transporter,
NioReceiver {
    private LoggerFactory loggerFactory;
    private Logger logger;
    @Requires(name="transportlistener", signature=TransportListener.class)
    private TransportListener transportListener;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="clientsPool", signature=NioClientObjectPool.class)
    private NioClientObjectPool clientConnections;
    private boolean stopTraffic;
    private Map<String, MessageExchange> pendingSyncExchanges;
    private LoggingUtil log;
    private long sendTimeout;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object object) {
        this.log.start();
        if (object instanceof MessageExchange) {
            MessageExchange messageExchange = (MessageExchange)object;
            if (TransporterUtil.getSyncMode(messageExchange, true)) {
                MessageExchange messageExchange2;
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.log.debug("The message " + messageExchange.getExchangeId() + " is a synchronized response");
                }
                TransporterUtil.updateSyncProperties(messageExchange);
                MessageExchange messageExchange3 = messageExchange2 = this.pendingSyncExchanges.put(messageExchange.getExchangeId(), messageExchange);
                synchronized (messageExchange3) {
                    messageExchange2.notify();
                }
            } else {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.log.debug("The message " + messageExchange.getExchangeId() + " is not a synchronized response");
                }
                this.transportListener.onExchange(messageExchange);
            }
        } else {
            this.log.warning("Unexpected received data. Data are discarded");
        }
        this.log.end();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(MessageExchange messageExchange, TransportSendContext transportSendContext) throws TransportException {
        this.log.start("Send exchange to destination '" + transportSendContext.destination + "'");
        this.checkTransporterState();
        try {
            NioClient nioClient = this.clientConnections.borrowObject(transportSendContext.destination.getContainerName());
            try {
                nioClient.send(messageExchange, this.sendTimeout);
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.clientConnections.returnObject(transportSendContext.destination.getContainerName(), nioClient);
                throw throwable;
            }
            {
                Object var4_9 = null;
                this.clientConnections.returnObject(transportSendContext.destination.getContainerName(), nioClient);
            }
        }
        catch (IOException iOException) {
            throw new TransportException(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new TransportException(interruptedException);
        }
        catch (Exception exception) {
            throw new TransportException(exception);
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageExchange sendSync(MessageExchange messageExchange, TransportSendContext transportSendContext) throws TransportException {
        MessageExchange messageExchange2;
        this.log.start("Send synchronous exchange to destination : " + transportSendContext.destination);
        this.checkTransporterState();
        try {
            TransporterUtil.setSendSyncProperties(messageExchange);
        }
        catch (MessagingException messagingException) {
            throw new TransportException(messagingException);
        }
        this.pendingSyncExchanges.put(messageExchange.getExchangeId(), messageExchange);
        try {
            MessageExchange messageExchange3 = messageExchange;
            synchronized (messageExchange3) {
                this.send(messageExchange, transportSendContext);
                messageExchange.wait(transportSendContext.timeout);
            }
            messageExchange2 = this.pendingSyncExchanges.remove(messageExchange.getExchangeId());
        }
        catch (InterruptedException interruptedException) {
            TransporterUtil.updateSyncProperties(messageExchange);
            this.pendingSyncExchanges.remove(messageExchange);
            throw new TransportException("Failed to receive the response message of a synchronous send", interruptedException);
        }
        if (messageExchange2 == messageExchange) {
            this.checkTransporterState();
            this.log.warning("Failed to send synchronously the exchange: " + messageExchange.getExchangeId() + ". Timeout occured");
            this.log.end();
            return null;
        }
        this.log.end();
        return messageExchange2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTraffic() {
        this.log.start();
        this.stopTraffic = true;
        boolean bl = true;
        while (bl) {
            try {
                Iterator<MessageExchange> iterator = this.pendingSyncExchanges.values().iterator();
                while (iterator.hasNext()) {
                    MessageExchange messageExchange;
                    MessageExchange messageExchange2 = messageExchange = iterator.next();
                    synchronized (messageExchange2) {
                        messageExchange.notify();
                    }
                }
                bl = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.START)
    public void start() throws NoSuchInterfaceException, IllegalLifeCycleException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.sendTimeout = this.configurationService.getContainerConfiguration().getTCPSendTimeout();
        this.pendingSyncExchanges = new ConcurrentHashMap<String, MessageExchange>(100);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() throws Exception {
        this.log.call();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("transportlistener")) {
            if (!TransportListener.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TransportListener.class.getName());
            }
            this.transportListener = (TransportListener)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("clientsPool")) {
            if (!NioClientObjectPool.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + NioClientObjectPool.class.getName());
            }
            this.clientConnections = (NioClientObjectPool)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private void checkTransporterState() throws TransportException {
        if (this.stopTraffic) {
            Thread.currentThread().interrupt();
            throw new TransportException("The Transporter traffic is stopped", new InterruptedException());
        }
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("transportlistener");
        arrayList.add("configuration");
        arrayList.add("clientsPool");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("transportlistener")) {
            return this.transportListener;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("clientsPool")) {
            return this.clientConnections;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("transportlistener")) {
            this.transportListener = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("clientsPool")) {
            this.clientConnections = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

