/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio.client;

import java.util.ArrayList;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.transport.platform.nio.client.NioClientAgentPoolObjectFactory;
import org.ow2.petals.transport.platform.nio.client.NioClientObjectPool;
import org.ow2.petals.transport.platform.nio.selector.NioClient;
import org.ow2.petals.transport.platform.nio.selector.NioSelector;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=NioClientObjectPool.class)})
public class NioClientObjectPoolImpl
implements BindingController,
LifeCycleController,
NioClientObjectPool {
    protected Logger logger;
    private LoggerFactory loggerFactory;
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    @Requires(name="topology", signature=TopologyService.class)
    protected TopologyService topologyService;
    @Requires(name="selector", signature=NioSelector.class)
    protected NioSelector selectorAgent;
    private GenericKeyedObjectPool clientConnections;
    protected LoggingUtil log;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public NioClient borrowObject(String string) throws Exception {
        return (NioClient)this.clientConnections.borrowObject((Object)string);
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void returnObject(String string, NioClient nioClient) throws Exception {
        this.clientConnections.returnObject((Object)string, (Object)nioClient);
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    public void start() throws NoSuchInterfaceException, IllegalLifeCycleException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        config.minIdle = 0;
        config.maxActive = this.configurationService.getContainerConfiguration().getTCPSenders();
        config.testOnBorrow = true;
        config.minEvictableIdleTimeMillis = this.configurationService.getContainerConfiguration().getTCPSenderEvictableDelay();
        config.timeBetweenEvictionRunsMillis = this.configurationService.getContainerConfiguration().getTCPSenderEvictorDelay();
        this.clientConnections = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new NioClientAgentPoolObjectFactory(this.topologyService, this.selectorAgent, this.configurationService.getContainerConfiguration().getTCPConnectionTimeout(), this.logger), config);
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() throws Exception {
        this.log.start();
        this.clientConnections.close();
        this.log.end();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        if (string.equals("selector")) {
            if (!NioSelector.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + NioSelector.class.getName());
            }
            this.selectorAgent = (NioSelector)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("topology");
        arrayList.add("selector");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("topology")) {
            return this.topologyService;
        }
        if (string.equals("selector")) {
            return this.selectorAgent;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        if (string.equals("selector")) {
            this.selectorAgent = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

