/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.transport.platform.nio.selector.InputSocketChannelContext;
import org.ow2.petals.transport.platform.nio.selector.NioSelector;
import org.ow2.petals.transport.platform.nio.selector.NioServer;
import org.ow2.petals.transport.platform.nio.selector.PipedDeserializer;
import org.ow2.petals.transport.platform.nio.server.DeserializerThreadFactory;
import org.ow2.petals.transport.platform.nio.server.NioReceiver;
import org.ow2.petals.transport.platform.nio.server.PipedDeserializerImpl;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=NioServer.class)})
public class NioServerAgent
implements BindingController,
LifeCycleController,
NioServer {
    private LoggerFactory loggerFactory;
    @Requires(name="selector", signature=NioSelector.class)
    protected NioSelector selectorAgent;
    @Requires(name="receiver", signature=NioReceiver.class)
    protected NioReceiver messageReceiver;
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    protected Logger logger;
    private LoggingUtil log;
    private InetSocketAddress serverSocket;
    private ServerSocketChannel serverSocketChannel;
    private final Map<SocketChannel, PipedDeserializer> deserializationTasks = new ConcurrentHashMap<SocketChannel, PipedDeserializer>();
    private ThreadPoolExecutor threadPoolTaskExecutor = null;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    public void start() throws IOException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        int n = this.configurationService.getContainerConfiguration().getTCPPort();
        String string = this.configurationService.getContainerConfiguration().getHost();
        this.log.debug("Starting NIO transporter server on port " + n);
        this.serverSocket = new InetSocketAddress(string, n);
        this.serverSocketChannel = ServerSocketChannel.open();
        int n2 = this.configurationService.getContainerConfiguration().getTCPReceivers();
        this.threadPoolTaskExecutor = new ThreadPoolExecutor(n2, n2, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DeserializerThreadFactory());
        this.serverSocketChannel.socket().bind(this.serverSocket, 100);
        this.serverSocketChannel.configureBlocking(false);
        this.log.info("The NIO transporter server is ready to process request on port " + n);
        this.selectorAgent.register(16, this.serverSocketChannel, this);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() throws Exception {
        this.log.start();
        this.log.debug("Stopping NIO Server agent.");
        this.serverSocketChannel.close();
        this.log.info("The NIO Server agent is stopped.");
        this.threadPoolTaskExecutor.shutdownNow();
        this.log.end();
    }

    public void onConnectionIsAccepted(SocketChannel socketChannel, Selector selector) throws IOException {
        this.log.info("A connection is accepted: " + socketChannel.socket().toString());
        PipedDeserializerImpl pipedDeserializerImpl = new PipedDeserializerImpl(socketChannel, this.messageReceiver, this.logger, this.log);
        this.deserializationTasks.put(socketChannel, pipedDeserializerImpl);
        socketChannel.register(selector, 1, new InputSocketChannelContext(socketChannel, pipedDeserializerImpl, this));
    }

    public void onRead(PipedDeserializer pipedDeserializer) {
        try {
            this.threadPoolTaskExecutor.execute(pipedDeserializer);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.log.error("A message deserialization task has been rejected (" + rejectedExecutionException.getMessage() + ")");
        }
    }

    public void onClose(SocketChannel socketChannel) {
        this.deserializationTasks.remove(socketChannel);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("selector")) {
            if (!NioSelector.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + NioSelector.class.getName());
            }
            this.selectorAgent = (NioSelector)object;
            return;
        }
        if (string.equals("receiver")) {
            if (!NioReceiver.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + NioReceiver.class.getName());
            }
            this.messageReceiver = (NioReceiver)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("selector");
        arrayList.add("receiver");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("selector")) {
            return this.selectorAgent;
        }
        if (string.equals("receiver")) {
            return this.messageReceiver;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("selector")) {
            this.selectorAgent = null;
            return;
        }
        if (string.equals("receiver")) {
            this.messageReceiver = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

