/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio.util.stream.queue;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.ow2.petals.transport.platform.nio.util.stream.queue.QueueOutputStream;

public class QueueInputStream
extends InputStream {
    private final QueueOutputStream llos;
    private int bufferReadPos = 0;

    public QueueInputStream(QueueOutputStream queueOutputStream) {
        this.llos = queueOutputStream;
    }

    public int available() throws IOException {
        int n = 0;
        Iterator iterator = this.llos.bufferList.iterator();
        while (iterator.hasNext()) {
            n += ((byte[])iterator.next()).length;
        }
        return n - this.bufferReadPos;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n != 1) {
            throw new IOException("No byte read.");
        }
        return byArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.localRead(byArray, n, n2, false);
    }

    public long skip(long l) throws IOException, IllegalArgumentException {
        if (l > Long.MAX_VALUE) {
            throw new IllegalArgumentException("Only value lesser 2147483647are accepted.");
        }
        return this.localRead(null, 0, (int)l, true);
    }

    protected int localRead(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        byte[] byArray2;
        int n3 = n2;
        int n4 = n;
        while ((byArray2 = this.llos.bufferList.peek()) != null && n3 != 0) {
            int n5 = byArray2.length - this.bufferReadPos;
            if (n3 >= n5) {
                if (!bl) {
                    System.arraycopy(byArray2, this.bufferReadPos, byArray, n4, n5);
                }
                this.llos.bufferList.remove();
                this.bufferReadPos = 0;
                if ((n3 -= n5) == 0) {
                    return n2;
                }
                n4 += n5;
                continue;
            }
            if (!bl) {
                System.arraycopy(byArray2, this.bufferReadPos, byArray, n4, n3);
            }
            this.bufferReadPos += n3;
            return n2;
        }
        return n4 - n;
    }
}

