/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.util;

import org.ow2.petals.util.LoggingUtil;

public final class ParameterCheckHelper {
    private static final String MUST_NOT_BE_EMPTY = " must not be empty";
    private static final String MUST_NOT_BE_NULL = " must not be null";

    private ParameterCheckHelper() {
    }

    public static void isEmptyParameter(String string, String string2) throws IllegalArgumentException {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException(String.valueOf(string2) + MUST_NOT_BE_EMPTY);
        }
    }

    public static void isEmptyParameterWithLog(String string, String string2, LoggingUtil loggingUtil) throws IllegalArgumentException {
        if (string != null && string.length() == 0) {
            loggingUtil.error(String.valueOf(string2) + MUST_NOT_BE_EMPTY);
            throw new IllegalArgumentException(String.valueOf(string2) + MUST_NOT_BE_EMPTY);
        }
    }

    public static void isNullParameter(Object object, String string) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(String.valueOf(string) + MUST_NOT_BE_NULL);
        }
    }

    public static void isNullParameterWithLog(Object object, String string, LoggingUtil loggingUtil) throws IllegalArgumentException {
        if (object == null) {
            loggingUtil.error(String.valueOf(string) + MUST_NOT_BE_NULL);
            throw new IllegalArgumentException(String.valueOf(string) + MUST_NOT_BE_NULL);
        }
    }

    public static void isNullOrEmptyParameter(String string, String string2) {
        ParameterCheckHelper.isEmptyParameter(string, string2);
        ParameterCheckHelper.isNullParameter(string, string2);
    }

    public static void isNullOrEmptyParameterWithLog(String string, String string2, LoggingUtil loggingUtil) {
        ParameterCheckHelper.isEmptyParameterWithLog(string, string2, loggingUtil);
        ParameterCheckHelper.isNullParameterWithLog(string, string2, loggingUtil);
    }
}

