/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.petals.commons.threadlocal.Transformers;
import org.ow2.petals.util.StringHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtil {
    private static final Logger LOGGER = Logger.getLogger(XMLUtil.class.getName());

    private XMLUtil() {
    }

    public static Node createAttribute(Document document, String string, String string2) {
        Attr attr = null;
        if (document != null) {
            attr = document.createAttribute(string);
            attr.setNodeValue(string2);
        }
        return attr;
    }

    public static Node createNode(Document document, String string, String ... stringArray) {
        Element element = null;
        if (document != null && stringArray.length % 2 == 0) {
            element = document.createElement(string);
            int n = 0;
            while (n < stringArray.length) {
                element.getAttributes().setNamedItem(XMLUtil.createAttribute(document, stringArray[n], stringArray[n + 1]));
                n += 2;
            }
        }
        return element;
    }

    public static Node findChild(Node node, String string, boolean bl) {
        Node node2 = null;
        if (node != null && string != null) {
            node.normalize();
            NodeList nodeList = node.getChildNodes();
            node2 = XMLUtil.lookupNodeInNodeList(string, nodeList);
            if (node2 == null && bl) {
                int n = 0;
                while (n < nodeList.getLength() && node2 == null) {
                    node2 = XMLUtil.findChild(nodeList.item(n), string, true);
                    ++n;
                }
            }
        }
        return node2;
    }

    private static Node lookupNodeInNodeList(String string, NodeList nodeList) {
        Node node = null;
        int n = 0;
        while (n < nodeList.getLength() && node == null) {
            if (string.equals(nodeList.item(n).getNodeName())) {
                node = nodeList.item(n);
            }
            ++n;
        }
        return node;
    }

    public static Node findChild(Node node, String string, String string2, boolean bl) {
        node.normalize();
        String string3 = node.lookupPrefix(string);
        return XMLUtil.findChild(node, String.valueOf(string3) + string2, bl);
    }

    public static String parseToString(Node node) throws TransformerException {
        String string = null;
        if (node != null) {
            node.normalize();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
            StringBuffer stringBuffer = stringWriter.getBuffer();
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String getAttributeValue(Node node, String string) {
        NamedNodeMap namedNodeMap;
        Node node2;
        String string2 = null;
        if (node != null && (node2 = (namedNodeMap = node.getAttributes()).getNamedItem(string)) != null) {
            string2 = node2.getNodeValue();
        }
        return string2;
    }

    public static String getRequiredAttributeValue(Node node, String string) {
        String string2 = null;
        if (node != null && !StringHelper.isNullOrEmpty(string)) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem(string);
            if (node2 == null) {
                throw new NullPointerException("Required attribute '" + string + "' not found in the node.");
            }
            string2 = node2.getNodeValue();
        }
        return string2;
    }

    public static Node getFirstChild(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null && node2.getNodeType() == 3) {
            node2 = node2.getNextSibling();
        }
        return node2;
    }

    public static Node getNextSibling(Node node) {
        Node node2 = null;
        if (node != null) {
            node2 = node.getNextSibling();
            while (node2 != null && node2.getNodeType() == 3) {
                node2 = node2.getNextSibling();
            }
        }
        return node2;
    }

    public static String getTextContent(Node node) {
        String string = null;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 3) {
                string = nodeList.item(n).getNodeValue();
                string = string.replace('\t', ' ').replace('\n', ' ').trim();
                break;
            }
            ++n;
        }
        return string;
    }

    public static String createStringFromDOMDocument(Node node) throws TransformerException {
        return XMLUtil.createStringFromDOMNode(node, false);
    }

    public static String createStringFromDOMNode(Node node) throws TransformerException {
        return XMLUtil.createStringFromDOMNode(node, true);
    }

    public static String createStringFromDOMNode(Node node, boolean bl) throws TransformerException {
        node.normalize();
        DOMSource dOMSource = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (bl) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.transform(dOMSource, streamResult);
        return stringWriter.toString();
    }

    public static Document createDocumentFromString(String string) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            InputSource inputSource = new InputSource(byteArrayInputStream);
            document = documentBuilder.parse(inputSource);
            document.normalize();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.log(Level.SEVERE, "Bad XML parser configuration", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            LOGGER.log(Level.SEVERE, "Bad XML fragment can't be transformed to a DOM tree.", sAXException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Unexpected Error", iOException);
        }
        return document;
    }

    public static List<String> getTextContents(NodeList nodeList) {
        ArrayList<String> arrayList = null;
        if (nodeList != null) {
            arrayList = new ArrayList<String>();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() != 3) {
                    arrayList.add(XMLUtil.getTextContent(node));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static QName extractXmlAttributeQName(Node node, String string) {
        String string2 = XMLUtil.getAttributeValue(node, string);
        QName qName = null;
        if (string2 != null) {
            if (string2.indexOf(58) > -1 && string2.charAt(0) != '{') {
                String string3 = string2.substring(0, string2.indexOf(58));
                String string4 = node.lookupNamespaceURI(string3);
                qName = new QName(string4, string2.substring(string2.indexOf(58) + 1), string3);
            } else {
                qName = QName.valueOf(string2);
            }
        }
        return qName;
    }

    public static QName extractRequiredXmlAttributeQName(Node node, String string) {
        String string2 = XMLUtil.getRequiredAttributeValue(node, string);
        QName qName = null;
        if (string2.indexOf(58) > -1 && string2.charAt(0) != '{') {
            String string3 = string2.substring(0, string2.indexOf(58));
            String string4 = node.lookupNamespaceURI(string3);
            qName = new QName(string4, string2.substring(string2.indexOf(58) + 1), string3);
        } else {
            qName = QName.valueOf(string2);
        }
        return qName;
    }

    public static List<Node> getNodeChildren(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (node2.getNodeType() == 1) {
                    arrayList.add(node2);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static Node getNode(Document document, String string) {
        NodeList nodeList;
        Node node = null;
        if (document != null && string != null && (nodeList = document.getElementsByTagName(string)) != null && nodeList.getLength() > 0) {
            return nodeList.item(0);
        }
        return node;
    }

    public static Node getNodeWithAttribute(Document document, String string, String string2, String string3) {
        Element element = null;
        if (document != null && string != null && string2 != null && string3 != null) {
            NodeList nodeList = document.getElementsByTagName(string);
            int n = 0;
            while (n < nodeList.getLength() && element == null) {
                Element element2 = (Element)nodeList.item(n);
                if (string3.equals(element2.getAttribute(string2))) {
                    element = element2;
                }
                ++n;
            }
        }
        return element;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeDocument(Document document, OutputStream outputStream) throws Exception {
        if (document == null) throw new Exception("Can not write document to output stream");
        if (outputStream == null) throw new Exception("Can not write document to output stream");
        Transformer transformer = Transformers.getXmlWithDeclarationTransformer();
        try {
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            transformer.reset();
            throw throwable;
        }
        {
            Object var3_5 = null;
            transformer.reset();
            return;
        }
    }

    public static Document loadDocument(InputStream inputStream) throws IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        Document document = null;
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    public static Document newDocument() {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.log(Level.SEVERE, "Bad XML parser configuration", parserConfigurationException);
        }
        return document;
    }
}

