/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.NioUtil;

public final class ZipUtil {
    private ZipUtil() {
    }

    public static File getEntryAsTemp(ZipFile zipFile, String string) throws IOException, PetalsException {
        File file = null;
        InputStream inputStream = null;
        ZipEntry zipEntry = ZipUtil.getZipEntry(zipFile, string);
        inputStream = zipFile.getInputStream(zipEntry);
        file = File.createTempFile("petals-", null);
        NioUtil.copyStreamToFile(inputStream, file);
        return file;
    }

    private static ZipEntry getZipEntry(ZipFile zipFile, String string) throws PetalsException {
        ZipEntry zipEntry = null;
        if (string.indexOf("/") > -1 ? (zipEntry = zipFile.getEntry(string)) == null && (zipEntry = zipFile.getEntry(string.replace("/", "\\"))) == null : (zipEntry = zipFile.getEntry(string)) == null && (zipEntry = zipFile.getEntry(string.replace("\\", "/"))) == null) {
            throw new PetalsException("Zip Entry not found: " + string);
        }
        return zipEntry;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzipEntry(ZipFile zipFile, ZipEntry zipEntry, File file) throws IOException {
        FileOutputStream fileOutputStream;
        block4: {
            InputStream inputStream = null;
            fileOutputStream = null;
            try {
                inputStream = zipFile.getInputStream(zipEntry);
                fileOutputStream = new FileOutputStream(file);
                IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream == null) throw throwable;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (inputStream == null) break block4;
            }
            inputStream.close();
        }
        if (fileOutputStream == null) return;
        ((OutputStream)fileOutputStream).close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzipArchive(File file, File file2) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file3 = null;
                file3 = file2 != null ? new File(file2, zipEntry.getName()) : new File(zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (file3.mkdirs()) continue;
                    throw new IOException("Error creating directory: " + file3);
                }
                File file4 = file3.getParentFile();
                if (file4 != null && !file4.exists() && !file4.mkdirs()) {
                    throw new IOException("Error creating directory: " + file4);
                }
                ZipUtil.unzipEntry(zipFile, zipEntry, file3);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            zipFile.close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        zipFile.close();
    }
}

