/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.printwriter;

import java.io.PrintStream;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Loggable;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.wrapper.printwriter.EmptyOutputStream;

public class PrintStreamImpl
extends PrintStream
implements Loggable {
    protected Logger logger = null;
    protected LoggerFactory loggerFactory = null;
    protected String currentLine = "";
    protected int level;

    public PrintStreamImpl(Logger l) throws NullPointerException {
        super(new EmptyOutputStream());
        if (l == null) {
            throw new NullPointerException("Logger parameter is null");
        }
        this.logger = l;
        this.level = BasicLevel.DEBUG;
    }

    public PrintStreamImpl(Logger l, int level) throws NullPointerException {
        super(new EmptyOutputStream());
        if (l == null) {
            throw new NullPointerException("Logger parameter is null");
        }
        this.logger = l;
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public void setLoggerFactory(LoggerFactory lf) {
        this.loggerFactory = lf;
    }

    public void write(byte[] bytes) {
        this.currentLine = this.currentLine + new String(bytes);
    }

    public boolean equals(Object o) {
        return o instanceof PrintStreamImpl && ((PrintStreamImpl)o).logger == this.logger;
    }

    public void flush() {
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void close() {
    }

    public String toString() {
        return this.logger.toString();
    }

    public boolean checkError() {
        return false;
    }

    protected void setError() {
    }

    public void write(int i) {
        this.currentLine = this.currentLine + i;
    }

    public void write(byte[] bytes, int i, int i1) {
        this.currentLine = this.currentLine + new String(bytes, i, i1);
    }

    public void print(boolean b) {
        this.currentLine = this.currentLine + b;
    }

    public void print(char c) {
        this.currentLine = this.currentLine + c;
    }

    public void print(int i) {
        this.currentLine = this.currentLine + i;
    }

    public void print(long l) {
        this.currentLine = this.currentLine + l;
    }

    public void print(float v) {
        this.currentLine = this.currentLine + v;
    }

    public void print(double v) {
        this.currentLine = this.currentLine + v;
    }

    public void print(char[] chars) {
        this.logger.log(this.level, (Object)(this.currentLine + new String(chars)));
        this.currentLine = "";
    }

    public void print(String s) {
        this.currentLine = this.currentLine + s;
    }

    public void print(Object o) {
        this.currentLine = this.currentLine + o;
    }

    public void println() {
        this.logger.log(this.level, (Object)this.currentLine);
        this.currentLine = "";
    }

    public void println(boolean b) {
        this.logger.log(this.level, (Object)(this.currentLine + b));
        this.currentLine = "";
    }

    public void println(char c) {
        this.logger.log(this.level, (Object)(this.currentLine + c));
        this.currentLine = "";
    }

    public void println(int i) {
        this.logger.log(this.level, (Object)(this.currentLine + i));
        this.currentLine = "";
    }

    public void println(long l) {
        this.logger.log(this.level, (Object)(this.currentLine + l));
        this.currentLine = "";
    }

    public void println(float v) {
        this.logger.log(this.level, (Object)(this.currentLine + v));
        this.currentLine = "";
    }

    public void println(double v) {
        this.logger.log(this.level, (Object)(this.currentLine + v));
        this.currentLine = "";
    }

    public void println(char[] chars) {
        this.logger.log(this.level, (Object)(this.currentLine + new String(chars)));
        this.currentLine = "";
    }

    public void println(String s) {
        this.logger.log(this.level, (Object)(this.currentLine + s));
        this.currentLine = "";
    }

    public void println(Object o) {
        this.logger.log(this.level, (Object)(this.currentLine + o));
        this.currentLine = "";
    }
}

