/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jbi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.ow2.petals.commons.threadlocal.DocumentBuilders;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.kernel.api.service.Location;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.petalslink.dsb.jbi.Adapter;
import org.petalslink.dsb.service.client.Client;
import org.petalslink.dsb.service.client.ClientException;
import org.petalslink.dsb.service.client.Message;
import org.petalslink.dsb.service.client.MessageListener;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBISender
implements Client {
    public static final String PROTOCOL_HEADERS = "javax.jbi.messaging.protocol.headers";
    public static final String NAMESPACE_URI = "http://www.w3.org/2005/08/addressing";
    public static final String PREFIX = "wsa";
    public static final QName TO_QNAME = new QName("http://www.w3.org/2005/08/addressing", "To", "wsa");
    public static final QName ADDRESS_QNAME = new QName("http://www.w3.org/2005/08/addressing", "Address", "wsa");
    private ComponentContext componentContext;
    private Logger logger;
    private MessageExchangeFactory messageExchangeFactory;
    private org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint;
    private String name;

    public JBISender(ComponentContext componentContext, org.petalslink.dsb.api.ServiceEndpoint endpoint) {
        this.componentContext = componentContext;
        this.serviceEndpoint = endpoint;
        this.name = this.componentContext.getComponentName();
        try {
            this.messageExchangeFactory = this.componentContext.getDeliveryChannel().createExchangeFactory();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        try {
            this.logger = this.componentContext.getLogger("", null);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        catch (JBIException e) {
            e.printStackTrace();
        }
    }

    public void fireAndForget(Message message) throws ClientException {
        try {
            InOptionalOut messageExchange = this.messageExchangeFactory.createInOptionalOutExchange();
            this.send(message, (MessageExchange)messageExchange, message.getOperation(), false);
        }
        catch (MessagingException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public Message sendReceive(Message message) throws ClientException {
        System.out.println("Send Receive");
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("SendReceive message");
        }
        Message result = null;
        try {
            InOut messageExchange = this.messageExchangeFactory.createInOutExchange();
            result = this.send(message, (MessageExchange)messageExchange, message.getOperation(), true);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Messager has been sent, we have a response");
                this.logger.fine("Out message is " + result);
            }
        }
        catch (MessagingException e) {
            throw new ClientException((Throwable)e);
        }
        return result;
    }

    private Message send(Message message, MessageExchange messageExchange, QName operation, boolean synchronous) throws MessagingException, ClientException {
        Map<QName, String> addressing;
        NormalizedMessage normalizedMessage = Adapter.transform(message);
        messageExchange.setMessage(normalizedMessage, "in");
        messageExchange.setOperation(operation);
        Map props = message.getProperties();
        if (props != null) {
            for (String key : props.keySet()) {
                normalizedMessage.setProperty(key, props.get(key));
            }
        }
        if (this.serviceEndpoint.getInterfaces() != null && this.serviceEndpoint.getInterfaces().length >= 1) {
            messageExchange.setInterfaceName(this.serviceEndpoint.getInterfaces()[0]);
        }
        if ((addressing = this.getAddressing(message)).size() > 0) {
            this.setInAddressing(normalizedMessage, addressing);
        }
        if (!Boolean.parseBoolean(message.getProperty("DSBCLIENT.CLEANENDPOINT"))) {
            messageExchange.setEndpoint((javax.jbi.servicedesc.ServiceEndpoint)new ServiceEndpoint(){

                public QName getServiceName() {
                    return JBISender.this.serviceEndpoint.getServiceName();
                }

                public QName[] getInterfaces() {
                    return JBISender.this.serviceEndpoint.getInterfaces();
                }

                public String getEndpointName() {
                    return JBISender.this.serviceEndpoint.getEndpointName();
                }

                public DocumentFragment getAsReference(QName operationName) {
                    return null;
                }

                public ServiceEndpoint.EndpointType getType() {
                    return ServiceEndpoint.EndpointType.EXTERNAL;
                }

                public void setType(ServiceEndpoint.EndpointType type) {
                }

                public List<QName> getInterfacesName() {
                    if (JBISender.this.serviceEndpoint.getInterfaces() != null) {
                        return Arrays.asList(JBISender.this.serviceEndpoint.getInterfaces());
                    }
                    return new ArrayList<QName>(0);
                }

                public Document getDescription() {
                    return null;
                }

                public Location getLocation() {
                    return new Location();
                }
            });
        }
        if (!synchronous) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Let's send the message to the delivery channel with send()...");
            }
            this.componentContext.getDeliveryChannel().send(messageExchange);
        } else {
            boolean invoke;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Let's send the message to the delivery channel with sendSync()");
            }
            if (invoke = this.componentContext.getDeliveryChannel().sendSync(messageExchange)) {
                if (ExchangeStatus.ERROR.equals(messageExchange.getStatus())) {
                    throw this.createFromOutMessage(messageExchange);
                }
                if (ExchangeStatus.ACTIVE.equals(messageExchange.getStatus())) {
                    normalizedMessage = messageExchange.getFault();
                    if (normalizedMessage == null) {
                        normalizedMessage = messageExchange.getMessage("out");
                    }
                    messageExchange.setStatus(ExchangeStatus.DONE);
                    this.componentContext.getDeliveryChannel().send(messageExchange);
                    if (normalizedMessage != null) {
                        return Adapter.transform(normalizedMessage);
                    }
                }
            } else {
                throw this.createFromOutMessage(messageExchange);
            }
        }
        return null;
    }

    public void sendAsync(Message message, MessageListener listener) throws ClientException {
        Message out = this.sendReceive(message);
        if (listener != null && out != null) {
            listener.onMessage(out);
        }
    }

    public String getName() {
        return this.name;
    }

    protected ClientException createFromOutMessage(MessageExchange messageExchange) {
        ClientException result = null;
        String message = null;
        if (ExchangeStatus.ERROR.equals(messageExchange.getStatus())) {
            message = "Got an ERROR while trying to send message to service, cause : TODO serialize ERROR";
            result = new ClientException(message);
        } else if (messageExchange.getFault() != null) {
            message = "Got a FAULT while invoking service, cause : TODO serialize Fault";
            result = new ClientException(message);
        } else {
            message = "Got something wrong while invoking service...";
            result = new ClientException(message);
        }
        return result;
    }

    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    protected Map<QName, String> getAddressing(Message message) {
        Map props;
        HashMap<QName, String> result = new HashMap<QName, String>();
        if (message != null && message.getProperties() != null && (props = message.getProperties()).get(TO_QNAME.toString()) != null) {
            result.put(TO_QNAME, (String)props.get(TO_QNAME.toString()));
        }
        return result;
    }

    private void setInAddressing(NormalizedMessage message, Map<QName, String> addressing) {
        QName key;
        Object o = message.getProperty(PROTOCOL_HEADERS);
        HashMap<QName, String> remains = new HashMap<QName, String>(addressing);
        HashMap<String, DocumentFragment> headers = null;
        if (o != null && o instanceof Map) {
            headers = (HashMap<String, DocumentFragment>)o;
            for (Map.Entry<QName, String> entry : addressing.entrySet()) {
                key = entry.getKey();
                DocumentFragment destFrag = (DocumentFragment)headers.get(key.toString());
                if (destFrag == null || destFrag.getFirstChild() == null || !(destFrag.getFirstChild() instanceof Element)) continue;
                destFrag.getFirstChild().setTextContent(entry.getValue());
                remains.remove(key);
            }
        } else {
            headers = new HashMap<String, DocumentFragment>(remains.size());
        }
        for (Map.Entry<QName, String> entry : remains.entrySet()) {
            key = entry.getKey();
            DocumentFragment df = JBISender.getElement(key, entry.getValue());
            if (df == null) continue;
            headers.put(key.toString(), df);
        }
        message.setProperty(PROTOCOL_HEADERS, headers);
    }

    public static final DocumentFragment getElement(QName qname, String text) {
        DocumentFragment result = null;
        if (qname.equals(TO_QNAME)) {
            result = JBISender.getToFragment(text);
        }
        return result;
    }

    public static final DocumentFragment getToFragment(String text) {
        DocumentFragment result = JBISender.createDocumentFragment(TO_QNAME);
        result.getFirstChild().setTextContent(text);
        result.normalize();
        return result;
    }

    protected static final Element createAddressElement(String content) {
        DocumentBuilder docBuilder = DocumentBuilders.getJvmDocumentBuilder();
        Document doc = docBuilder.newDocument();
        QName address = ADDRESS_QNAME;
        Element e = doc.createElementNS(address.getNamespaceURI(), address.getLocalPart());
        e.setPrefix(address.getPrefix());
        e.setTextContent(content);
        e.normalize();
        return e;
    }

    protected static final DocumentFragment createDocumentFragment(QName documentName) {
        DocumentFragment result = null;
        DocumentBuilder docBuilder = DocumentBuilders.getJvmDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element elt = doc.createElementNS(documentName.getNamespaceURI(), documentName.getLocalPart());
        elt.setPrefix(documentName.getPrefix());
        result = doc.createDocumentFragment();
        result.appendChild(doc.importNode(elt, true));
        result.normalize();
        return result;
    }
}

