/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.fractal.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.util.Fractal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractalHelper {
    private static Logger logger = Logger.getLogger((String)FractalHelper.class.getName());

    public static Component getRootComponent(Component component) {
        Component parent = null;
        try {
            Component[] parents = null;
            SuperController superController = Fractal.getSuperController(component);
            parents = superController.getFcSuperComponents();
            if (parents == null || parents.length == 0) {
                return component;
            }
            if (parents.length > 1) {
                // empty if block
            }
            if (parents.length == 1) {
                parent = FractalHelper.getRootComponent(parents[0]);
            }
        }
        catch (NoSuchInterfaceException e) {
            parent = component;
        }
        return parent;
    }

    public static final List<Component> getAllComponentsWithAnnotation(ContentController parentContentController, Class<? extends Annotation> annotation) {
        ArrayList<Component> components = new ArrayList<Component>();
        ContentController subContentController = null;
        for (Component component : parentContentController.getFcSubComponents()) {
            try {
                subContentController = Fractal.getContentController(component);
                if (subContentController.getFcSubComponents().length > 0) {
                    components.addAll(FractalHelper.getAllComponentsWithAnnotation(subContentController, annotation));
                }
            }
            catch (NoSuchInterfaceException e1) {
                // empty catch block
            }
            try {
                Object o = component.getFcInterface("/content");
                if (o == null || !o.getClass().isAnnotationPresent(annotation)) continue;
                components.add(component);
            }
            catch (NoSuchInterfaceException e) {
                // empty catch block
            }
        }
        return components;
    }

    public static final List<Component> getAllComponentsWithMethodAnnotation(ContentController parentContentController, Class<? extends Annotation> annotation) {
        ArrayList<Component> components = new ArrayList<Component>();
        ContentController subContentController = null;
        for (Component component : parentContentController.getFcSubComponents()) {
            Method[] methods;
            try {
                subContentController = Fractal.getContentController(component);
                if (subContentController.getFcSubComponents().length > 0) {
                    components.addAll(FractalHelper.getAllComponentsWithMethodAnnotation(subContentController, annotation));
                }
            }
            catch (NoSuchInterfaceException e1) {
                // empty catch block
            }
            Object o = FractalHelper.getContent(component);
            if (o == null) continue;
            for (Method m : methods = o.getClass().getMethods()) {
                if (!m.isAnnotationPresent(annotation)) continue;
                components.add(component);
            }
        }
        return components;
    }

    public static final List<Component> getAllComponentsWithInterface(ContentController parentContentController, Class<?> clazz) {
        ArrayList<Component> components = new ArrayList<Component>();
        ContentController subContentController = null;
        for (Component component : parentContentController.getFcSubComponents()) {
            try {
                subContentController = Fractal.getContentController(component);
                if (subContentController.getFcSubComponents().length > 0) {
                    components.addAll(FractalHelper.getAllComponentsWithInterface(subContentController, clazz));
                }
            }
            catch (NoSuchInterfaceException e1) {
                // empty catch block
            }
            Object o = FractalHelper.getContent(component);
            try {
                clazz.cast(o);
                components.add(component);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return components;
    }

    public static final ContentController getContentController(Component component) {
        ContentController cc = null;
        if (component != null) {
            try {
                cc = Fractal.getContentController(component);
            }
            catch (NoSuchInterfaceException e) {
                logger.debug((Object)e.getMessage());
            }
        }
        return cc;
    }

    public static boolean isComposite(Component component) {
        boolean result = false;
        if (component != null) {
            try {
                ContentController controller = Fractal.getContentController(component);
                result = controller.getFcSubComponents().length > 1;
            }
            catch (NoSuchInterfaceException e) {
                logger.debug((Object)e.getMessage());
            }
        }
        return result;
    }

    public static Set<Component> getAllComponents(ContentController parentContentController) {
        HashSet<Component> result = new HashSet<Component>();
        ContentController subContentController = null;
        for (Component component : parentContentController.getFcSubComponents()) {
            try {
                subContentController = Fractal.getContentController(component);
                if (subContentController != null && subContentController.getFcSubComponents().length > 0) {
                    result.addAll(FractalHelper.getAllComponents(subContentController));
                }
            }
            catch (NoSuchInterfaceException e1) {
                // empty catch block
            }
            if (FractalHelper.isComposite(component)) continue;
            result.add(component);
        }
        return result;
    }

    public static final Object getContent(Component component) {
        Object result = null;
        try {
            result = component.getFcInterface("/content");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return result;
    }

    public static String getName(Component component) {
        String result = null;
        try {
            NameController nc = Fractal.getNameController(component);
            result = nc.getFcName();
        }
        catch (NoSuchInterfaceException e) {
            result = "NameNotFound";
        }
        return result;
    }
}

