/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.attributes;

import java.lang.reflect.Method;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Loader;
import org.objectweb.fractal.adl.attributes.Attribute;
import org.objectweb.fractal.adl.attributes.Attributes;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.interfaces.IDLException;
import org.objectweb.fractal.adl.interfaces.IDLLoader;
import org.objectweb.fractal.api.NoSuchInterfaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeLoader
extends AbstractLoader {
    public static final String INTERFACE_LOADER_BINDING = "interface-loader";
    public IDLLoader interfaceLoaderItf;

    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d, context);
        return d;
    }

    private void checkNode(Object node, Map<Object, Object> context) throws ADLException {
        if (node instanceof AttributesContainer) {
            this.checkAttributesContainer((AttributesContainer)node, context);
        }
        if (node instanceof ComponentContainer) {
            for (Component comp : ((ComponentContainer)node).getComponents()) {
                this.checkNode(comp, context);
            }
        }
    }

    private void checkAttributesContainer(AttributesContainer container, Map<Object, Object> context) throws ADLException {
        Attributes attrs = container.getAttributes();
        if (attrs != null) {
            Class c;
            String signature = attrs.getSignature();
            if (signature == null) {
                throw new ADLException("Signature missing", attrs);
            }
            try {
                c = (Class)this.interfaceLoaderItf.loadInterface(attrs.getSignature(), context);
            }
            catch (IDLException e) {
                throw new ADLException("Invalid signature '" + signature + "'", attrs, e);
            }
            for (Attribute attribute : attrs.getAttributes()) {
                Method getter;
                String attrName = attribute.getName();
                String attrValue = attribute.getValue();
                if (attrName == null) {
                    throw new ADLException("Attribute name missing", attribute);
                }
                if (attrValue == null) {
                    throw new ADLException("Attribute value missing", attribute);
                }
                String getterName = "get" + Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
                try {
                    getter = c.getMethod(getterName, new Class[0]);
                }
                catch (Exception e) {
                    throw new ADLException("No such attribute", attribute, e);
                }
                Class<?> attrType = getter.getReturnType();
                if (attrType.isPrimitive()) {
                    if (attrType.equals(Integer.TYPE)) {
                        try {
                            Integer.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad integer value: " + attrValue, attribute);
                        }
                    }
                    if (attrType.equals(Long.TYPE)) {
                        try {
                            Long.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad long value: " + attrValue, attribute);
                        }
                    }
                    if (attrType.equals(Float.TYPE)) {
                        try {
                            Float.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad float value: " + attrValue, attribute);
                        }
                    }
                    if (attrType.equals(Double.TYPE)) {
                        try {
                            Double.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad double value: " + attrValue, attribute);
                        }
                    }
                    if (attrType.equals(Byte.TYPE)) {
                        try {
                            Byte.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad byte value: " + attrValue, attribute);
                        }
                    }
                    if (attrType.equals(Character.TYPE)) {
                        if (attrValue.length() == 1) continue;
                        throw new ADLException("Bad char value: " + attrValue, attribute);
                    }
                    if (attrType.equals(Short.TYPE)) {
                        try {
                            Short.valueOf(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ADLException("Bad short value: " + attrValue, attribute);
                        }
                    }
                    if (attrType.equals(Boolean.TYPE)) {
                        if (attrValue.equals("true") || attrValue.equals("false")) continue;
                        throw new ADLException("Bad boolean value: " + attrValue, attribute);
                    }
                    throw new ADLException("Unexpected case", attribute);
                }
                if (attrType == String.class) continue;
                throw new ADLException("Unsupported attribute type: " + attrType, attribute);
            }
        }
    }

    @Override
    public String[] listFc() {
        return new String[]{"client-loader", INTERFACE_LOADER_BINDING};
    }

    @Override
    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if ("client-loader".equals(s)) {
            return this.clientLoader;
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            return this.interfaceLoaderItf;
        }
        throw new NoSuchInterfaceException("There is no interface named '" + s + "'");
    }

    @Override
    public void bindFc(String s, Object o) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if ("client-loader".equals(s)) {
            this.clientLoader = (Loader)o;
        } else if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceLoaderItf = (IDLLoader)o;
        } else {
            throw new NoSuchInterfaceException("There is no interface named '" + s + "'");
        }
    }

    @Override
    public void unbindFc(String s) {
        if ("client-loader".equals(s)) {
            this.clientLoader = null;
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceLoaderItf = null;
        }
    }
}

