/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnboundInterfaceDetectorLoader
extends AbstractLoader {
    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkDefinition(d);
        return d;
    }

    private void checkDefinition(Definition definition) throws ADLException {
        HashMap<Component, List<TypeInterface_Node>> unboundMandatoryClientInterfacesMap = new HashMap<Component, List<TypeInterface_Node>>();
        this.checkNode(definition, unboundMandatoryClientInterfacesMap);
        for (Map.Entry entry : unboundMandatoryClientInterfacesMap.entrySet()) {
            Component comp = (Component)entry.getKey();
            List list = (List)entry.getValue();
            for (TypeInterface_Node itfNode : list) {
                System.err.println("Warning: Mandatory client interface '" + comp.getName() + '.' + itfNode.itf.getName() + " is not bound (" + itfNode.node.astGetSource() + ")");
            }
        }
    }

    private void checkNode(Object node, Map<Component, List<TypeInterface_Node>> unboundMandatoryClientInterfacesMap) throws ADLException {
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            if (comps.length > 0) {
                HashSet<String> bindingClientsSet = new HashSet<String>();
                if (node instanceof BindingContainer) {
                    for (Binding binding : ((BindingContainer)node).getBindings()) {
                        bindingClientsSet.add(binding.getFrom());
                    }
                }
                for (Component comp : comps) {
                    List<TypeInterface_Node> unboundMandatoryClientInterfacesList = null;
                    if (comp.astGetDecoration("areMandatoryClientInterfacesChecked") == null) {
                        comp.astSetDecoration("areMandatoryClientInterfacesChecked", "yes");
                        if (!(comp instanceof InterfaceContainer)) continue;
                        for (Interface itf : ((InterfaceContainer)((Object)comp)).getInterfaces()) {
                            TypeInterface titf = (TypeInterface)itf;
                            if (!"client".equals(titf.getRole()) || !this.isMandatoryInterface(titf) || this.isBoundInterface(bindingClientsSet, comp.getName(), titf)) continue;
                            if (unboundMandatoryClientInterfacesList == null) {
                                unboundMandatoryClientInterfacesList = new ArrayList<TypeInterface_Node>();
                                unboundMandatoryClientInterfacesMap.put(comp, unboundMandatoryClientInterfacesList);
                            }
                            unboundMandatoryClientInterfacesList.add(new TypeInterface_Node(titf, (Node)node));
                        }
                        continue;
                    }
                    unboundMandatoryClientInterfacesList = unboundMandatoryClientInterfacesMap.get(comp);
                    if (unboundMandatoryClientInterfacesList == null) continue;
                    Iterator<TypeInterface_Node> iter = unboundMandatoryClientInterfacesList.iterator();
                    while (iter.hasNext()) {
                        TypeInterface_Node itfNode = iter.next();
                        if (!this.isBoundInterface(bindingClientsSet, comp.getName(), itfNode.itf)) continue;
                        iter.remove();
                    }
                    if (unboundMandatoryClientInterfacesList.size() != 0) continue;
                    unboundMandatoryClientInterfacesMap.remove(comp);
                }
                if (node instanceof InterfaceContainer) {
                    for (Interface itf : ((InterfaceContainer)node).getInterfaces()) {
                        TypeInterface titf = (TypeInterface)itf;
                        if (!"server".equals(titf.getRole()) || !this.isMandatoryInterface(titf) || titf.getName().endsWith("controller") || titf.getName().equals("component") || titf.getName().equals("factory") || this.isBoundInterface(bindingClientsSet, "this", titf)) continue;
                        String name = null;
                        if (node instanceof Definition) {
                            name = ((Definition)node).getName();
                        } else if (node instanceof Component) {
                            name = ((Component)node).getName();
                        }
                        throw new ADLException("Internal client interface of the server interface \"" + titf.getName() + "\" of the composite \"" + name + "\" is not bound", (Node)node);
                    }
                }
            }
            for (Component comp : comps) {
                this.checkNode(comp, unboundMandatoryClientInterfacesMap);
            }
        }
    }

    private boolean isBoundInterface(Set<String> presentBindings, String prefix, TypeInterface itf) {
        String itfName = prefix + "." + itf.getName();
        if (this.isSingletonInterface(itf)) {
            return presentBindings.contains(itfName);
        }
        for (String binding : presentBindings) {
            if (!binding.startsWith(itfName)) continue;
            return true;
        }
        return false;
    }

    private boolean isMandatoryInterface(TypeInterface itf) {
        String contingency = itf.getContingency();
        return contingency == null || "mandatory".equals(contingency);
    }

    private boolean isSingletonInterface(TypeInterface itf) {
        String cardinality = itf.getCardinality();
        return cardinality == null || "singleton".equals(cardinality);
    }

    static class TypeInterface_Node {
        final TypeInterface itf;
        final Node node;

        TypeInterface_Node(TypeInterface itf, Node node) {
            this.itf = itf;
            this.node = node;
        }
    }
}

