/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.components;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Compiler;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.task.core.TaskMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentCompiler
implements BindingController,
Compiler {
    public static final String PRIMITIVE_COMPILERS_BINDING = "primitive-compilers";
    private final Map<String, PrimitiveCompiler> primitiveCompilers = new TreeMap<String, PrimitiveCompiler>();

    public String[] listFc() {
        return this.primitiveCompilers.keySet().toArray(new String[this.primitiveCompilers.size()]);
    }

    public Object lookupFc(String itf) {
        if (itf.startsWith(PRIMITIVE_COMPILERS_BINDING)) {
            return this.primitiveCompilers.get(itf);
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.startsWith(PRIMITIVE_COMPILERS_BINDING)) {
            this.primitiveCompilers.put(itf, (PrimitiveCompiler)value);
        }
    }

    public void unbindFc(String itf) {
        if (itf.startsWith(PRIMITIVE_COMPILERS_BINDING)) {
            this.primitiveCompilers.remove(itf);
        }
    }

    @Override
    public void compile(Definition definition, TaskMap tasks, Map<Object, Object> context) throws ADLException {
        if (definition instanceof ComponentContainer) {
            this.compile(new ArrayList<ComponentContainer>(), (ComponentContainer)((Object)definition), tasks, context);
        }
    }

    void compile(List<ComponentContainer> path, ComponentContainer container, TaskMap tasks, Map<Object, Object> context) throws ADLException {
        Component[] comps;
        path.add(container);
        for (Component element : comps = container.getComponents()) {
            this.compile(path, element, tasks, context);
        }
        path.remove(path.size() - 1);
        Iterator<PrimitiveCompiler> it = this.primitiveCompilers.values().iterator();
        while (it.hasNext()) {
            it.next().compile(path, container, tasks, context);
        }
    }
}

