/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.timestamp;

import java.io.File;
import java.net.URL;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.merger.MergeException;
import org.objectweb.fractal.adl.merger.MergeableDecoration;

public class Timestamp
implements MergeableDecoration {
    public static final String TIMESTAMP_DECORATION = "timestamp";
    private long timestamp;

    public Object mergeDecoration(Object overridingDecoration) throws MergeException {
        if (overridingDecoration == null) {
            return this;
        }
        if (!(overridingDecoration instanceof Timestamp)) {
            throw new MergeException("Invalid decoration, not a timestamp :" + overridingDecoration);
        }
        if (((Timestamp)overridingDecoration).timestamp > this.timestamp) {
            return overridingDecoration;
        }
        return this;
    }

    public static void setTimestamp(Node node, long timestamp) {
        Timestamp ts = (Timestamp)node.astGetDecoration(TIMESTAMP_DECORATION);
        if (ts == null) {
            ts = new Timestamp();
            ts.timestamp = timestamp;
            node.astSetDecoration(TIMESTAMP_DECORATION, (Object)ts);
        } else if (ts.timestamp < timestamp) {
            ts.timestamp = timestamp;
        }
    }

    public static void setTimestamp(Node node, File file) {
        Timestamp.setTimestamp(node, file.lastModified());
    }

    public static void setTimestamp(Node node, URL url) {
        if (url.getProtocol().equals("file")) {
            Timestamp.setTimestamp(node, new File(url.getPath()));
        } else {
            Timestamp.setTimestamp(node, 0L);
        }
    }

    public static long getTimestamp(Node node) {
        Timestamp ts = (Timestamp)node.astGetDecoration(TIMESTAMP_DECORATION);
        if (ts == null) {
            return 0L;
        }
        return ts.timestamp;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Timestamp) {
            return this.timestamp == ((Timestamp)obj).timestamp;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.timestamp;
    }

    public String toString() {
        return Long.toString(this.timestamp);
    }
}

