/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.types;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Loader;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.interfaces.IDLException;
import org.objectweb.fractal.adl.interfaces.IDLLoader;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeLoader
extends AbstractLoader {
    public static final String INTERFACE_LOADER_BINDING = "interface-loader";
    public IDLLoader interfaceCodeLoaderItf;

    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d, context);
        return d;
    }

    private void checkNode(Object node, Map<Object, Object> context) throws ADLException {
        if (node instanceof InterfaceContainer) {
            this.checkInterfaceContainer((InterfaceContainer)node, context);
        }
        if (node instanceof ComponentContainer) {
            for (Component comp : ((ComponentContainer)node).getComponents()) {
                this.checkNode(comp, context);
            }
        }
    }

    protected void checkInterfaceContainer(InterfaceContainer container, Map<Object, Object> context) throws ADLException {
        for (Interface itf : container.getInterfaces()) {
            if (!(itf instanceof TypeInterface)) continue;
            String signature = ((TypeInterface)itf).getSignature();
            if (signature == null) {
                throw new ADLException("Signature missing", itf);
            }
            try {
                this.interfaceCodeLoaderItf.loadInterface(signature, context);
            }
            catch (IDLException e) {
                throw new ADLException("Invalid signature '" + signature + "'", itf, e);
            }
            String role = ((TypeInterface)itf).getRole();
            if (role == null) {
                throw new ADLException("Role missing", itf);
            }
            if (!role.equals("client") && !role.equals("server")) {
                throw new ADLException("Invalid role '" + role + "'", itf);
            }
            String contingency = ((TypeInterface)itf).getContingency();
            if (contingency != null && !contingency.equals("mandatory") && !contingency.equals("optional")) {
                throw new ADLException("Invalid contingency '" + contingency + "'", itf);
            }
            String cardinality = ((TypeInterface)itf).getCardinality();
            if (cardinality == null || cardinality.equals("singleton") || cardinality.equals("collection")) continue;
            throw new ADLException("Invalid cardinality '" + cardinality + "'", itf);
        }
    }

    @Override
    public void bindFc(String s, Object o) {
        if ("client-loader".equals(s)) {
            this.clientLoader = (Loader)o;
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceCodeLoaderItf = (IDLLoader)o;
        }
    }

    @Override
    public String[] listFc() {
        return new String[]{"client-loader", INTERFACE_LOADER_BINDING};
    }

    @Override
    public Object lookupFc(String s) {
        if ("client-loader".equals(s)) {
            return this.clientLoader;
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            return this.interfaceCodeLoaderItf;
        }
        return null;
    }

    @Override
    public void unbindFc(String s) {
        if ("client-loader".equals(s)) {
            this.clientLoader = null;
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceCodeLoaderItf = null;
        }
    }
}

