/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.util;

public final class Printer {
    public static final String LEVEL_PROPERTY_NAME = "verbose.level";
    public static final String DEBUG_LEVEL = "DEBUG";
    public static final String INFO_LEVEL = "INFO";
    public static final String WARNING_LEVEL = "WARNING";
    public static final String ERROR_LEVEL = "ERROR";
    private static final int DEBUG = 0;
    private static final int INFO = 1;
    private static final int WARNING = 2;
    private static final int ERROR = 3;
    private static int level;

    private Printer() {
    }

    public static void debug(String message) {
        Printer.log(0, message);
    }

    public static void info(String message) {
        Printer.log(1, message);
    }

    public static void warning(String message) {
        Printer.log(2, message);
    }

    public static void error(String message) {
        Printer.log(3, message);
    }

    public static boolean isDebugEnable() {
        return level <= 0;
    }

    public static boolean isInfoEnable() {
        return level <= 1;
    }

    public static boolean isWarningEnable() {
        return level <= 2;
    }

    private static void log(int l, String message) {
        if (level <= l) {
            System.out.println(message);
        }
    }

    static {
        String l = System.getProperty(LEVEL_PROPERTY_NAME, INFO_LEVEL);
        if (DEBUG_LEVEL.equalsIgnoreCase(l)) {
            level = 0;
        } else if (INFO_LEVEL.equalsIgnoreCase(l)) {
            level = 1;
        } else if (WARNING_LEVEL.equalsIgnoreCase(l)) {
            level = 2;
        } else if (ERROR_LEVEL.equalsIgnoreCase(l)) {
            level = 3;
        } else {
            System.err.println("Warning: invalid 'verbose.level'");
        }
    }
}

